/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.spg.processor.data;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ru.noties.spg.anno.SPGKey;
import ru.noties.spg.anno.SPGPreference;
import ru.noties.spg.processor.Logger;
import ru.noties.spg.processor.StringParser;
import ru.noties.spg.processor.data.DefItem;
import ru.noties.spg.processor.data.KeyHolder;
import ru.noties.spg.processor.data.KeyType;
import ru.noties.spg.processor.data.PreferenceDefaults;
import ru.noties.spg.processor.data.PreferenceHolder;
import ru.noties.spg.processor.data.SerializerHolder;
import ru.noties.spg.processor.util.TextUtils;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class SPGPreferenceParser
implements Logger {
    private static final String VOID = Void.class.getCanonicalName();
    private static final Pattern SERIALIZER_TYPES = Pattern.compile(".+<(.+),\\s*(.+)>");
    private static final String NULL = "null";
    private final Logger mLogger;
    private final Types mTypes;
    private final Elements mElements;

    public SPGPreferenceParser(Logger logger, Types types, Elements elements) {
        this.mLogger = logger;
        this.mTypes = types;
        this.mElements = elements;
    }

    /*
     * WARNING - void declaration
     */
    public PreferenceHolder parse(TypeElement element) {
        void var5_8;
        ArrayList<String> imports;
        this.log(Diagnostic.Kind.NOTE, "Processing @SPGPreference: " + element.getSimpleName(), new Object[0]);
        List<? extends Element> enclosed = element.getEnclosedElements();
        ArrayList<Element> keys = new ArrayList<Element>();
        for (Element element2 : enclosed) {
            if (element2.getKind() != ElementKind.FIELD) continue;
            keys.add(element2);
        }
        if (keys.size() == 0) {
            this.log(Diagnostic.Kind.WARNING, "@SPGPreference: %s has no fields", element.getSimpleName());
            return null;
        }
        SPGPreference preference = element.getAnnotation(SPGPreference.class);
        if (!TextUtils.isEmpty(preference.name())) {
            String string = preference.name();
        } else {
            String string = element.getSimpleName().toString();
        }
        boolean prefDefaultName = preference.defaultName();
        int prefMode = preference.sharedPreferenceMode();
        boolean isSingleton = preference.isSingleton();
        String[] importsArray = preference.imports();
        if (importsArray != null && importsArray.length > 0) {
            imports = new ArrayList<String>();
            for (String s : importsArray) {
                imports.add(s);
            }
        } else {
            imports = null;
        }
        List<KeyHolder> keyHolders = this.parseKeys(keys);
        PreferenceDefaults defaults = this.parseDefaults(preference);
        boolean toEntity = preference.toEntity();
        return new PreferenceHolder(element, (String)var5_8, prefDefaultName, prefMode, imports, isSingleton, keyHolders, defaults, toEntity);
    }

    private List<KeyHolder> parseKeys(List<? extends Element> enclosed) {
        ArrayList<KeyHolder> keyHolders = new ArrayList<KeyHolder>();
        for (Element element : enclosed) {
            boolean onUpdate;
            SerializerHolder serializer;
            DefItem defItem;
            String name;
            SPGKey key = element.getAnnotation(SPGKey.class);
            KeyType keyType = KeyType.parse(element.asType());
            if (key == null) {
                name = element.getSimpleName().toString();
                defItem = null;
                serializer = null;
                onUpdate = false;
            } else {
                name = !TextUtils.isEmpty(key.name()) ? key.name() : element.getSimpleName().toString();
                serializer = this.parseSerializer(element, key);
                String keyDefValue = key.defaultValue();
                defItem = !TextUtils.isEmpty(keyDefValue) ? (serializer == null ? SPGPreferenceParser.parseDefaultValue(keyType, key.defaultValue()) : SPGPreferenceParser.parseDefaultValue(serializer.keyType, key.defaultValue())) : null;
                onUpdate = key.onUpdate();
            }
            if (keyType == null && serializer == null) {
                this.log(Diagnostic.Kind.ERROR, "Specified type is not natively supported by SharedPreferences: %s,enclosed element: %s", element.asType(), element.getEnclosingElement());
                return null;
            }
            keyHolders.add(new KeyHolder(element, element.toString(), name, keyType, defItem, serializer, onUpdate));
        }
        if (keyHolders.size() > 0) {
            return keyHolders;
        }
        return null;
    }

    private SerializerHolder parseSerializer(Element element, SPGKey key) {
        SerializerHolder holder;
        try {
            holder = this.parseSerializerClass(key.serializer());
        }
        catch (MirroredTypeException e) {
            holder = this.parseSerializerTypeMirror(element, e.getTypeMirror());
        }
        return holder;
    }

    private SerializerHolder parseSerializerClass(Class<?> c) {
        if (c == Void.class) {
            return null;
        }
        throw new NotImplementedException();
    }

    private SerializerHolder parseSerializerTypeMirror(Element element, TypeMirror typeMirror) {
        TypeMirror serializerTypeMirror;
        String s = typeMirror.toString();
        if (VOID.equals(s)) {
            return null;
        }
        TypeMirror spgInterface = this.extractSPGSerializerInterface(typeMirror);
        if (spgInterface == null) {
            this.log(Diagnostic.Kind.ERROR, "Serializer `%s` does not implement SPGSerializer", typeMirror);
            return null;
        }
        Matcher matcher = SERIALIZER_TYPES.matcher(spgInterface.toString());
        if (!matcher.matches()) {
            this.log(Diagnostic.Kind.ERROR, "Internal error, could not parse types of: %s", spgInterface);
            return null;
        }
        String type = matcher.group(1);
        String repr = matcher.group(2);
        TypeElement reprTypeElement = this.mElements.getTypeElement(repr);
        if (reprTypeElement == null) {
            this.log(Diagnostic.Kind.ERROR, "Serializer `%s` contains representation type parameter as a generic. Type: %s, interface: %s", typeMirror, spgInterface);
            return null;
        }
        TypeMirror reprMirror = reprTypeElement.asType();
        KeyType reprKeyType = KeyType.parse(reprMirror);
        if (reprKeyType == null) {
            this.log(Diagnostic.Kind.ERROR, "Representation type for StormSerializer is not supported: %s", reprMirror);
            return null;
        }
        TypeElement serializerType = this.mElements.getTypeElement(type);
        if (serializerType != null && !(serializerTypeMirror = serializerType.asType()).equals(element.asType())) {
            this.log(Diagnostic.Kind.ERROR, "Type for StormSerializer is wrong: %s, should be: %s", serializerTypeMirror, element.asType());
            return null;
        }
        return new SerializerHolder(s, reprKeyType);
    }

    private TypeMirror extractSPGSerializerInterface(TypeMirror typeMirror) {
        String object = "java.lang.Object";
        TypeElement element = (TypeElement)this.mTypes.asElement(typeMirror);
        if (!element.getSuperclass().toString().equals("java.lang.Object")) {
            while (!element.getSuperclass().toString().equals("java.lang.Object")) {
                TypeMirror si = this.extractSPGSerializerInterface(element);
                if (si != null) {
                    return si;
                }
                element = (TypeElement)this.mTypes.asElement(element.getSuperclass());
            }
        }
        return this.extractSPGSerializerInterface(element);
    }

    private TypeMirror extractSPGSerializerInterface(TypeElement element) {
        List<? extends TypeMirror> interfaces = element.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            if (!typeMirror.toString().startsWith("ru.noties.spg.SPGSerializer")) continue;
            return typeMirror;
        }
        return null;
    }

    private PreferenceDefaults parseDefaults(SPGPreference p) {
        return new PreferenceDefaults.Builder().add(KeyType.BOOL, SPGPreferenceParser.parseDefaultValue(KeyType.BOOL, p.defBool())).add(KeyType.INT, SPGPreferenceParser.parseDefaultValue(KeyType.INT, p.defInt())).add(KeyType.LONG, SPGPreferenceParser.parseDefaultValue(KeyType.LONG, p.defLong())).add(KeyType.FLOAT, SPGPreferenceParser.parseDefaultValue(KeyType.FLOAT, p.defFloat())).add(KeyType.STRING, SPGPreferenceParser.parseDefaultValue(KeyType.STRING, p.defString())).build();
    }

    private static DefItem parseDefaultValue(KeyType type, String pValue) {
        if (type == KeyType.STRING && NULL.equals(pValue)) {
            return new DefItem(null, true);
        }
        if (StringParser.isEvaluationString(pValue)) {
            return new DefItem(StringParser.extractEvaluation(pValue), true);
        }
        return new DefItem(pValue, false);
    }

    @Override
    public void log(Diagnostic.Kind level, String message, Object ... args) {
        this.mLogger.log(level, message, args);
    }
}

