/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedbottompicker.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import gun0912.tedbottompicker.R;

public class TedSquareImageView
extends ImageView {
    String fit_mode;
    private Drawable foreground;

    public TedSquareImageView(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TedSquareImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TedBottomPickerImageView, 0, 0);
        Drawable foreground = a.getDrawable(R.styleable.TedBottomPickerImageView_foreground);
        if (foreground != null) {
            this.setForeground(foreground);
        }
        try {
            this.fit_mode = a.getString(R.styleable.TedBottomPickerImageView_fit_mode);
        }
        finally {
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if ("height".equals(this.fit_mode)) {
            this.setMeasuredDimension(heightMeasureSpec, heightMeasureSpec);
        } else {
            this.setMeasuredDimension(widthMeasureSpec, widthMeasureSpec);
        }
        if (this.foreground != null) {
            this.foreground.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
            this.invalidate();
        }
    }

    public void setForeground(Drawable drawable2) {
        if (this.foreground == drawable2) {
            return;
        }
        if (this.foreground != null) {
            this.foreground.setCallback(null);
            this.unscheduleDrawable(this.foreground);
        }
        this.foreground = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
            if (drawable2.isStateful()) {
                drawable2.setState(this.getDrawableState());
            }
        }
        this.requestLayout();
        this.invalidate();
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.foreground;
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.foreground != null) {
            this.foreground.jumpToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.foreground != null && this.foreground.isStateful()) {
            this.foreground.setState(this.getDrawableState());
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.foreground != null) {
            this.foreground.setBounds(0, 0, w, h);
            this.invalidate();
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.foreground != null) {
            this.foreground.draw(canvas);
        }
    }
}

