/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedbottompicker.adapter;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import gun0912.tedbottompicker.R;
import gun0912.tedbottompicker.TedBottomPicker;
import gun0912.tedbottompicker.view.TedSquareFrameLayout;
import gun0912.tedbottompicker.view.TedSquareImageView;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public class ImageGalleryAdapter
extends RecyclerView.Adapter<GalleryViewHolder> {
    ArrayList<PickerTile> pickerTiles;
    Context context;
    TedBottomPicker.Builder builder;
    OnItemClickListener onItemClickListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageGalleryAdapter(Context context, TedBottomPicker.Builder builder) {
        this.context = context;
        this.builder = builder;
        this.pickerTiles = new ArrayList();
        if (builder.showCamera) {
            this.pickerTiles.add(new PickerTile(2));
        }
        if (builder.showGallery) {
            this.pickerTiles.add(new PickerTile(3));
        }
        Cursor imageCursor = null;
        try {
            String[] columns = new String[]{"_data", "orientation"};
            String orderBy = "date_added DESC";
            imageCursor = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, columns, null, null, "date_added DESC");
            if (imageCursor != null) {
                for (int count = 0; imageCursor.moveToNext() && count < builder.maxCount; ++count) {
                    String imageLocation = imageCursor.getString(imageCursor.getColumnIndex("_data"));
                    File imageFile = new File(imageLocation);
                    this.pickerTiles.add(new PickerTile(Uri.fromFile((File)imageFile)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (imageCursor != null && !imageCursor.isClosed()) {
                imageCursor.close();
            }
        }
    }

    public GalleryViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = View.inflate((Context)this.context, (int)R.layout.grid_item, null);
        GalleryViewHolder holder = new GalleryViewHolder(view);
        return holder;
    }

    public void onBindViewHolder(final GalleryViewHolder holder, final int position) {
        PickerTile pickerTile = this.getItem(position);
        if (pickerTile.isCameraTile()) {
            holder.iv_thumbnail.setBackgroundResource(this.builder.cameraTileBackgroundResId);
            holder.iv_thumbnail.setImageDrawable(this.builder.cameraTileDrawable);
        } else if (pickerTile.isGalleryTile()) {
            holder.iv_thumbnail.setBackgroundResource(this.builder.galleryTileBackgroundResId);
            holder.iv_thumbnail.setImageDrawable(this.builder.galleryTileDrawable);
        } else {
            Uri uri = pickerTile.getImageUri();
            if (this.builder.imageProvider == null) {
                Glide.with((Context)this.context).load(uri).thumbnail(0.1f).dontAnimate().centerCrop().placeholder(R.drawable.ic_gallery).error(R.drawable.img_error).into((ImageView)holder.iv_thumbnail);
            } else {
                this.builder.imageProvider.onProvideImage(holder.iv_thumbnail, uri);
            }
        }
        if (this.onItemClickListener != null) {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ImageGalleryAdapter.this.onItemClickListener.onItemClick(holder.itemView, position);
                }
            });
        }
    }

    public int getItemCount() {
        return this.pickerTiles.size();
    }

    public PickerTile getItem(int position) {
        return this.pickerTiles.get(position);
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    class GalleryViewHolder
    extends RecyclerView.ViewHolder {
        TedSquareFrameLayout root;
        TedSquareImageView iv_thumbnail;

        public GalleryViewHolder(View view) {
            super(view);
            this.root = (TedSquareFrameLayout)view.findViewById(R.id.root);
            this.iv_thumbnail = (TedSquareImageView)view.findViewById(R.id.iv_thumbnail);
        }
    }

    public static class PickerTile {
        public static final int IMAGE = 1;
        public static final int CAMERA = 2;
        public static final int GALLERY = 3;
        protected final Uri imageUri;
        protected final int tileType;

        PickerTile(int tileType) {
            this(null, tileType);
        }

        PickerTile(@NonNull Uri imageUri) {
            this(imageUri, 1);
        }

        protected PickerTile(@Nullable Uri imageUri, int tileType) {
            this.imageUri = imageUri;
            this.tileType = tileType;
        }

        @Nullable
        public Uri getImageUri() {
            return this.imageUri;
        }

        public int getTileType() {
            return this.tileType;
        }

        public boolean isImageTile() {
            return this.tileType == 1;
        }

        public boolean isCameraTile() {
            return this.tileType == 2;
        }

        public boolean isGalleryTile() {
            return this.tileType == 3;
        }

        public String toString() {
            if (this.isImageTile()) {
                return "ImageTile: " + this.imageUri;
            }
            if (this.isCameraTile()) {
                return "CameraTile";
            }
            if (this.isGalleryTile()) {
                return "PickerTile";
            }
            return "Invalid item";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SpecialTileType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TileType {
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

