/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Comparator;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;

public interface GroupSerializer<A>
extends Serializer<A> {
    default public A valueArrayBinaryGet(DataInput2 input, int keysLen, int pos) throws IOException {
        Object keys2 = this.valueArrayDeserialize(input, keysLen);
        return this.valueArrayGet(keys2, pos);
    }

    default public int valueArrayBinarySearch(A key, DataInput2 input, int keysLen, Comparator comparator) throws IOException {
        Object keys2 = this.valueArrayDeserialize(input, keysLen);
        return this.valueArraySearch(keys2, key, comparator);
    }

    public int valueArraySearch(Object var1, A var2);

    public int valueArraySearch(Object var1, A var2, Comparator var3);

    public void valueArraySerialize(DataOutput2 var1, Object var2) throws IOException;

    public Object valueArrayDeserialize(DataInput2 var1, int var2) throws IOException;

    public A valueArrayGet(Object var1, int var2);

    public int valueArraySize(Object var1);

    public Object valueArrayEmpty();

    public Object valueArrayPut(Object var1, int var2, A var3);

    public Object valueArrayUpdateVal(Object var1, int var2, A var3);

    public Object valueArrayFromArray(Object[] var1);

    public Object valueArrayCopyOfRange(Object var1, int var2, int var3);

    public Object valueArrayDeleteValue(Object var1, int var2);

    default public Object[] valueArrayToArray(Object vals) {
        Object[] ret2 = new Object[this.valueArraySize(vals)];
        for (int i = 0; i < ret2.length; ++i) {
            ret2[i] = this.valueArrayGet(vals, i);
        }
        return ret2;
    }

    default public A nextValue(A value) {
        throw new UnsupportedOperationException("Next Value not supported");
    }
}

