/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.stack.mutable.primitive.LongArrayStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.Utils;
import shadow.kotlin.Metadata;
import shadow.kotlin.Unit;
import shadow.kotlin.collections.LongIterator;
import shadow.kotlin.jvm.internal.ArrayIteratorsKt;
import shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import shadow.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 12\u00020\u0001:\u00011B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J=\u0010\u0015\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u0001H\u00162\b\u0010\u001a\u001a\u0004\u0018\u0001H\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ$\u0010\u001e\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016J+\u0010 \u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001cH\u0016\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0018H\u0016J+\u0010(\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u00162\b\u0010)\u001a\u0004\u0018\u0001H\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001cH\u0016\u00a2\u0006\u0002\u0010*J'\u0010+\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\b\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010-J3\u0010.\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u0001H\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001cH\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/mapdb/StoreOnHeap;", "Lorg/mapdb/Store;", "isThreadSafe", "", "(Z)V", "freeRecids", "Lorg/eclipse/collections/impl/stack/mutable/primitive/LongArrayStack;", "isClosed", "()Z", "isReadOnly", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "maxRecid", "Ljava/util/concurrent/atomic/AtomicLong;", "records", "Lorg/eclipse/collections/impl/map/mutable/primitive/LongObjectHashMap;", "", "close", "", "commit", "compact", "compareAndSwap", "R", "recid", "", "expectedOldRecord", "newRecord", "serializer", "Lorg/mapdb/Serializer;", "(JLjava/lang/Object;Ljava/lang/Object;Lorg/mapdb/Serializer;)Z", "delete", "fileLoad", "get", "(JLorg/mapdb/Serializer;)Ljava/lang/Object;", "getAllFiles", "", "", "getAllRecids", "Lshadow/kotlin/collections/LongIterator;", "preallocate", "put", "record", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)J", "unwap", "r", "(Ljava/lang/Object;J)Ljava/lang/Object;", "update", "(JLjava/lang/Object;Lorg/mapdb/Serializer;)V", "verify", "Companion", "mapdb"})
public final class StoreOnHeap
implements Store {
    private final ReentrantReadWriteLock lock;
    private final LongArrayStack freeRecids;
    private final AtomicLong maxRecid;
    private final LongObjectHashMap<Object> records;
    private final boolean isClosed = false;
    private final boolean isReadOnly = false;
    private final boolean isThreadSafe;
    private static final Object NULL_RECORD;
    public static final Companion Companion;

    private final <R> R unwap(Object r, long recid2) {
        if (NULL_RECORD == r) {
            return null;
        }
        if (r == null) {
            throw (Throwable)new DBException.GetVoid(recid2);
        }
        return (R)r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public long preallocate() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            void var3_3;
            long recid2;
            long l = recid2 = this.freeRecids.isEmpty() ? this.maxRecid.incrementAndGet() : this.freeRecids.pop();
            if (this.records.containsKey(recid2)) {
                throw (Throwable)new DBException.DataCorruption("Old data were not null");
            }
            this.records.put(recid2, NULL_RECORD);
            void var8_4 = var3_3;
            return (long)var8_4;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> long put(@Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            long recid2 = this.preallocate();
            Object object = record;
            if (object == null) {
                object = NULL_RECORD;
            }
            this.update(recid2, object, serializer);
            long l = recid2;
            return l;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void update(long recid2, @Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            if (!this.records.containsKey(recid2)) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            Object object = record;
            if (object == null) {
                object = NULL_RECORD;
            }
            Object object2 = this.records.put(recid2, object);
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> boolean compareAndSwap(long recid2, @Nullable R expectedOldRecord, @Nullable R newRecord, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            Object object = this.records.get(recid2);
            if (object == null) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            Object old2 = object;
            R old = this.unwap(old2, recid2);
            if (Intrinsics.areEqual(old, expectedOldRecord) ^ true) {
                boolean bl = false;
                return bl;
            }
            Object object2 = newRecord;
            if (object2 == null) {
                object2 = NULL_RECORD;
            }
            this.records.put(recid2, object2);
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void delete(long recid2, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            if (!this.records.containsKey(recid2)) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            this.records.remove(recid2);
            this.freeRecids.push(recid2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void compact() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <R> R get(long recid2, @NotNull Serializer<R> serializer) {
        Object object;
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            object = this.records.get(recid2);
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
        Object record = object;
        return this.unwap(record, recid2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LongIterator getAllRecids() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            LongIterator longIterator = ArrayIteratorsKt.iterator(this.records.keySet().toArray());
            return longIterator;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    @Override
    public void verify() {
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean fileLoad() {
        return false;
    }

    @Override
    @NotNull
    public Iterable<String> getAllFiles() {
        return new ArrayList();
    }

    @Override
    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    public StoreOnHeap(boolean isThreadSafe) {
        this.isThreadSafe = isThreadSafe;
        this.lock = this.isThreadSafe() ? new ReentrantReadWriteLock() : null;
        this.freeRecids = new LongArrayStack();
        this.maxRecid = new AtomicLong();
        this.records = new LongObjectHashMap();
    }

    public /* synthetic */ StoreOnHeap(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public StoreOnHeap() {
        this(false, 1, null);
    }

    static {
        Companion = new Companion(null);
        NULL_RECORD = new Object();
    }

    @Override
    public void checkThreadSafe() {
        Store.DefaultImpls.checkThreadSafe(this);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/StoreOnHeap$Companion;", "", "()V", "NULL_RECORD", "Ljava/lang/Object;", "mapdb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

