/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.UnsortedMapIterable;
import org.eclipse.collections.api.map.sorted.SortedMapIterable;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.CollectProcedure;
import org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import org.eclipse.collections.impl.block.procedure.CountProcedure;
import org.eclipse.collections.impl.block.procedure.MapEntryToProcedure2;
import org.eclipse.collections.impl.block.procedure.MapPutProcedure;
import org.eclipse.collections.impl.block.procedure.RejectProcedure;
import org.eclipse.collections.impl.block.procedure.SelectProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectByteProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectCharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectIntProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectLongProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectShortProcedure;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.MapAdapter;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.set.sorted.TreeSortedSetMultimap;
import org.eclipse.collections.impl.tuple.AbstractImmutableEntry;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public final class MapIterate {
    private MapIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static boolean isEmpty(Map<?, ?> map2) {
        return map2 == null || map2.isEmpty();
    }

    public static boolean notEmpty(Map<?, ?> map2) {
        return map2 != null && !map2.isEmpty();
    }

    public static <K, V> V getIfAbsentPut(Map<K, V> map2, K key, Function0<? extends V> instanceBlock) {
        if (map2 instanceof MutableMap) {
            return (V)((MutableMap)map2).getIfAbsentPut(key, instanceBlock);
        }
        V result = map2.get(key);
        if (MapIterate.isAbsent(result, map2, key)) {
            result = instanceBlock.value();
            map2.put(key, result);
        }
        return result;
    }

    public static <K, V, P> V getIfAbsentPutWith(Map<K, V> map2, K key, Function<? super P, ? extends V> function, P parameter) {
        V result = map2.get(key);
        if (MapIterate.isAbsent(result, map2, key)) {
            result = function.valueOf(parameter);
            map2.put(key, result);
        }
        return result;
    }

    public static <K, V> V getIfAbsent(Map<K, V> map2, K key, Function0<? extends V> instanceBlock) {
        if (map2 instanceof UnsortedMapIterable) {
            return ((MapIterable)((Object)map2)).getIfAbsent(key, instanceBlock);
        }
        V result = map2.get(key);
        if (MapIterate.isAbsent(result, map2, key)) {
            result = instanceBlock.value();
        }
        return result;
    }

    public static <K, V, P> V getIfAbsentWith(Map<K, V> map2, K key, Function<? super P, ? extends V> function, P parameter) {
        if (map2 instanceof UnsortedMapIterable) {
            return ((MapIterable)((Object)map2)).getIfAbsentWith(key, function, parameter);
        }
        V result = map2.get(key);
        if (MapIterate.isAbsent(result, map2, key)) {
            result = function.valueOf(parameter);
        }
        return result;
    }

    public static <K, V> V getIfAbsentDefault(Map<K, V> map2, K key, V defaultValue) {
        V result = map2.get(key);
        if (MapIterate.isAbsent(result, map2, key)) {
            result = defaultValue;
        }
        return result;
    }

    private static <K, V> boolean isAbsent(V result, Map<K, V> map2, K key) {
        return result == null && !map2.containsKey(key);
    }

    public static <K, V, A> A ifPresentApply(Map<K, V> map2, K key, Function<? super V, ? extends A> function) {
        if (map2 instanceof UnsortedMapIterable) {
            return ((MapIterable)((Object)map2)).ifPresentApply(key, function);
        }
        V result = map2.get(key);
        return MapIterate.isAbsent(result, map2, key) ? null : (A)function.valueOf((V)result);
    }

    public static <K, V> MutableList<V> select(Map<K, V> map2, Predicate<? super V> predicate) {
        return MapIterate.select(map2, predicate, FastList.newList());
    }

    public static <K, V, R extends Collection<V>> R select(Map<K, V> map2, Predicate<? super V> predicate, R targetCollection) {
        SelectProcedure<? super V> procedure = new SelectProcedure<V>(predicate, targetCollection);
        MapIterate.forEachValue(map2, procedure);
        return targetCollection;
    }

    public static <K, V> int count(Map<K, V> map2, Predicate<? super V> predicate) {
        CountProcedure<V> procedure = new CountProcedure<V>(predicate);
        MapIterate.forEachValue(map2, procedure);
        return procedure.getCount();
    }

    public static <K, V> MutableMap<K, V> selectMapOnEntry(Map<K, V> map2, Predicate2<? super K, ? super V> predicate) {
        return MapIterate.selectMapOnEntry(map2, predicate, UnifiedMap.newMap());
    }

    public static <K, V, R extends Map<K, V>> R selectMapOnEntry(Map<K, V> map2, Predicate2<? super K, ? super V> predicate, R target) {
        MapPutProcedure mapTransferProcedure = new MapPutProcedure(target);
        Procedure2<Object, Object> procedure = (key, value) -> {
            if (predicate.accept((Object)key, (Object)value)) {
                mapTransferProcedure.value(key, value);
            }
        };
        MapIterate.forEachKeyValue(map2, procedure);
        return target;
    }

    public static <K, V> MutableMap<K, V> selectMapOnKey(Map<K, V> map2, Predicate<? super K> predicate) {
        UnifiedMap resultMap = UnifiedMap.newMap();
        MapPutProcedure mapTransferProcedure = new MapPutProcedure(resultMap);
        Procedure2<Object, Object> procedure = (key, value) -> {
            if (predicate.accept((Object)key)) {
                mapTransferProcedure.value(key, value);
            }
        };
        MapIterate.forEachKeyValue(map2, procedure);
        return resultMap;
    }

    public static <K, V> MutableMap<K, V> selectMapOnValue(Map<K, V> map2, Predicate<? super V> predicate) {
        UnifiedMap resultMap = UnifiedMap.newMap();
        MapPutProcedure mapTransferProcedure = new MapPutProcedure(resultMap);
        Procedure2<Object, Object> procedure = (key, value) -> {
            if (predicate.accept((Object)value)) {
                mapTransferProcedure.value(key, value);
            }
        };
        MapIterate.forEachKeyValue(map2, procedure);
        return resultMap;
    }

    public static <K, V> MutableList<V> reject(Map<K, V> map2, Predicate<? super V> predicate) {
        return MapIterate.reject(map2, predicate, FastList.newList());
    }

    public static <K, V, R extends Collection<V>> R reject(Map<K, V> map2, Predicate<? super V> predicate, R targetCollection) {
        RejectProcedure<? super V> procedure = new RejectProcedure<V>(predicate, targetCollection);
        MapIterate.forEachValue(map2, procedure);
        return targetCollection;
    }

    public static <K, V> MutableMap<K, V> rejectMapOnEntry(Map<K, V> map2, Predicate2<? super K, ? super V> predicate) {
        return MapIterate.rejectMapOnEntry(map2, predicate, UnifiedMap.newMap());
    }

    public static <K, V, R extends Map<K, V>> R rejectMapOnEntry(Map<K, V> map2, Predicate2<? super K, ? super V> predicate, R target) {
        MapIterate.forEachKeyValue(map2, (argument1, argument2) -> {
            if (!predicate.accept((Object)argument1, (Object)argument2)) {
                target.put(argument1, argument2);
            }
        });
        return target;
    }

    public static <K, V> Collection<K> addAllKeysTo(Map<K, V> map2, Collection<K> targetCollection) {
        MapIterate.forEachKey(map2, CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    public static <K, V> Collection<V> addAllValuesTo(Map<K, V> map2, Collection<V> targetCollection) {
        MapIterate.forEachValue(map2, CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    public static <K, V, A> MutableList<A> collect(Map<K, V> map2, Function<? super V, ? extends A> function) {
        return MapIterate.collect(map2, function, FastList.newList(map2.size()));
    }

    public static <K, V> MutableBooleanCollection collectBoolean(Map<K, V> map2, BooleanFunction<? super V> booleanFunction) {
        return MapIterate.collectBoolean(map2, booleanFunction, new BooleanArrayList(map2.size()));
    }

    public static <K, V, R extends MutableBooleanCollection> R collectBoolean(Map<K, V> map2, BooleanFunction<? super V> booleanFunction, R target) {
        MapIterate.forEachValue(map2, new CollectBooleanProcedure<V>(booleanFunction, target));
        return target;
    }

    public static <K, V> MutableByteCollection collectByte(Map<K, V> map2, ByteFunction<? super V> byteFunction) {
        return MapIterate.collectByte(map2, byteFunction, new ByteArrayList(map2.size()));
    }

    public static <K, V, R extends MutableByteCollection> R collectByte(Map<K, V> map2, ByteFunction<? super V> byteFunction, R target) {
        MapIterate.forEachValue(map2, new CollectByteProcedure<V>(byteFunction, target));
        return target;
    }

    public static <K, V> MutableCharCollection collectChar(Map<K, V> map2, CharFunction<? super V> charFunction) {
        return MapIterate.collectChar(map2, charFunction, new CharArrayList(map2.size()));
    }

    public static <K, V, R extends MutableCharCollection> R collectChar(Map<K, V> map2, CharFunction<? super V> charFunction, R target) {
        MapIterate.forEachValue(map2, new CollectCharProcedure<V>(charFunction, target));
        return target;
    }

    public static <K, V> MutableDoubleCollection collectDouble(Map<K, V> map2, DoubleFunction<? super V> doubleFunction) {
        return MapIterate.collectDouble(map2, doubleFunction, new DoubleArrayList(map2.size()));
    }

    public static <K, V, R extends MutableDoubleCollection> R collectDouble(Map<K, V> map2, DoubleFunction<? super V> doubleFunction, R target) {
        MapIterate.forEachValue(map2, new CollectDoubleProcedure<V>(doubleFunction, target));
        return target;
    }

    public static <K, V> MutableFloatCollection collectFloat(Map<K, V> map2, FloatFunction<? super V> floatFunction) {
        return MapIterate.collectFloat(map2, floatFunction, new FloatArrayList(map2.size()));
    }

    public static <K, V, R extends MutableFloatCollection> R collectFloat(Map<K, V> map2, FloatFunction<? super V> floatFunction, R target) {
        MapIterate.forEachValue(map2, new CollectFloatProcedure<V>(floatFunction, target));
        return target;
    }

    public static <K, V> MutableIntCollection collectInt(Map<K, V> map2, IntFunction<? super V> intFunction) {
        return MapIterate.collectInt(map2, intFunction, new IntArrayList(map2.size()));
    }

    public static <K, V, R extends MutableIntCollection> R collectInt(Map<K, V> map2, IntFunction<? super V> intFunction, R target) {
        MapIterate.forEachValue(map2, new CollectIntProcedure<V>(intFunction, target));
        return target;
    }

    public static <K, V> MutableLongCollection collectLong(Map<K, V> map2, LongFunction<? super V> longFunction) {
        return MapIterate.collectLong(map2, longFunction, new LongArrayList(map2.size()));
    }

    public static <K, V, R extends MutableLongCollection> R collectLong(Map<K, V> map2, LongFunction<? super V> longFunction, R target) {
        MapIterate.forEachValue(map2, new CollectLongProcedure<V>(longFunction, target));
        return target;
    }

    public static <K, V> MutableShortCollection collectShort(Map<K, V> map2, ShortFunction<? super V> shortFunction) {
        return MapIterate.collectShort(map2, shortFunction, new ShortArrayList(map2.size()));
    }

    public static <K, V, R extends MutableShortCollection> R collectShort(Map<K, V> map2, ShortFunction<? super V> shortFunction, R target) {
        MapIterate.forEachValue(map2, new CollectShortProcedure<V>(shortFunction, target));
        return target;
    }

    public static <K, V, K2, V2> MutableMap<K2, V2> collect(Map<K, V> map2, Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return MapIterate.collect(map2, function, UnifiedMap.newMap(map2.size()));
    }

    public static <K1, V1, K2, V2, R extends Map<K2, V2>> R collect(Map<K1, V1> map2, Function2<? super K1, ? super V1, Pair<K2, V2>> function, R target) {
        MapIterate.forEachKeyValue(map2, (key, value) -> {
            Pair pair = (Pair)function.value((Object)key, (Object)value);
            target.put(pair.getOne(), pair.getTwo());
        });
        return target;
    }

    public static <K, V, V2> MutableMap<K, V2> collectValues(Map<K, V> map2, Function2<? super K, ? super V, ? extends V2> function) {
        return MapIterate.collectValues(map2, function, UnifiedMap.newMap(map2.size()));
    }

    public static <K, V, V2, R extends Map<K, V2>> R collectValues(Map<K, V> map2, Function2<? super K, ? super V, ? extends V2> function, R target) {
        MapIterate.forEachKeyValue(map2, (key, value) -> target.put(key, function.value((Object)key, (Object)value)));
        return target;
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collectIf(Map<K1, V1> map2, Function2<? super K1, ? super V1, Pair<K2, V2>> function, Predicate2<? super K1, ? super V1> predicate) {
        return MapIterate.collectIf(map2, function, predicate, UnifiedMap.newMap());
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collectIf(Map<K1, V1> map2, Function2<? super K1, ? super V1, Pair<K2, V2>> function, Predicate2<? super K1, ? super V1> predicate, Map<K2, V2> target) {
        MutableMap result = MapAdapter.adapt(target);
        MapIterate.forEachKeyValue(map2, (key, value) -> {
            if (predicate.accept((Object)key, (Object)value)) {
                Pair pair = (Pair)function.value((Object)key, (Object)value);
                result.put(pair.getOne(), pair.getTwo());
            }
        });
        return result;
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collect(Map<K1, V1> map2, Function<? super K1, ? extends K2> keyFunction, Function<? super V1, ? extends V2> valueFunction) {
        return MapIterate.collect(map2, keyFunction, valueFunction, UnifiedMap.newMap());
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collect(Map<K1, V1> map2, Function<? super K1, ? extends K2> keyFunction, Function<? super V1, ? extends V2> valueFunction, Map<K2, V2> target) {
        return MapIterate.collect(map2, (? super K1 key, ? super V1 value) -> Tuples.pair(keyFunction.valueOf((Object)key), valueFunction.valueOf((Object)value)), MapAdapter.adapt(target));
    }

    public static <K, V, A, R extends Collection<A>> R collect(Map<K, V> map2, Function<? super V, ? extends A> function, R targetCollection) {
        CollectProcedure<? super V, ? extends A> procedure = new CollectProcedure<V, A>(function, targetCollection);
        MapIterate.forEachValue(map2, procedure);
        return targetCollection;
    }

    public static <K, V> void forEachValue(Map<K, V> map2, Procedure<? super V> procedure) {
        if (map2 == null) {
            throw new IllegalArgumentException("Cannot perform a forEachValue on null");
        }
        if (MapIterate.notEmpty(map2)) {
            if (map2 instanceof UnsortedMapIterable) {
                ((MapIterable)((Object)map2)).forEachValue(procedure);
            } else {
                IterableIterate.forEach(map2.values(), procedure);
            }
        }
    }

    public static <K, V> void forEachKey(Map<K, V> map2, Procedure<? super K> procedure) {
        if (map2 == null) {
            throw new IllegalArgumentException("Cannot perform a forEachKey on null");
        }
        if (MapIterate.notEmpty(map2)) {
            if (map2 instanceof UnsortedMapIterable) {
                ((MapIterable)((Object)map2)).forEachKey(procedure);
            } else {
                IterableIterate.forEach(map2.keySet(), procedure);
            }
        }
    }

    public static <K, V> void forEachKeyValue(Map<K, V> map2, Procedure2<? super K, ? super V> procedure) {
        if (map2 == null) {
            throw new IllegalArgumentException("Cannot perform a forEachKeyValue on null");
        }
        if (MapIterate.notEmpty(map2)) {
            if (map2 instanceof UnsortedMapIterable) {
                ((MapIterable)((Object)map2)).forEachKeyValue(procedure);
            } else {
                IterableIterate.forEach(map2.entrySet(), new MapEntryToProcedure2<K, V>(procedure));
            }
        }
    }

    public static <K, V> MutableMap<V, K> flipUniqueValues(MapIterable<K, V> mapIterable) {
        UnifiedMap result = UnifiedMap.newMap();
        mapIterable.forEachKeyValue((key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public static <K, V> Pair<K, V> detect(Map<K, V> map2, Predicate2<? super K, ? super V> predicate) {
        if (map2 == null) {
            throw new IllegalArgumentException("Cannot perform a detect on null");
        }
        if (map2 instanceof ImmutableMap || map2 instanceof MutableMap) {
            RichIterable entries2 = map2 instanceof ImmutableMap ? ((ImmutableMap)((Object)map2)).keyValuesView() : LazyIterate.adapt(map2.entrySet()).collect(AbstractImmutableEntry.getPairFunction());
            return entries2.detect(each2 -> predicate.accept(each2.getOne(), each2.getTwo()));
        }
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (!predicate.accept(entry.getKey(), entry.getValue())) continue;
            return Tuples.pairFrom(entry);
        }
        return null;
    }

    public static <K, V> V detect(Map<K, V> map2, Predicate<? super V> predicate) {
        return IterableIterate.detect(map2.values(), predicate);
    }

    public static <K, V> Optional<Pair<K, V>> detectOptional(Map<K, V> map2, Predicate2<? super K, ? super V> predicate) {
        return Optional.ofNullable(MapIterate.detect(map2, predicate));
    }

    public static <K, V> Optional<V> detectOptional(Map<K, V> map2, Predicate<? super V> predicate) {
        return IterableIterate.detectOptional(map2.values(), predicate);
    }

    public static <K, V> V detectIfNone(Map<K, V> map2, Predicate<? super V> predicate, V ifNone) {
        return Iterate.detectIfNone(map2.values(), predicate, ifNone);
    }

    public static <K, V, IV> IV injectInto(IV injectValue, Map<K, V> map2, Function2<? super IV, ? super V, ? extends IV> function) {
        return Iterate.injectInto(injectValue, map2.values(), function);
    }

    public static <IV, K, V> IV injectIntoIf(IV initialValue, Map<K, V> map2, Predicate<? super V> predicate, Function2<? super IV, ? super V, ? extends IV> function) {
        Function2<Object, Object, Object> ifFunction = (accumulator, item) -> {
            if (predicate.accept((Object)item)) {
                return function.value((Object)accumulator, (Object)item);
            }
            return accumulator;
        };
        return (IV)Iterate.injectInto(initialValue, map2.values(), ifFunction);
    }

    public static <K, V> boolean anySatisfy(Map<K, V> map2, Predicate<? super V> predicate) {
        return IterableIterate.anySatisfy(map2.values(), predicate);
    }

    public static <K, V> boolean allSatisfy(Map<K, V> map2, Predicate<? super V> predicate) {
        return IterableIterate.allSatisfy(map2.values(), predicate);
    }

    public static <K, V> boolean noneSatisfy(Map<K, V> map2, Predicate<? super V> predicate) {
        return IterableIterate.noneSatisfy(map2.values(), predicate);
    }

    public static <K, V> MutableList<Pair<K, V>> toListOfPairs(Map<K, V> map2) {
        FastList pairs = FastList.newList(map2.size());
        MapIterate.forEachKeyValue(map2, (key, value) -> pairs.add(Tuples.pair(key, value)));
        return pairs;
    }

    public static <K, V> MutableList<V> toSortedList(Map<K, V> map2, Comparator<? super V> comparator) {
        return Iterate.toSortedList(map2.values(), comparator);
    }

    public static <K, V> MutableMap<V, K> reverseMapping(Map<K, V> map2) {
        UnifiedMap reverseMap = UnifiedMap.newMap(map2.size());
        MapIterate.forEachKeyValue(map2, (sourceKey, sourceValue) -> reverseMap.put(sourceValue, sourceKey));
        return reverseMap;
    }

    public static <K, V> int occurrencesOf(Map<K, V> map2, V object) {
        return Iterate.count(map2.values(), Predicates.equal(object));
    }

    public static <K, V, A> int occurrencesOfAttribute(Map<K, V> map2, Function<? super V, ? extends A> function, A object) {
        return Iterate.count(map2.values(), Predicates.attributeEqual(function, object));
    }

    public static <K, V> MutableSetMultimap<V, K> flip(MapIterable<K, V> iMap) {
        MutableSetMultimap result = Multimaps.mutable.set.with();
        iMap.forEachKeyValue((key, val) -> result.put(val, key));
        return result;
    }

    public static <K, V> MutableSortedSetMultimap<V, K> flip(SortedMapIterable<K, V> iMap) {
        TreeSortedSetMultimap result = new TreeSortedSetMultimap(iMap.comparator());
        iMap.forEachKeyValue((key, val) -> result.put(val, key));
        return result;
    }
}

