/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.sorted.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure2;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;

class ImmutableSortedMapSerializationProxy<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSortedMap<K, V> map;

    public ImmutableSortedMapSerializationProxy() {
    }

    ImmutableSortedMapSerializationProxy(ImmutableSortedMap<K, V> map2) {
        this.map = map2;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeObject(this.map.comparator());
        out.writeInt(this.map.size());
        try {
            this.map.forEachKeyValue(new CheckedProcedure2<K, V>(){

                @Override
                public void safeValue(K key, V value) throws IOException {
                    out.writeObject(key);
                    out.writeObject(value);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Comparator comparator = (Comparator)in.readObject();
        int size2 = in.readInt();
        TreeSortedMap<Object, Object> deserializedMap = TreeSortedMap.newMap(comparator);
        for (int i = 0; i < size2; ++i) {
            deserializedMap.put(in.readObject(), in.readObject());
        }
        this.map = deserializedMap.toImmutable();
    }

    protected Object readResolve() {
        return this.map;
    }
}

