/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.CharObjectPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.CharObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.CharObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.CharObjectPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Functions0;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import org.eclipse.collections.impl.block.factory.Procedures2;
import org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectByteProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectCharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectIntProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectLongProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectShortProcedure;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.CharObjectMaps;
import org.eclipse.collections.impl.factory.primitive.CharSets;
import org.eclipse.collections.impl.factory.primitive.ObjectCharMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableCharMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedCharObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableCharObjectMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.partition.bag.PartitionHashBag;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedCharSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public class CharObjectHashMap<V>
implements MutableCharObjectMap<V>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private char[] keys;
    private V[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues<V> sentinelValues;
    private boolean copyKeysOnWrite = false;

    public CharObjectHashMap() {
        this.allocateTable(16);
    }

    public CharObjectHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public CharObjectHashMap(CharObjectMap<? extends V> map2) {
        this(Math.max(map2.size(), 8));
        this.putAll(map2);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static <V> CharObjectHashMap<V> newMap() {
        return new CharObjectHashMap<V>();
    }

    public static <V> CharObjectHashMap<V> newMap(CharObjectMap<? extends V> map2) {
        return new CharObjectHashMap<V>(map2);
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key, V value) {
        return new CharObjectHashMap<V>(1).withKeyValue(key, (Object)value);
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key1, V value1, char key2, V value2) {
        return new CharObjectHashMap<V>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key1, V value1, char key2, V value2, char key3, V value3) {
        return new CharObjectHashMap<V>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharObjectMap)) {
            return false;
        }
        CharObjectMap other = (CharObjectMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (!(!((SentinelValues)this.sentinelValues).containsZeroKey || other.containsKey('\u0000') && CharObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).zeroValue, other.get('\u0000')))) {
                return false;
            }
            if (!(!((SentinelValues)this.sentinelValues).containsOneKey || other.containsKey('\u0001') && CharObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).oneValue, other.get('\u0001')))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharObjectHashMap.isNonSentinel(key) || other.containsKey(key) && CharObjectHashMap.nullSafeEquals(this.values[i], other.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result += 0 ^ (((SentinelValues)this.sentinelValues).zeroValue == null ? 0 : ((SentinelValues)this.sentinelValues).zeroValue.hashCode());
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result += 1 ^ (((SentinelValues)this.sentinelValues).oneValue == null ? 0 : ((SentinelValues)this.sentinelValues).oneValue.hashCode());
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.values[i] == null ? 0 : this.values[i].hashCode());
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                appendable.append('\u0000').append("=").append(((SentinelValues)this.sentinelValues).zeroValue);
                first = false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append('\u0001').append("=").append(((SentinelValues)this.sentinelValues).oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharObjectHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    @Override
    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    @Override
    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                    appendable.append(String.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
                    first = false;
                }
                if (((SentinelValues)this.sentinelValues).containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(((SentinelValues)this.sentinelValues).oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                char key = this.keys[i];
                if (!CharObjectHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<V> iterator() {
        return new InternalIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result[index++] = this.values[i];
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size2 = this.size();
        Object[] result = a.length < size2 ? (Object[])Array.newInstance(a.getClass().getComponentType(), size2) : a;
        this.forEachWithIndex((ObjectIntProcedure<? super V>)((ObjectIntProcedure<Object>)(each2, index) -> {
            result[index] = each2;
        }));
        if (result.length > size2) {
            result[size2] = null;
        }
        return result;
    }

    @Override
    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public boolean containsAllIterable(Iterable<?> source) {
        for (Object item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> source) {
        return this.containsAllIterable(source);
    }

    @Override
    public boolean containsAllArguments(Object ... elements) {
        for (Object item : elements) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public CharObjectHashMap<V> tap(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
        return this;
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.each(procedure);
    }

    @Override
    public void each(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).zeroValue, index++);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).oneValue, index++);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            objectIntProcedure.value(this.values[i], index++);
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i], parameter);
        }
    }

    @Override
    public void forEachValue(Procedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    @Override
    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value('\u0000');
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    @Override
    public void forEachKeyValue(CharObjectProcedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value('\u0000', ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value('\u0001', ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    @Override
    public CharObjectHashMap<V> select(CharObjectPredicate<? super V> predicate) {
        CharObjectHashMap<Object> result = CharObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept('\u0000', ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put('\u0000', ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept('\u0001', ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put('\u0001', ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public CharObjectHashMap<V> reject(CharObjectPredicate<? super V> predicate) {
        CharObjectHashMap<Object> result = CharObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept('\u0000', ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put('\u0000', ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept('\u0001', ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put('\u0001', ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public MutableBag<V> select(Predicate<? super V> predicate) {
        HashBag result = new HashBag();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    @Override
    public <P> MutableBag<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    @Override
    public MutableBag<V> reject(Predicate<? super V> predicate) {
        HashBag result = new HashBag();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    @Override
    public <P> MutableBag<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    @Override
    public PartitionMutableBag<V> partition(Predicate<? super V> predicate) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach((Procedure<? super V>)new PartitionProcedure<V>(predicate, partitionMutableBag));
        return partitionMutableBag;
    }

    @Override
    public <P> PartitionMutableBag<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach((Procedure<? super V>)new PartitionProcedure<V>(Predicates.bind(predicate, parameter), partitionMutableBag));
        return partitionMutableBag;
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        HashBag result = HashBag.newBag(this.size());
        this.forEach((Procedure<? super V>)new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    @Override
    public <VV> MutableBag<VV> collect(Function<? super V, ? extends VV> function) {
        return this.collect(function, (R)new HashBag());
    }

    @Override
    public MutableBooleanBag collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.collectBoolean(booleanFunction, (R)new BooleanHashBag());
    }

    @Override
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectBooleanProcedure<V>(booleanFunction, target));
        return target;
    }

    @Override
    public MutableByteBag collectByte(ByteFunction<? super V> byteFunction) {
        return this.collectByte(byteFunction, (R)new ByteHashBag());
    }

    @Override
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectByteProcedure<V>(byteFunction, target));
        return target;
    }

    @Override
    public MutableCharBag collectChar(CharFunction<? super V> charFunction) {
        return this.collectChar(charFunction, (R)new CharHashBag());
    }

    @Override
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectCharProcedure<V>(charFunction, target));
        return target;
    }

    @Override
    public MutableDoubleBag collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.collectDouble(doubleFunction, (R)new DoubleHashBag());
    }

    @Override
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectDoubleProcedure<V>(doubleFunction, target));
        return target;
    }

    @Override
    public MutableFloatBag collectFloat(FloatFunction<? super V> floatFunction) {
        return this.collectFloat(floatFunction, (R)new FloatHashBag());
    }

    @Override
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectFloatProcedure<V>(floatFunction, target));
        return target;
    }

    @Override
    public MutableIntBag collectInt(IntFunction<? super V> intFunction) {
        return this.collectInt(intFunction, (R)new IntHashBag());
    }

    @Override
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectIntProcedure<V>(intFunction, target));
        return target;
    }

    @Override
    public MutableLongBag collectLong(LongFunction<? super V> longFunction) {
        return this.collectLong(longFunction, (R)new LongHashBag());
    }

    @Override
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectLongProcedure<V>(longFunction, target));
        return target;
    }

    @Override
    public MutableShortBag collectShort(ShortFunction<? super V> shortFunction) {
        return this.collectShort(shortFunction, (R)new ShortHashBag());
    }

    @Override
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectShortProcedure<V>(shortFunction, target));
        return target;
    }

    @Override
    public <P, VV> MutableBag<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.collect((Function)Functions.bind(function, parameter));
    }

    @Override
    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                targetCollection.add(function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                targetCollection.add(function.value(((SentinelValues)this.sentinelValues).oneValue, parameter));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            targetCollection.add(function.value(this.values[i], parameter));
        }
        return targetCollection;
    }

    @Override
    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.add(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.add(function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    @Override
    public <VV> MutableBag<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return this.collectIf(predicate, function, (R)HashBag.newBag());
    }

    @Override
    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add(function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    @Override
    public <VV> MutableBag<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return this.flatCollect(function, (R)new HashBag());
    }

    @Override
    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                Iterate.addAllTo(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), target);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Iterate.addAllTo(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), target);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterate.addAllTo(function.valueOf(this.values[i]), target);
        }
        return target;
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        return Optional.ofNullable(this.detect(predicate));
    }

    @Override
    public <P> Optional<V> detectWithOptional(Predicate2<? super V, ? super P> predicate, P parameter) {
        return Optional.ofNullable(this.detectWith(predicate, parameter));
    }

    @Override
    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return function.value();
    }

    @Override
    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return this.values[i];
        }
        return function.value();
    }

    @Override
    public int count(Predicate<? super V> predicate) {
        int count2 = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                ++count2;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                ++count2;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        int count2 = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                ++count2;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                ++count2;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return !this.anySatisfy(predicate);
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return !this.anySatisfyWith(predicate, parameter);
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        IV result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.value(result, this.values[i]);
        }
        return result;
    }

    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        int result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.intValueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        long result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.longValueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        float result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.floatValueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        double result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.doubleValueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<V, S>> zip(Iterable<S> that) {
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            HashBag target = HashBag.newBag(Math.min(this.size(), thatSize));
            return this.zip(that, target);
        }
        return this.zip(that, HashBag.newBag());
    }

    @Override
    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    @Override
    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex(UnifiedSet.newSet(this.size()));
    }

    @Override
    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return IterableIterate.zipWithIndex(this, target);
    }

    @Override
    public RichIterable<RichIterable<V>> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList<RichIterable<V>> result = Lists.mutable.of();
        if (this.notEmpty()) {
            Iterator<V> iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                FastList<V> batch = FastList.newList();
                for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                    batch.add(iterator2.next());
                }
                result.add(batch);
            }
        }
        return result;
    }

    @Override
    public <K, VV> MutableMap<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach((Procedure<? super V>)new MutatingAggregationProcedure<V, K, VV>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2;
    }

    @Override
    public <K, VV> MutableMap<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach((Procedure<? super V>)new NonMutatingAggregationProcedure<V, K, VV>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2;
    }

    @Override
    public <VV> MutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.groupBy(function, (R)HashBagMultimap.newMultimap());
    }

    @Override
    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), (Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), (Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.put(function.valueOf(this.values[i]), this.values[i]);
        }
        return target;
    }

    @Override
    public <VV> MutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.groupByEach(function, (R)HashBagMultimap.newMultimap());
    }

    @Override
    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        if (this.sentinelValues != null) {
            Iterable<VV> iterable;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                iterable = function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
                for (VV key : iterable) {
                    target.put(key, (Object)((SentinelValues)this.sentinelValues).zeroValue);
                }
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                iterable = function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                for (VV key : iterable) {
                    target.put(key, (Object)((SentinelValues)this.sentinelValues).oneValue);
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterable<VV> iterable = function.valueOf(this.values[i]);
            for (VV key : iterable) {
                target.put(key, this.values[i]);
            }
        }
        return target;
    }

    @Override
    public <VV> MutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return this.groupByUniqueKey(function, (R)UnifiedMap.newMap(this.size()));
    }

    @Override
    public <VV, R extends MutableMapIterable<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), (Object)((SentinelValues)this.sentinelValues).zeroValue) != null) {
                throw new IllegalStateException("Key " + function.valueOf(((SentinelValues)this.sentinelValues).zeroValue) + " already exists in map!");
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), (Object)((SentinelValues)this.sentinelValues).oneValue) != null) {
                throw new IllegalStateException("Key " + function.valueOf(((SentinelValues)this.sentinelValues).oneValue) + " already exists in map!");
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || target.put(function.valueOf(this.values[i]), this.values[i]) == null) continue;
            throw new IllegalStateException("Key " + function.valueOf(this.values[i]) + " already exists in map!");
        }
        return target;
    }

    @Override
    public V getFirst() {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public V getLast() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
        }
        return null;
    }

    @Override
    public V getOnly() {
        if (this.size() != 1) {
            throw new IllegalStateException("Size must be 1 but was " + this.size());
        }
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public MutableList<V> toList() {
        MutableList list = Lists.mutable.of();
        this.forEachWith(Procedures2.addToCollection(), (P)list);
        return list;
    }

    @Override
    public <R extends Collection<V>> R into(R target) {
        return Iterate.addAllTo(this, target);
    }

    @Override
    public MutableList<V> toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.toList().sortThis(comparator);
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return this.toList().sortThis(Comparators.byFunction(function));
    }

    @Override
    public MutableSet<V> toSet() {
        UnifiedSet set = UnifiedSet.newSet();
        this.forEachWith(Procedures2.addToCollection(), (P)set);
        return set;
    }

    @Override
    public MutableSortedSet<V> toSortedSet() {
        TreeSortedSet set = TreeSortedSet.newSet();
        this.forEachWith(Procedures2.addToCollection(), (P)set);
        return set;
    }

    @Override
    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        TreeSortedSet<? super V> set = TreeSortedSet.newSet(comparator);
        this.forEachWith(Procedures2.addToCollection(), (P)set);
        return set;
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        TreeSortedSet<? super V> set = TreeSortedSet.newSet(Comparators.byFunction(function));
        this.forEachWith(Procedures2.addToCollection(), (P)set);
        return set;
    }

    @Override
    public MutableBag<V> toBag() {
        MutableBag bag = Bags.mutable.of();
        this.forEachWith(Procedures2.addToCollection(), (P)bag);
        return bag;
    }

    @Override
    public MutableSortedBag<V> toSortedBag() {
        TreeBag sortedBag = TreeBag.newBag();
        this.forEachWith(Procedures2.addToCollection(), (P)sortedBag);
        return sortedBag;
    }

    @Override
    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        TreeBag<? super V> sortedBag = TreeBag.newBag(comparator);
        this.forEachWith(Procedures2.addToCollection(), (P)sortedBag);
        return sortedBag;
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableSortedBag<V> toSortedBagBy(Function<? super V, ? extends VV> function) {
        return this.toSortedBag((Comparator<? super V>)Comparators.byFunction(function));
    }

    @Override
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach((Procedure<? super V>)new MapCollectProcedure<V, NK, NV>(map2, keyFunction, valueFunction));
        return map2;
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.toSortedMap((Comparator<? super NK>)Comparators.naturalOrder(), keyFunction, valueFunction);
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        TreeSortedMap sortedMap = TreeSortedMap.newMap(comparator);
        this.forEach((Procedure<? super V>)new MapCollectProcedure<V, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    @Override
    public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.toSortedMap((Comparator<? super NK>)Comparators.byFunction(sortBy), keyFunction, valueFunction);
    }

    @Override
    public LazyIterable<V> asLazy() {
        return LazyIterate.adapt(this);
    }

    @Override
    public V min(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min2 = null;
        boolean isMinSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min2 = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMinSet || comparator.compare(min2, ((SentinelValues)this.sentinelValues).oneValue) > 0)) {
                min2 = ((SentinelValues)this.sentinelValues).oneValue;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || isMinSet && comparator.compare(min2, this.values[i]) <= 0) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return (V)min2;
    }

    @Override
    public V max(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max2 = null;
        boolean isMaxSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max2 = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMaxSet || comparator.compare(max2, ((SentinelValues)this.sentinelValues).oneValue) < 0)) {
                max2 = ((SentinelValues)this.sentinelValues).oneValue;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || isMaxSet && comparator.compare(max2, this.values[i]) >= 0) continue;
            max2 = this.values[i];
            isMaxSet = true;
        }
        return (V)max2;
    }

    @Override
    public V min() {
        return (V)this.min(Comparators.naturalOrder());
    }

    @Override
    public V max() {
        return (V)this.max(Comparators.naturalOrder());
    }

    @Override
    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max2 = null;
        boolean isMaxSet = false;
        Comparable maxValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max2 = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
                maxValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMaxSet || nextValue.compareTo(maxValue) > 0) {
                    max2 = ((SentinelValues)this.sentinelValues).oneValue;
                    isMaxSet = true;
                    maxValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMaxSet && nextValue.compareTo(maxValue) <= 0) continue;
            max2 = next;
            isMaxSet = true;
            maxValue = nextValue;
        }
        return (V)max2;
    }

    @Override
    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min2 = null;
        boolean isMinSet = false;
        Comparable minValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min2 = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
                minValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMinSet || nextValue.compareTo(minValue) < 0) {
                    min2 = ((SentinelValues)this.sentinelValues).oneValue;
                    isMinSet = true;
                    minValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMinSet && nextValue.compareTo(minValue) >= 0) continue;
            min2 = next;
            isMinSet = true;
            minValue = nextValue;
        }
        return (V)min2;
    }

    @Override
    public long sumOfInt(IntFunction<? super V> function) {
        long sum2 = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum2 += (long)function.intValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum2 += (long)function.intValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum2 += (long)function.intValueOf(this.values[i]);
        }
        return sum2;
    }

    @Override
    public double sumOfFloat(FloatFunction<? super V> function) {
        double sum2 = 0.0;
        double compensation = 0.0;
        if (this.sentinelValues != null) {
            double nextSum;
            double adjustedValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                adjustedValue = (double)function.floatValueOf(((SentinelValues)this.sentinelValues).zeroValue) - compensation;
                nextSum = sum2 + adjustedValue;
                compensation = nextSum - sum2 - adjustedValue;
                sum2 = nextSum;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                adjustedValue = (double)function.floatValueOf(((SentinelValues)this.sentinelValues).oneValue) - compensation;
                nextSum = sum2 + adjustedValue;
                compensation = nextSum - sum2 - adjustedValue;
                sum2 = nextSum;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = (double)function.floatValueOf(this.values[i]) - compensation;
            double nextSum = sum2 + adjustedValue;
            compensation = nextSum - sum2 - adjustedValue;
            sum2 = nextSum;
        }
        return sum2;
    }

    @Override
    public long sumOfLong(LongFunction<? super V> function) {
        long sum2 = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum2 += function.longValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum2 += function.longValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum2 += function.longValueOf(this.values[i]);
        }
        return sum2;
    }

    @Override
    public double sumOfDouble(DoubleFunction<? super V> function) {
        double sum2 = 0.0;
        double compensation = 0.0;
        if (this.sentinelValues != null) {
            double nextSum;
            double adjustedValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                adjustedValue = function.doubleValueOf(((SentinelValues)this.sentinelValues).zeroValue) - compensation;
                nextSum = sum2 + adjustedValue;
                compensation = nextSum - sum2 - adjustedValue;
                sum2 = nextSum;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                adjustedValue = function.doubleValueOf(((SentinelValues)this.sentinelValues).oneValue) - compensation;
                nextSum = sum2 + adjustedValue;
                compensation = nextSum - sum2 - adjustedValue;
                sum2 = nextSum;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = function.doubleValueOf(this.values[i]) - compensation;
            double nextSum = sum2 + adjustedValue;
            compensation = nextSum - sum2 - adjustedValue;
            sum2 = nextSum;
        }
        return sum2;
    }

    @Override
    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto((IV)result, (Function2)PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto((IV)result, (Function2)PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    @Override
    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto((IV)result, (Function2)PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto((IV)result, (Function2)PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.keys = new char[this.keys.length];
            this.copyKeysOnWrite = false;
        }
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
    }

    @Override
    public V put(char key, V value) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)oldValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        this.addKeyValueAtIndex(key, value, index);
        return null;
    }

    @Override
    public void putAll(CharObjectMap<? extends V> map2) {
        map2.forEachKeyValue((key, value) -> this.put(key, value));
    }

    @Override
    public boolean containsKey(char key) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsZeroKey;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !CharObjectHashMap.nullSafeEquals(this.values[i], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(char key) {
        return (V)this.getIfAbsent(key, Functions0.nullValue());
    }

    @Override
    public V getIfAbsent(char key, Function0<? extends V> ifAbsent) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent.value();
    }

    @Override
    public V getIfAbsentPut(char key, V value) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public V getIfAbsentPut(char key, Function0<? extends V> function) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            V value = function.value();
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            V value = function.value();
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        V value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> V getIfAbsentPutWith(char key, Function<? super P, ? extends V> function, P parameter) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            V value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            V value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        V value = function.valueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public V getIfAbsentPutWithKey(char key, CharToObjectFunction<? extends V> function) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            V value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            V value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        V value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public V updateValue(char key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        V value = function.valueOf(factory.value());
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> V updateValueWith(char key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.value(this.values[index], parameter);
            return this.values[index];
        }
        V value = function.value(factory.value(), parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public V removeKey(char key) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).containsZeroKey = false;
                ((SentinelValues)this.sentinelValues).zeroValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).containsOneKey = false;
                ((SentinelValues)this.sentinelValues).oneValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return null;
    }

    @Override
    public V remove(char key) {
        return this.removeKey(key);
    }

    @Override
    public CharObjectHashMap<V> withKeyValue(char key, V value) {
        this.put(key, value);
        return this;
    }

    @Override
    public MutableCharObjectMap<V> withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public MutableCharObjectMap<V> withoutAllKeys(CharIterable keys2) {
        CharIterator iterator2 = keys2.charIterator();
        while (iterator2.hasNext()) {
            char item = iterator2.next();
            this.removeKey(item);
        }
        return this;
    }

    public CharObjectHashMap<V> withKeysValues(char key1, V value1, char key2, V value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharObjectHashMap<V> withKeysValues(char key1, V value1, char key2, V value2, char key3, V value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharObjectHashMap<V> withKeysValues(char key1, V value1, char key2, V value2, char key3, V value3, char key4, V value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public MutableCharObjectMap<V> asUnmodifiable() {
        return new UnmodifiableCharObjectMap(this);
    }

    @Override
    public MutableCharObjectMap<V> asSynchronized() {
        return new SynchronizedCharObjectMap(this);
    }

    @Override
    public ImmutableCharObjectMap<V> toImmutable() {
        return CharObjectMaps.immutable.withAll(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                out.writeChar(0);
                out.writeObject(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                out.writeChar(1);
                out.writeObject(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeObject(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            this.put(in.readChar(), in.readObject());
        }
    }

    private void addKeyValueAtIndex(char key, V value, int index) {
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = '\u0001';
        this.values[index] = null;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        char[] copy = new char[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    @Override
    public MutableCharSet keySet() {
        return new KeySet();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max2 = this.maxOccupiedWithData();
        int newCapacity = Math.max(max2, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max2 >> 1) + (max2 >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        V[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharObjectHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
        this.copyKeysOnWrite = false;
    }

    int probe(char element) {
        int index = this.mask(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        for (int i = 1; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(char element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            char keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(char element, int removedIndex) {
        int nextIndex = SpreadFunctions.charSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.charSpreadTwo(element)) | 1;
        char keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(char element) {
        int code = SpreadFunctions.charSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(char element) {
        int code = SpreadFunctions.charSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new Object[sizeToAllocate];
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharObjectHashMap.isEmptyKey(key) && !CharObjectHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    @Override
    public Collection<V> values() {
        return new ValuesCollection();
    }

    @Override
    public LazyCharIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<CharObjectPair<V>> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableObjectCharMap<V> flipUniqueValues() {
        MutableObjectCharMap result = ObjectCharMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    static /* synthetic */ char[] access$802(CharObjectHashMap x0, char[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$1002(CharObjectHashMap x0, Object[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<CharObjectPair<V>> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super CharObjectPair<V>> procedure) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair('\u0000', CharObjectHashMap.this.sentinelValues.zeroValue));
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair('\u0001', CharObjectHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(CharObjectHashMap.this.keys[i], CharObjectHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super CharObjectPair<V>> objectIntProcedure) {
            int index = 0;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair('\u0000', CharObjectHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair('\u0001', CharObjectHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(CharObjectHashMap.this.keys[i], CharObjectHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super CharObjectPair<V>, ? super P> procedure, P parameter) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair('\u0000', CharObjectHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair('\u0001', CharObjectHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(CharObjectHashMap.this.keys[i], CharObjectHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<CharObjectPair<V>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<CharObjectPair<V>> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public CharObjectPair<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (CharObjectHashMap.this.containsKey('\u0000')) {
                        return PrimitiveTuples.pair('\u0000', CharObjectHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (CharObjectHashMap.this.containsKey('\u0001')) {
                        return PrimitiveTuples.pair('\u0001', CharObjectHashMap.this.sentinelValues.oneValue);
                    }
                }
                char[] keys2 = CharObjectHashMap.this.keys;
                while (!CharObjectHashMap.isNonSentinel(keys2[this.position])) {
                    ++this.position;
                }
                CharObjectPair<Object> result = PrimitiveTuples.pair(keys2[this.position], CharObjectHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != CharObjectHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyCharIterable {
        private KeysView() {
        }

        @Override
        public CharIterator charIterator() {
            return new UnmodifiableCharIterator(new KeysSetIterator());
        }

        @Override
        public void forEach(CharProcedure procedure) {
            this.each(procedure);
        }

        @Override
        public void each(CharProcedure procedure) {
            CharObjectHashMap.this.forEachKey(procedure);
        }
    }

    protected class ValuesCollection
    implements Collection<V> {
        protected ValuesCollection() {
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public void clear() {
            CharObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return CharObjectHashMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return Iterate.allSatisfy(collection, Predicates.in(this));
        }

        @Override
        public boolean isEmpty() {
            return CharObjectHashMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return CharObjectHashMap.this.iterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    it.remove();
                    return true;
                }
            } else {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Object o2 = it.next();
                    if (o != o2 && !o2.equals(o)) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            Iterator e = this.iterator();
            while (e.hasNext()) {
                if (collection.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public int size() {
            return CharObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return CharObjectHashMap.this.toArray();
        }

        @Override
        public <T> T[] toArray(T[] result) {
            return CharObjectHashMap.this.toArray(result);
        }
    }

    private class KeysSetIterator
    implements MutableCharIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZeroKey;
        private boolean handledOneKey;
        private boolean canRemove;

        private KeysSetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != CharObjectHashMap.this.size();
        }

        @Override
        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (CharObjectHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return this.lastKey;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (CharObjectHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return this.lastKey;
                }
            }
            char[] keys2 = CharObjectHashMap.this.keys;
            while (!CharObjectHashMap.isNonSentinel(keys2[this.position])) {
                ++this.position;
            }
            this.lastKey = keys2[this.position];
            ++this.position;
            return this.lastKey;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            CharObjectHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeySet
    implements MutableCharSet {
        private KeySet() {
        }

        @Override
        public MutableCharIterator charIterator() {
            return new KeysSetIterator();
        }

        @Override
        public void forEach(CharProcedure procedure) {
            this.each(procedure);
        }

        @Override
        public void each(CharProcedure procedure) {
            CharObjectHashMap.this.forEachKey(procedure);
        }

        @Override
        public int count(CharPredicate predicate) {
            int count2 = 0;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    ++count2;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    ++count2;
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count2;
            }
            return count2;
        }

        @Override
        public boolean anySatisfy(CharPredicate predicate) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return true;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return true;
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            T result = injectedValue;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, '\u0000');
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, '\u0001');
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key)) continue;
                result = function.valueOf(result, key);
            }
            return result;
        }

        @Override
        public RichIterable<CharIterable> chunk(int size2) {
            if (size2 <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
            }
            if (this.isEmpty()) {
                return Lists.mutable.empty();
            }
            MutableCharIterator iterator2 = this.charIterator();
            MutableList<CharIterable> result = Lists.mutable.empty();
            while (iterator2.hasNext()) {
                MutableCharSet batch = CharSets.mutable.empty();
                for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                    batch.add(iterator2.next());
                }
                result.add(batch);
            }
            return result;
        }

        @Override
        public boolean allSatisfy(CharPredicate predicate) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    return false;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noneSatisfy(CharPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        @Override
        public boolean add(char element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(char key) {
            int oldSize = CharObjectHashMap.this.size();
            CharObjectHashMap.this.removeKey(key);
            return oldSize != CharObjectHashMap.this.size();
        }

        @Override
        public boolean removeAll(CharIterable source) {
            int oldSize = CharObjectHashMap.this.size();
            CharIterator iterator2 = source.charIterator();
            while (iterator2.hasNext()) {
                CharObjectHashMap.this.removeKey(iterator2.next());
            }
            return oldSize != CharObjectHashMap.this.size();
        }

        @Override
        public boolean removeAll(char ... source) {
            int oldSize = CharObjectHashMap.this.size();
            for (char item : source) {
                CharObjectHashMap.this.removeKey(item);
            }
            return oldSize != CharObjectHashMap.this.size();
        }

        @Override
        public boolean retainAll(CharIterable source) {
            int oldSize = this.size();
            CharSet sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            MutableCharObjectMap retained = CharObjectHashMap.this.select((char key, T value) -> sourceSet.contains(key));
            if (((CharObjectHashMap)retained).size() != oldSize) {
                CharObjectHashMap.access$802(CharObjectHashMap.this, ((CharObjectHashMap)retained).keys);
                CharObjectHashMap.access$1002(CharObjectHashMap.this, ((CharObjectHashMap)retained).values);
                CharObjectHashMap.this.sentinelValues = ((CharObjectHashMap)retained).sentinelValues;
                CharObjectHashMap.this.occupiedWithData = ((CharObjectHashMap)retained).occupiedWithData;
                CharObjectHashMap.this.occupiedWithSentinels = ((CharObjectHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(char ... source) {
            return this.retainAll(CharHashSet.newSetWith(source));
        }

        @Override
        public void clear() {
            CharObjectHashMap.this.clear();
        }

        @Override
        public MutableCharSet select(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        @Override
        public MutableCharSet reject(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        @Override
        public MutableCharSet with(char element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableCharSet without(char element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableCharSet withAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableCharSet withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public char detectIfNone(CharPredicate predicate, char ifNone) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return '\u0000';
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return '\u0001';
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        @Override
        public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf('\u0000'));
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf('\u0001'));
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        @Override
        public MutableCharSet asUnmodifiable() {
            return UnmodifiableCharSet.of(this);
        }

        @Override
        public MutableCharSet asSynchronized() {
            return SynchronizedCharSet.of(this);
        }

        @Override
        public MutableCharSet newEmpty() {
            return new CharHashSet();
        }

        @Override
        public long sum() {
            long result = 0L;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (char key : CharObjectHashMap.this.keys) {
                if (!CharObjectHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        @Override
        public char max() {
            if (CharObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char max2 = '\u0000';
            boolean isMaxSet = false;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    max2 = '\u0000';
                    isMaxSet = true;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    max2 = '\u0001';
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i]) || isMaxSet && max2 >= CharObjectHashMap.this.keys[i]) continue;
                max2 = CharObjectHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max2;
        }

        @Override
        public char maxIfEmpty(char defaultValue) {
            if (CharObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        @Override
        public char min() {
            if (CharObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char min2 = '\u0000';
            boolean isMinSet = false;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    min2 = '\u0000';
                    isMinSet = true;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey && !isMinSet) {
                    min2 = '\u0001';
                    isMinSet = true;
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i]) || isMinSet && CharObjectHashMap.this.keys[i] >= min2) continue;
                min2 = CharObjectHashMap.this.keys[i];
                isMinSet = true;
            }
            return min2;
        }

        @Override
        public char minIfEmpty(char defaultValue) {
            if (CharObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        @Override
        public double average() {
            if (CharObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        @Override
        public double median() {
            if (CharObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            char[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                char first = sortedArray[middleIndex];
                char second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        @Override
        public char[] toSortedArray() {
            char[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        @Override
        public MutableCharList toSortedList() {
            return CharArrayList.newList(this).sortThis();
        }

        @Override
        public char[] toArray() {
            int size2 = CharObjectHashMap.this.size();
            final char[] result = new char[size2];
            CharObjectHashMap.this.forEachKey(new CharProcedure(){
                private int index;

                @Override
                public void value(char each2) {
                    result[this.index] = each2;
                    ++this.index;
                }
            });
            return result;
        }

        @Override
        public boolean contains(char value) {
            return CharObjectHashMap.this.containsKey(value);
        }

        @Override
        public boolean containsAll(char ... source) {
            for (char item : source) {
                if (CharObjectHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(CharIterable source) {
            CharIterator iterator2 = source.charIterator();
            while (iterator2.hasNext()) {
                if (CharObjectHashMap.this.containsKey(iterator2.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public MutableCharList toList() {
            return CharArrayList.newList(this);
        }

        @Override
        public MutableCharSet toSet() {
            return CharHashSet.newSet(this);
        }

        @Override
        public MutableCharBag toBag() {
            return CharHashBag.newBag(this);
        }

        @Override
        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter(this);
        }

        @Override
        public CharSet freeze() {
            CharObjectHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (CharObjectHashMap.this.sentinelValues != null) {
                containsZeroKey = CharObjectHashMap.this.sentinelValues.containsZeroKey;
                containsOneKey = CharObjectHashMap.this.sentinelValues.containsOneKey;
            }
            return new ImmutableCharMapKeySet(CharObjectHashMap.this.keys, CharObjectHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public ImmutableCharSet toImmutable() {
            return CharSets.immutable.withAll(this);
        }

        @Override
        public int size() {
            return CharObjectHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CharObjectHashMap.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return CharObjectHashMap.this.notEmpty();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CharSet)) {
                return false;
            }
            CharSet other = (CharSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        @Override
        public int hashCode() {
            int result = 0;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i])) continue;
                result += CharObjectHashMap.this.keys[i];
            }
            return result;
        }

        @Override
        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        @Override
        public String makeString() {
            return this.makeString(", ");
        }

        @Override
        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        @Override
        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        @Override
        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharObjectHashMap.this.sentinelValues != null) {
                    if (CharObjectHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf('\u0000'));
                        first = false;
                    }
                    if (CharObjectHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf('\u0001'));
                        first = false;
                    }
                }
                for (char key : CharObjectHashMap.this.keys) {
                    if (!CharObjectHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class InternalIterator
    implements Iterator<V> {
        private int count;
        private int position;
        private char currentKey;
        private boolean isCurrentKeySet;
        private boolean handledZeroKey;
        private boolean handledOneKey;

        private InternalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != CharObjectHashMap.this.size();
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (CharObjectHashMap.this.containsKey('\u0000')) {
                    this.currentKey = '\u0000';
                    this.isCurrentKeySet = true;
                    return CharObjectHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (CharObjectHashMap.this.containsKey('\u0001')) {
                    this.currentKey = '\u0001';
                    this.isCurrentKeySet = true;
                    return CharObjectHashMap.this.sentinelValues.oneValue;
                }
            }
            char[] keys2 = CharObjectHashMap.this.keys;
            while (!CharObjectHashMap.isNonSentinel(keys2[this.position])) {
                ++this.position;
            }
            this.currentKey = CharObjectHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            Object result = CharObjectHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (CharObjectHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                CharObjectHashMap.this.removeKeyAtIndex(index);
            } else {
                CharObjectHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    private static final class SentinelValues<V> {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private V zeroValue;
        private V oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(V value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && CharObjectHashMap.nullSafeEquals(this.zeroValue, value);
            boolean valueEqualsOneValue = this.containsOneKey && CharObjectHashMap.nullSafeEquals(this.oneValue, value);
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

