/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.SynchronizedMutableCollection;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.map.AbstractSynchronizedMapIterable;
import org.eclipse.collections.impl.map.mutable.MapAdapter;
import org.eclipse.collections.impl.map.mutable.SynchronizedMapSerializationProxy;
import org.eclipse.collections.impl.map.mutable.UnmodifiableMutableMap;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.utility.LazyIterate;

public class SynchronizedMutableMap<K, V>
extends AbstractSynchronizedMapIterable<K, V>
implements MutableMap<K, V>,
Serializable {
    private static final long serialVersionUID = 2L;

    public SynchronizedMutableMap(MutableMap<K, V> newMap) {
        super(newMap);
    }

    public SynchronizedMutableMap(MutableMap<K, V> newMap, Object newLock) {
        super(newMap, newLock);
    }

    public static <K, V, M extends Map<K, V>> SynchronizedMutableMap<K, V> of(M map2) {
        if (map2 == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedMutableMap for null");
        }
        return new SynchronizedMutableMap(MapAdapter.adapt(map2));
    }

    public static <K, V, M extends Map<K, V>> SynchronizedMutableMap<K, V> of(M map2, Object lock) {
        if (map2 == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedMutableMap for null");
        }
        return new SynchronizedMutableMap(MapAdapter.adapt(map2), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, V> withKeyValue(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            this.put(key, value);
            return this;
        }
    }

    @Override
    public MutableMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValuePairs) {
        return this.withAllKeyValues(ArrayAdapter.adapt(keyValuePairs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        Object object = this.lock;
        synchronized (object) {
            for (Pair<K, V> keyValue : keyValues) {
                this.getDelegate().put(keyValue.getOne(), keyValue.getTwo());
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, V> withoutKey(K key) {
        Object object = this.lock;
        synchronized (object) {
            this.remove(key);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, V> withoutAllKeys(Iterable<? extends K> keys2) {
        Object object = this.lock;
        synchronized (object) {
            for (K key : keys2) {
                this.getDelegate().removeKey(key);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, V> newEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, V> clone() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableMap.of(this.getDelegate().clone());
        }
    }

    protected Object writeReplace() {
        return new SynchronizedMapSerializationProxy(this.getDelegate());
    }

    @Override
    protected MutableMap<K, V> getDelegate() {
        return (MutableMap)super.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> MutableMap<K, V> collectKeysAndValues(Iterable<E> iterable, Function<? super E, ? extends K> keyFunction, Function<? super E, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectKeysAndValues(iterable, keyFunction, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().select((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().reject((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K2, V2> MutableMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> pairFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collect((Function2)pairFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> MutableMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectValues((Function2)function);
        }
    }

    @Override
    public MutableMap<K, V> tap(Procedure<? super V> procedure) {
        return (MutableMap)super.tap((Procedure)procedure);
    }

    @Override
    public MutableBag<V> select(Predicate<? super V> predicate) {
        return (MutableBag)super.select((Predicate)predicate);
    }

    @Override
    public <P> MutableBag<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (MutableBag)super.selectWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public MutableBag<V> reject(Predicate<? super V> predicate) {
        return (MutableBag)super.reject((Predicate)predicate);
    }

    @Override
    public <P> MutableBag<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (MutableBag)super.rejectWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public PartitionMutableBag<V> partition(Predicate<? super V> predicate) {
        return (PartitionMutableBag)super.partition((Predicate)predicate);
    }

    @Override
    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return (MutableSet)super.zipWithIndex();
    }

    @Override
    public <P> PartitionMutableBag<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (PartitionMutableBag)super.partitionWith(predicate, parameter);
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        return (MutableBag)super.selectInstancesOf((Class)clazz);
    }

    @Override
    public <A> MutableBag<A> collect(Function<? super V, ? extends A> function) {
        return (MutableBag)super.collect(function);
    }

    @Override
    public MutableBooleanBag collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return (MutableBooleanBag)super.collectBoolean(booleanFunction);
    }

    @Override
    public MutableByteBag collectByte(ByteFunction<? super V> byteFunction) {
        return (MutableByteBag)super.collectByte(byteFunction);
    }

    @Override
    public MutableCharBag collectChar(CharFunction<? super V> charFunction) {
        return (MutableCharBag)super.collectChar(charFunction);
    }

    @Override
    public MutableDoubleBag collectDouble(DoubleFunction<? super V> doubleFunction) {
        return (MutableDoubleBag)super.collectDouble(doubleFunction);
    }

    @Override
    public MutableFloatBag collectFloat(FloatFunction<? super V> floatFunction) {
        return (MutableFloatBag)super.collectFloat(floatFunction);
    }

    @Override
    public MutableIntBag collectInt(IntFunction<? super V> intFunction) {
        return (MutableIntBag)super.collectInt(intFunction);
    }

    @Override
    public MutableLongBag collectLong(LongFunction<? super V> longFunction) {
        return (MutableLongBag)super.collectLong(longFunction);
    }

    @Override
    public MutableShortBag collectShort(ShortFunction<? super V> shortFunction) {
        return (MutableShortBag)super.collectShort(shortFunction);
    }

    @Override
    public <P, A> MutableBag<A> collectWith(Function2<? super V, ? super P, ? extends A> function, P parameter) {
        return (MutableBag)super.collectWith(function, parameter);
    }

    @Override
    public <A> MutableBag<A> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends A> function) {
        return (MutableBag)super.collectIf(predicate, function);
    }

    @Override
    public <A> MutableBag<A> flatCollect(Function<? super V, ? extends Iterable<A>> function) {
        return (MutableBag)super.flatCollect(function);
    }

    @Override
    public <KK> MutableBagMultimap<KK, V> groupBy(Function<? super V, ? extends KK> function) {
        return (MutableBagMultimap)super.groupBy(function);
    }

    @Override
    public <KK> MutableBagMultimap<KK, V> groupByEach(Function<? super V, ? extends Iterable<KK>> function) {
        return (MutableBagMultimap)super.groupByEach(function);
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<V, S>> zip(Iterable<S> that) {
        return (MutableBag)super.zip((Iterable)that);
    }

    @Override
    public <VV> MutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return (MutableMap)super.groupByUniqueKey((Function)function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<V, K> flipUniqueValues() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().flipUniqueValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSetMultimap<V, K> flip() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getDelegate().keySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableCollection.of(this.getDelegate().values(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getDelegate().entrySet(), this.lock);
        }
    }

    @Override
    public RichIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    @Override
    public RichIterable<V> valuesView() {
        return LazyIterate.adapt(this.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMap<K, V> asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return UnmodifiableMutableMap.of(this);
        }
    }

    @Override
    public MutableMap<K, V> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMap<K, V> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return Maps.immutable.withAll(this);
        }
    }
}

