/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableIntObjectMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntObjectSingletonMap;

public enum ImmutableIntObjectMapFactoryImpl implements ImmutableIntObjectMapFactory
{
    INSTANCE;


    @Override
    public <V> ImmutableIntObjectMap<V> empty() {
        return ImmutableIntObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableIntObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableIntObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableIntObjectMap<V> of(int key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableIntObjectMap<V> with(int key, V value) {
        return new ImmutableIntObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableIntObjectMap<V> ofAll(IntObjectMap<? extends V> map2) {
        return this.withAll(map2);
    }

    @Override
    public <V> ImmutableIntObjectMap<V> withAll(IntObjectMap<? extends V> map2) {
        if (map2 instanceof ImmutableIntObjectMap) {
            return (ImmutableIntObjectMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            int[] array = new int[1];
            map2.forEachKey(each2 -> {
                array[0] = each2;
            });
            return new ImmutableIntObjectSingletonMap<V>(array[0], map2.get(array[0]));
        }
        return new ImmutableIntObjectHashMap<V>(map2);
    }

    @Override
    public <T, V> ImmutableIntObjectMap<V> from(Iterable<T> iterable, IntFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableIntObjectMap<V> map2 = IntObjectMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map2.toImmutable();
    }
}

