/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.block.factory.primitive.DoublePredicates;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

public class SelectDoubleIterable
extends AbstractLazyDoubleIterable {
    private final DoubleIterable delegate;
    private final DoublePredicate predicate;

    public SelectDoubleIterable(DoubleIterable delegate, DoublePredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new SelectDoubleIterator(this.delegate, this.predicate);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.delegate.forEach(new IfDoubleProcedure(procedure));
    }

    @Override
    public int size() {
        return this.delegate.count(this.predicate);
    }

    @Override
    public boolean isEmpty() {
        return !this.doubleIterator().hasNext();
    }

    @Override
    public boolean notEmpty() {
        return this.doubleIterator().hasNext();
    }

    @Override
    public int count(DoublePredicate predicate) {
        CountDoubleProcedure countDoubleProcedure = new CountDoubleProcedure(predicate);
        this.forEach(countDoubleProcedure);
        return countDoubleProcedure.getCount();
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy(DoublePredicates.and(this.predicate, predicate));
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.noneSatisfy(DoublePredicates.not(predicate));
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    @Override
    public double[] toArray() {
        final double[] array = new double[this.size()];
        this.forEach(new DoubleProcedure(){
            private int index = 0;

            @Override
            public void value(double each2) {
                array[this.index++] = each2;
            }
        });
        return array;
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator2 = source.doubleIterator();
        while (iterator2.hasNext()) {
            if (this.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newList(this);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet(this);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag(this);
    }

    private static final class SelectDoubleIterator
    implements DoubleIterator {
        private final DoubleIterator iterator;
        private final DoublePredicate predicate;
        private double next;
        private boolean verifiedHasNext = false;

        private SelectDoubleIterator(DoubleIterable iterable, DoublePredicate predicate) {
            this(iterable.doubleIterator(), predicate);
        }

        private SelectDoubleIterator(DoubleIterator iterator2, DoublePredicate predicate) {
            this.iterator = iterator2;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                double temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        @Override
        public double next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfDoubleProcedure
    implements DoubleProcedure {
        private static final long serialVersionUID = 1L;
        private final DoubleProcedure procedure;

        private IfDoubleProcedure(DoubleProcedure procedure) {
            this.procedure = procedure;
        }

        @Override
        public void value(double each2) {
            if (SelectDoubleIterable.this.predicate.accept(each2)) {
                this.procedure.value(each2);
            }
        }
    }

    private static final class CountDoubleProcedure
    implements DoubleProcedure {
        private static final long serialVersionUID = 1L;
        private final DoublePredicate predicate;
        private int counter = 0;

        private CountDoubleProcedure(DoublePredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public void value(double each2) {
            if (this.predicate.accept(each2)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

