/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

public class CollectDoubleIterable<T>
extends AbstractLazyDoubleIterable {
    private final LazyIterable<T> iterable;
    private final DoubleFunction<? super T> function;
    private final DoubleFunctionToProcedure<T> doubleFunctionToProcedure;

    public CollectDoubleIterable(LazyIterable<T> adapted, DoubleFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.doubleFunctionToProcedure = new DoubleFunctionToProcedure(function);
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new DoubleIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectDoubleIterable.this.iterable.iterator();
            }

            @Override
            public double next() {
                return CollectDoubleIterable.this.function.doubleValueOf(this.iterator.next());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.iterable.forEachWith(this.doubleFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(DoublePredicate predicate) {
        return this.iterable.count((? super T each2) -> predicate.accept(this.function.doubleValueOf(each2)));
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.iterable.anySatisfy((? super T each2) -> predicate.accept(this.function.doubleValueOf(each2)));
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.iterable.allSatisfy((? super T each2) -> predicate.accept(this.function.doubleValueOf(each2)));
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.iterable.allSatisfy((? super T each2) -> !predicate.accept(this.function.doubleValueOf(each2)));
    }

    @Override
    public double[] toArray() {
        double[] array = new double[this.size()];
        this.iterable.forEachWithIndex((each2, index) -> {
            array[index] = this.function.doubleValueOf(each2);
        });
        return array;
    }

    @Override
    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newList(this);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet(this);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag(this);
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator2 = source.doubleIterator();
        while (iterator2.hasNext()) {
            if (this.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    private static final class DoubleFunctionToProcedure<T>
    implements Procedure2<T, DoubleProcedure> {
        private static final long serialVersionUID = 1L;
        private final DoubleFunction<? super T> function;

        private DoubleFunctionToProcedure(DoubleFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each2, DoubleProcedure procedure) {
            procedure.value(this.function.doubleValueOf(each2));
        }
    }
}

