/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle.output;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JunitXmlReportWriter {
    private static final Logger logger = LoggerFactory.getLogger(JunitXmlReportWriter.class);
    public static String pathToReport;
    private boolean skip = false;
    private Element testSuite;
    private Long startSeconds = null;
    private static Lock lock;

    public void init(String junitReport) {
        if (junitReport == null) {
            this.skip = true;
            return;
        }
        pathToReport = junitReport;
        this.setStartTime();
    }

    public void setStartTime() {
        this.startSeconds = Instant.now().getEpochSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJunitReport(String totals, String task, String artifact, ArrayList<String> currentVulnerabilityList) {
        if (this.skip) {
            return;
        }
        lock.lock();
        try (DocResource docResource = new DocResource(pathToReport);){
            Integer testCaseId;
            Document doc = docResource.getDocument();
            Integer n = testCaseId = this.getTotalOfElementsByName(doc, "testcase");
            Integer n2 = testCaseId = Integer.valueOf(testCaseId + 1);
            Element testCase = this.addChildElement(doc, this.testSuite, "testcase", "");
            this.addElementAttribute(doc, testCase, "name", task + " - " + totals);
            this.addElementAttribute(doc, testCase, "id", testCaseId.toString());
            Long elapsedTime = Instant.now().getEpochSecond() - this.startSeconds;
            this.addElementAttribute(doc, testCase, "time", elapsedTime.toString());
            if (artifact != null && !artifact.substring(0, 1).equals("0")) {
                Element failure = this.addChildElement(doc, testCase, "failure", this.buildFailureString(currentVulnerabilityList));
                this.addElementAttribute(doc, failure, "message", artifact);
            }
        }
        catch (IOException e) {
            logger.error("Exception writing log: " + e);
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXmlReport(String pathToReport) throws Exception {
        if (this.skip) {
            return;
        }
        lock.lock();
        try (DocResource docResource = new DocResource(pathToReport);){
            Document doc = docResource.getDocument();
            String testCount = this.getTotalOfElementsByName(doc, "testcase").toString();
            this.modifyElementAttribute(doc, "testsuites", 0, "tests", testCount);
            String failureCount = this.getTotalOfElementsByName(doc, "failure").toString();
            this.modifyElementAttribute(doc, "testsuites", 0, "failures", failureCount);
        }
        finally {
            lock.unlock();
        }
    }

    private Element addChildElement(Document doc, Element parent, String name, String data) {
        Element elem = doc.createElement(name);
        elem.appendChild(doc.createTextNode(data));
        parent.appendChild(elem);
        return elem;
    }

    private void addElementAttribute(Document doc, Element parent, String name, String value) {
        Attr attr = doc.createAttribute(name);
        attr.setValue(value);
        parent.setAttributeNode(attr);
    }

    private String buildFailureString(ArrayList<String> currentVulnerabilityList) {
        String failureString = "";
        for (String tmp : currentVulnerabilityList) {
            failureString = failureString + tmp + "\n";
        }
        return failureString.trim();
    }

    private Integer getTotalOfElementsByName(Document doc, String name) {
        return doc.getElementsByTagName(name).getLength();
    }

    private void modifyElementAttribute(Document doc, String tagName, Integer index, String attrName, String value) {
        Node target = doc.getElementsByTagName(tagName).item(index);
        NamedNodeMap attr = target.getAttributes();
        Node nodeAttr = attr.getNamedItem(attrName);
        nodeAttr.setTextContent(value);
    }

    private Boolean parentDirIsWritable(File path) throws IOException {
        File parentDir = path.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            logger.error("Failed to create directory: " + parentDir.getAbsolutePath());
        }
        if (parentDir.exists()) {
            if (SystemUtils.IS_OS_WINDOWS) {
                return parentDir.canWrite();
            }
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(Paths.get(parentDir.getAbsolutePath(), new String[0]), LinkOption.NOFOLLOW_LINKS);
            return permissions.contains((Object)PosixFilePermission.OTHERS_WRITE) || permissions.contains((Object)PosixFilePermission.GROUP_WRITE) || permissions.contains((Object)PosixFilePermission.OWNER_WRITE);
        }
        return false;
    }

    static {
        lock = new ReentrantLock();
    }

    class DocResource
    implements AutoCloseable {
        private String path;
        private Document doc;
        private FileLock fileLock;
        private FileChannel fc;

        public DocResource(String path) {
            try {
                if (!JunitXmlReportWriter.this.parentDirIsWritable(new File(path)).booleanValue()) {
                    throw new IOException("Report directory is not writable: " + path);
                }
                File f = new File(path);
                this.path = f.getAbsolutePath();
                RandomAccessFile randomAccessFile = new RandomAccessFile(path, "rw");
                this.fc = randomAccessFile.getChannel();
                this.fileLock = this.fc.lock();
                this.doc = this.fc.size() == 0L ? this.createDocument() : this.loadDocument();
            }
            catch (IOException e) {
                logger.error("Exception writing log", (Throwable)e);
            }
        }

        public Document getDocument() {
            return this.doc;
        }

        @Override
        public void close() throws IOException {
            this.writeDocument(this.doc);
            this.fileLock.close();
            this.fc.close();
        }

        private Document createDocument() throws IOException {
            File f = new File(pathToReport);
            Document doc = this.getDocBuilder().newDocument();
            Element rootElement = doc.createElement("testsuites");
            doc.appendChild(rootElement);
            JunitXmlReportWriter.this.addElementAttribute(doc, rootElement, "id", "1");
            JunitXmlReportWriter.this.addElementAttribute(doc, rootElement, "failures", "0");
            JunitXmlReportWriter.this.addElementAttribute(doc, rootElement, "tests", "0");
            JunitXmlReportWriter.this.testSuite = JunitXmlReportWriter.this.addChildElement(doc, rootElement, "testsuite", "");
            JunitXmlReportWriter.this.addElementAttribute(doc, JunitXmlReportWriter.this.testSuite, "id", "1");
            JunitXmlReportWriter.this.addElementAttribute(doc, JunitXmlReportWriter.this.testSuite, "name", "OSSIndex");
            this.writeDocument(doc);
            return doc;
        }

        private Document loadDocument() {
            Document doc = null;
            try {
                StringBuilder sb = new StringBuilder();
                ByteBuffer buf = ByteBuffer.allocate(512);
                Charset charset = Charset.forName("UTF-8");
                this.fc.position(0L);
                int count2 = this.fc.read(buf);
                while (count2 != -1) {
                    buf.flip();
                    CharBuffer chbuf = charset.decode(buf);
                    for (int i = 0; i < count2; ++i) {
                        sb.append(chbuf.get());
                    }
                    buf.clear();
                    count2 = this.fc.read(buf);
                }
                InputSource is = new InputSource(new StringReader(sb.toString()));
                doc = this.getDocBuilder().parse(is);
            }
            catch (IOException | SAXException e) {
                e.printStackTrace();
                System.exit(1);
            }
            JunitXmlReportWriter.this.testSuite = (Element)doc.getElementsByTagName("testsuite").item(0);
            return doc;
        }

        private DocumentBuilder getDocBuilder() {
            DocumentBuilder docBuilder = null;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilder = docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                System.exit(1);
            }
            return docBuilder;
        }

        private void writeDocument(Document doc) throws IOException {
            if (!JunitXmlReportWriter.this.parentDirIsWritable(new File(this.path)).booleanValue()) {
                throw new IOException("Report directory is not writable: " + this.path);
            }
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(source, result);
                String s2 = writer.toString();
                this.fc.truncate(0L);
                ByteBuffer buf = ByteBuffer.allocate(s2.length());
                buf.clear();
                buf.put(s2.getBytes());
                buf.flip();
                while (buf.hasRemaining()) {
                    this.fc.write(buf);
                }
            }
            catch (TransformerConfigurationException e) {
                throw new IOException(e);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
        }
    }
}

