/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle.input;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.ResolvedDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleArtifact {
    private static final Logger logger = LoggerFactory.getLogger(GradleArtifact.class);
    private final GradleArtifact parent;
    private final Set<GradleArtifact> children;
    private final String group;
    private final String name;
    private final String version;

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<GradleArtifact> getAllArtifacts() {
        HashSet<GradleArtifact> allGradleArtifacts = new HashSet<GradleArtifact>();
        allGradleArtifacts.add(this);
        allGradleArtifacts.addAll(this.getAllChildren());
        return allGradleArtifacts;
    }

    public Set<GradleArtifact> getAllChildren() {
        HashSet<GradleArtifact> allChildren = new HashSet<GradleArtifact>();
        for (GradleArtifact child : this.children) {
            allChildren.add(child);
            allChildren.addAll(child.children);
        }
        return allChildren;
    }

    public GradleArtifact(GradleArtifact parent, ResolvedDependency gradleArtifact) {
        this.parent = parent;
        this.children = new HashSet<GradleArtifact>();
        this.name = gradleArtifact.getModule().getId().getName();
        this.group = gradleArtifact.getModule().getId().getGroup();
        this.version = gradleArtifact.getModule().getId().getVersion();
        this.addChildren(gradleArtifact);
    }

    public GradleArtifact getTopMostParent() {
        if (this.parent == null) {
            return this;
        }
        GradleArtifact currentParent = this.parent;
        HashSet<GradleArtifact> visited = new HashSet<GradleArtifact>();
        while (currentParent.parent != null) {
            currentParent = currentParent.parent;
            if (visited.contains(currentParent)) {
                logger.warn("artifact loop detected, starting with " + currentParent.getGroup() + ":" + currentParent.getName() + ":" + currentParent.getVersion());
                break;
            }
            visited.add(currentParent);
        }
        return currentParent;
    }

    public boolean containsPackage(String fullQualifiedName) {
        return this.getAllArtifacts().stream().anyMatch(c -> c.getFullDescription().equals(fullQualifiedName));
    }

    public String getFullDescription() {
        return String.format("%s:%s:%s", this.group, this.name, this.version);
    }

    private boolean ancestorIsAlso(ResolvedDependency gradleArtifact) {
        if (this.parent == null) {
            return false;
        }
        GradleArtifact currentParent = this.parent;
        while (currentParent != null) {
            if (this.isEquivalent(gradleArtifact, currentParent)) {
                return true;
            }
            currentParent = currentParent.parent;
        }
        return false;
    }

    private void addChildren(ResolvedDependency gradleArtifact) {
        gradleArtifact.getChildren().forEach(c -> {
            if (!this.ancestorIsAlso((ResolvedDependency)c)) {
                GradleArtifact child = new GradleArtifact(this, (ResolvedDependency)c);
                this.children.add(child);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleArtifact gradleArtifact = (GradleArtifact)o;
        return this.getFullDescription() != null ? this.getFullDescription().equals(gradleArtifact.getFullDescription()) : gradleArtifact.getFullDescription() == null;
    }

    private boolean isEquivalent(ResolvedDependency dependency, GradleArtifact artifact) {
        return dependency.getModule().getId().getName().equals(artifact.getName()) && dependency.getModule().getId().getGroup().equals(artifact.getGroup()) && dependency.getModule().getId().getVersion().equals(artifact.getVersion());
    }

    public int hashCode() {
        return this.getFullDescription() != null ? this.getFullDescription().hashCode() : 0;
    }

    public Set<GradleArtifact> getChildren() {
        return this.children;
    }
}

