/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.plugins.ci;

import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import name.remal.DefaultKt;
import name.remal.Java_io_FileKt;
import name.remal.gradle_plugins.dsl.EnvironmentVariable;
import name.remal.gradle_plugins.dsl.Plugin;
import name.remal.gradle_plugins.dsl.PluginAction;
import name.remal.gradle_plugins.dsl.PluginActionsGroup;
import name.remal.gradle_plugins.dsl.PluginCondition;
import name.remal.gradle_plugins.dsl.WithPluginClasses;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_plugins_ExtensionContainerKt;
import name.remal.gradle_plugins.plugins.ci.BaseCIPlugin;
import name.remal.gradle_plugins.plugins.vcs.VcsOperationsExtension;
import name.remal.gradle_plugins.plugins.vcs.VcsOperationsPlugin;
import org.gradle.api.plugins.ExtensionContainer;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Plugin(id="name.remal.gitlab-ci", description="Plugin that helps to integrate with GitLab CI.", tags={"gitlab-ci", "gitlab"})
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0006"}, d2={"Lname/remal/gradle_plugins/plugins/ci/GitlabCIPlugin;", "Lname/remal/gradle_plugins/plugins/ci/BaseCIPlugin;", "()V", "Check if GITLAB_CI = 'true'", "", "ConfigureVcsOperationsPlugin", "gradle-plugins"})
public class GitlabCIPlugin
extends BaseCIPlugin {
    @PluginCondition
    public boolean Check if GITLAB_CI = 'true'() {
        return Intrinsics.areEqual((Object)"true", (Object)System.getenv("GITLAB_CI"));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @PluginActionsGroup(value="Configure name.remal.vcs-operations plugin")
    @WithPluginClasses(value={VcsOperationsPlugin.class})
    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007J\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lname/remal/gradle_plugins/plugins/ci/GitlabCIPlugin$ConfigureVcsOperationsPlugin;", "", "(Lname/remal/gradle_plugins/plugins/ci/GitlabCIPlugin;)V", "Setup VCS remote URI if SSH_PRIVATE_KEY environment variable is set", "", "Lorg/gradle/api/plugins/ExtensionContainer;", "setOverwriteCurrentBranch", "gradle-plugins"})
    public final class ConfigureVcsOperationsPlugin {
        @PluginAction(value="vcsOperations.overwriteCurrentBranch = getenv('CI_COMMIT_REF_NAME')")
        public final void setOverwriteCurrentBranch(@NotNull ExtensionContainer $receiver) {
            block0: {
                String string;
                String refName;
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                String string2 = System.getenv("CI_COMMIT_REF_NAME");
                if (string2 == null || !((charSequence = (CharSequence)(refName = (string = string2))).length() > 0) || !((charSequence = (CharSequence)System.getenv("CI_COMMIT_TAG")) == null || charSequence.length() == 0)) break block0;
                ((VcsOperationsExtension)Org_gradle_api_plugins_ExtensionContainerKt.get((ExtensionContainer)$receiver, VcsOperationsExtension.class)).setOverwriteCurrentBranch(refName);
            }
        }

        @PluginAction
        @EnvironmentVariable.EnvironmentVariables(value={@EnvironmentVariable(value="SSH_PRIVATE_KEY", description="SSH private key to push into repository"), @EnvironmentVariable(value="SSH_PRIVATE_KEY_PASSWORD", description="SSH private key password to push into repository")})
        public final void Setup VCS remote URI if SSH_PRIVATE_KEY environment variable is set(@NotNull ExtensionContainer $receiver) {
            CharSequence charSequence;
            String string;
            VcsOperationsExtension vcsOperations2;
            block8: {
                block7: {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    vcsOperations2 = (VcsOperationsExtension)Org_gradle_api_plugins_ExtensionContainerKt.get((ExtensionContainer)$receiver, VcsOperationsExtension.class);
                    string = System.getenv("SSH_PRIVATE_KEY");
                    if (string == null) break block7;
                    charSequence = string;
                    String string2 = charSequence;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    if (string != null) break block8;
                }
                return;
            }
            String sshPrivateKey = string;
            charSequence = sshPrivateKey;
            if (charSequence.length() == 0) {
                return;
            }
            String string3 = System.getenv("CI_REPOSITORY_URL");
            if (string3 == null) {
                return;
            }
            URI repositoryURI = new URI(string3);
            if (StringsKt.startsWith$default((String)DefaultKt.default$default((String)repositoryURI.getScheme(), null, (int)1, null), (String)"http", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder;
                StringBuilder $receiver2 = stringBuilder = new StringBuilder();
                $receiver2.append("git@");
                $receiver2.append(repositoryURI.getHost());
                $receiver2.append(":");
                String string4 = repositoryURI.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"repositoryURI.path");
                $receiver2.append(StringsKt.substringAfter$default((String)string4, (char)'/', null, (int)2, null));
                String string5 = stringBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
                String remoteURI = string5;
                GitlabCIPlugin.this.getLogger().lifecycle("VCS: Changing remote URI to {}", new Object[]{remoteURI});
                vcsOperations2.setUnauthorizedRemoteURI(remoteURI);
            }
            File sshKeysDir = Java_io_FileKt.allowAllOnlyForOwner((File)Java_io_FileKt.createDirectories((File)FilesKt.resolve((File)Java_io_FileKt.getUSER_HOME_DIR(), (String)".ssh-keys")));
            File sshPrivateKeyFile = Java_io_FileKt.forbidExecute((File)Java_io_FileKt.allowAllOnlyForOwner((File)Java_io_FileKt.newTempFile$default(null, (String)".priv", (boolean)false, (File)sshKeysDir, (int)5, null)));
            FilesKt.writeText$default((File)sshPrivateKeyFile, (String)sshPrivateKey, null, (int)2, null);
            GitlabCIPlugin.this.getLogger().lifecycle("VCS: using SSH private key {}", new Object[]{sshPrivateKeyFile});
            vcsOperations2.setSSHAuth(sshPrivateKeyFile, System.getenv("SSH_PRIVATE_KEY_PASSWORD"));
        }
    }
}

