/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.okhttp3.internal.http;

import java.net.Proxy;
import name.remal.gradle_plugins.internal._relocated.okhttp3.HttpUrl;
import name.remal.gradle_plugins.internal._relocated.okhttp3.Request;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public final class RequestLine {
    private RequestLine() {
    }

    public static String get(Request request, Proxy.Type proxyType) {
        StringBuilder result = new StringBuilder();
        result.append(request.method());
        result.append(' ');
        if (RequestLine.includeAuthorityInRequestLine(request, proxyType)) {
            result.append(request.url());
        } else {
            result.append(RequestLine.requestPath(request.url()));
        }
        result.append(" HTTP/1.1");
        return result.toString();
    }

    private static boolean includeAuthorityInRequestLine(Request request, Proxy.Type proxyType) {
        return !request.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    public static String requestPath(HttpUrl url2) {
        String path = url2.encodedPath();
        String query = url2.encodedQuery();
        return query != null ? path + '?' + query : path;
    }
}

