/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class ReflectionUtils {
    private static void unusedMethod() {
        new Thread().destroy();
    }

    public static Object getFieldVal(Object obj, String fieldName, boolean throwException) {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Field field = classOrSuperclass.getDeclaredField(fieldName);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return field.get(obj);
                }
                catch (NoSuchFieldException field) {
                    continue;
                }
                catch (Throwable e) {
                    if (!throwException) continue;
                    throw new IllegalArgumentException("Could not get value of field \"" + fieldName + "\"", e);
                }
            }
            if (throwException) {
                throw new IllegalArgumentException("Field \"" + fieldName + "\" doesn't exist");
            }
        } else if (throwException) {
            throw new NullPointerException("Can't get field value for null object");
        }
        return null;
    }

    public static Object getStaticFieldVal(Class<?> cls, String fieldName, boolean throwException) {
        if (cls != null) {
            for (Class<?> classOrSuperclass = cls; classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Field field = classOrSuperclass.getDeclaredField(fieldName);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return field.get(null);
                }
                catch (NoSuchFieldException field) {
                    continue;
                }
                catch (Throwable e) {
                    if (!throwException) continue;
                    throw new IllegalArgumentException("Could not get value of field \"" + fieldName + "\"", e);
                }
            }
            if (throwException) {
                throw new IllegalArgumentException("Field \"" + fieldName + "\" doesn't exist");
            }
        } else if (throwException) {
            throw new NullPointerException("Can't get field value for null class reference");
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, boolean throwException) {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Method method = classOrSuperclass.getDeclaredMethod(methodName, new Class[0]);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException method) {
                    continue;
                }
                catch (Throwable e) {
                    if (!throwException) continue;
                    throw new IllegalArgumentException("Could not invoke method \"" + methodName + "\"", e);
                }
            }
            if (throwException) {
                throw new IllegalArgumentException("Method \"" + methodName + "\" doesn't exist");
            }
        } else if (throwException) {
            throw new NullPointerException("Can't get field value for null object");
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?> argType, Object arg, boolean throwException) {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Method method = classOrSuperclass.getDeclaredMethod(methodName, argType);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method.invoke(obj, arg);
                }
                catch (NoSuchMethodException method) {
                    continue;
                }
                catch (Throwable e) {
                    if (!throwException) continue;
                    throw new IllegalArgumentException("Could not invoke method \"" + methodName + "\"", e);
                }
            }
            if (throwException) {
                throw new IllegalArgumentException("Method \"" + methodName + "\" doesn't exist");
            }
        } else if (throwException) {
            throw new NullPointerException("Can't get field value for null object");
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, boolean throwException) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (cls != null) {
            try {
                Method method = cls.getDeclaredMethod(methodName, new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                if (throwException) {
                    throw new IllegalArgumentException("Could not invoke method \"" + methodName + "\"", e);
                }
            }
        } else if (throwException) {
            throw new NullPointerException("Can't get field value for null class reference");
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Class<?> argType, Object arg, boolean throwException) {
        if (cls != null) {
            try {
                Method method = cls.getDeclaredMethod(methodName, argType);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method.invoke(null, arg);
            }
            catch (Throwable e) {
                if (throwException) {
                    throw new IllegalArgumentException("Could not invoke method \"" + methodName + "\"", e);
                }
            }
        } else if (throwException) {
            throw new NullPointerException("Can't get field value for null class reference");
        }
        return null;
    }
}

