/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.URLPathEncoder;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class ClasspathUtils {
    public static URL getClasspathResourceURL(File classpathElt, String relativePath) {
        String classpathEltURL;
        boolean classpathEltIsJar = classpathElt.isFile();
        try {
            classpathEltURL = classpathElt.toURI().toURL().toString();
            if (!classpathEltIsJar && !classpathEltURL.endsWith("/")) {
                classpathEltURL = classpathEltURL + "/";
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String relativePathEncoded = URLPathEncoder.encodePath(relativePath);
        String url2 = classpathEltIsJar ? "jar:" + classpathEltURL + "!/" + relativePathEncoded : classpathEltURL + relativePathEncoded;
        try {
            return new URL(url2);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean canRead(File file) {
        try {
            return file.canRead();
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

