/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefOrTypeVariableSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.MethodTypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.TypeParameter;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class MethodInfo
extends ScanResult.InfoObject
implements Comparable<MethodInfo> {
    private final String className;
    ClassInfo classInfo;
    private final String methodName;
    private final int modifiers;
    private final String typeDescriptorStr;
    private final String typeSignatureStr;
    private MethodTypeSignature typeSignature;
    private final String[] parameterNames;
    private final int[] parameterModifiers;
    final AnnotationInfo[][] parameterAnnotationInfo;
    final List<AnnotationInfo> annotationInfo;
    private ScanResult scanResult;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final TypeSignature[] EMPTY_TYPE_SIGNATURE_ARRAY = new TypeSignature[0];
    private static final TypeParameter[] EMPTY_TYPE_PARAMETER_ARRAY = new TypeParameter[0];
    private static final ClassRefOrTypeVariableSignature[] EMPTY_CLASS_TYPE_OR_TYPE_VARIABLE_SIGNATURE_ARRAY = new ClassRefOrTypeVariableSignature[0];
    private static final Class<?>[] EMPTY_CLASS_REF_ARRAY = new Class[0];

    @Override
    void setScanResult(ScanResult scanResult) {
        int i;
        this.scanResult = scanResult;
        if (this.annotationInfo != null) {
            for (i = 0; i < this.annotationInfo.size(); ++i) {
                AnnotationInfo ai = this.annotationInfo.get(i);
                ai.setScanResult(scanResult);
            }
        }
        if (this.parameterAnnotationInfo != null) {
            for (i = 0; i < this.parameterAnnotationInfo.length; ++i) {
                AnnotationInfo[] pai = this.parameterAnnotationInfo[i];
                if (pai == null) continue;
                for (AnnotationInfo ai : pai) {
                    ai.setScanResult(scanResult);
                }
            }
        }
    }

    public MethodInfo(String className, String methodName, List<AnnotationInfo> methodAnnotationInfo, int modifiers, String typeDescriptorStr, String typeSignatureStr, String[] parameterNames, int[] parameterModifiers, AnnotationInfo[][] parameterAnnotationInfo) {
        this.className = className;
        this.methodName = methodName;
        this.modifiers = modifiers;
        this.typeDescriptorStr = typeDescriptorStr;
        this.typeSignatureStr = typeSignatureStr;
        this.parameterNames = parameterNames;
        this.parameterModifiers = parameterModifiers;
        this.parameterAnnotationInfo = parameterAnnotationInfo;
        this.annotationInfo = methodAnnotationInfo == null || methodAnnotationInfo.isEmpty() ? Collections.emptyList() : methodAnnotationInfo;
    }

    public String getModifiersStr() {
        return TypeUtils.modifiersToString(this.getModifiers(), true);
    }

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getTypeDescriptorStr() {
        return this.typeDescriptorStr;
    }

    public String getTypeSignatureStr() {
        return this.typeSignatureStr;
    }

    public MethodTypeSignature getTypeSignature() {
        if (this.typeSignature == null) {
            this.typeSignature = MethodTypeSignature.parse(this.classInfo, this.typeSignatureStr != null ? this.typeSignatureStr : this.typeDescriptorStr);
        }
        return this.typeSignature;
    }

    public int getNumParameters() {
        return this.getTypeSignature().getParameterTypeSignatures().size();
    }

    public TypeSignature getResultTypeSignature() {
        return this.getTypeSignature().getResultType();
    }

    public String getResultTypeStr() {
        return this.getResultTypeSignature().toString();
    }

    public Class<?> getResultType() throws IllegalArgumentException {
        return this.getResultTypeSignature().instantiate(this.scanResult);
    }

    private static String[] toStringArray(List<?> list) {
        if (list.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).toString();
        }
        return stringArray;
    }

    private static Class<?>[] toClassRefs(List<? extends TypeSignature> typeSignatures, ScanResult scanResult) {
        if (typeSignatures.size() == 0) {
            return EMPTY_CLASS_REF_ARRAY;
        }
        Class[] classRefArray = new Class[typeSignatures.size()];
        for (int i = 0; i < typeSignatures.size(); ++i) {
            classRefArray[i] = typeSignatures.get(i).instantiate(scanResult);
        }
        return classRefArray;
    }

    private static TypeSignature[] toTypeSignatureArray(List<? extends TypeSignature> typeSignatures) {
        if (typeSignatures.size() == 0) {
            return EMPTY_TYPE_SIGNATURE_ARRAY;
        }
        return typeSignatures.toArray(new TypeSignature[typeSignatures.size()]);
    }

    private static ClassRefOrTypeVariableSignature[] toTypeOrTypeVariableSignatureArray(List<? extends ClassRefOrTypeVariableSignature> typeSignatures) {
        if (typeSignatures.size() == 0) {
            return EMPTY_CLASS_TYPE_OR_TYPE_VARIABLE_SIGNATURE_ARRAY;
        }
        return typeSignatures.toArray(new ClassRefOrTypeVariableSignature[typeSignatures.size()]);
    }

    private static TypeParameter[] toTypeParameterArray(List<? extends TypeParameter> typeParameters) {
        if (typeParameters.size() == 0) {
            return EMPTY_TYPE_PARAMETER_ARRAY;
        }
        return typeParameters.toArray(new TypeParameter[typeParameters.size()]);
    }

    public TypeSignature[] getParameterTypeSignatures() {
        return MethodInfo.toTypeSignatureArray(this.getTypeSignature().getParameterTypeSignatures());
    }

    public Class<?>[] getParameterTypes() throws IllegalArgumentException {
        return MethodInfo.toClassRefs(this.getTypeSignature().getParameterTypeSignatures(), this.scanResult);
    }

    public String[] getParameterTypeStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().getParameterTypeSignatures());
    }

    public ClassRefOrTypeVariableSignature[] getThrowsTypeSignatures() {
        return MethodInfo.toTypeOrTypeVariableSignatureArray(this.getTypeSignature().getThrowsSignatures());
    }

    public Class<?>[] getThrowsTypes() {
        return MethodInfo.toClassRefs(this.getTypeSignature().getThrowsSignatures(), this.scanResult);
    }

    public String[] getThrowsTypeStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().getThrowsSignatures());
    }

    public TypeParameter[] getTypeParameters() {
        return MethodInfo.toTypeParameterArray(this.getTypeSignature().getTypeParameters());
    }

    public String[] getTypeParameterStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().getTypeParameters());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public String[] getParameterNames() {
        if (this.parameterNames == null) {
            return null;
        }
        if (this.getNumParameters() != this.parameterNames.length) {
            return null;
        }
        return this.parameterNames;
    }

    public int[] getParameterModifiers() {
        if (this.parameterModifiers == null) {
            return null;
        }
        if (this.getNumParameters() != this.parameterModifiers.length) {
            return null;
        }
        return this.parameterModifiers;
    }

    public String[] getParameterModifierStrs() {
        int[] paramModifiers = this.getParameterModifiers();
        if (paramModifiers == null) {
            return null;
        }
        String[] paramModifierStrs = new String[paramModifiers.length];
        for (int i = 0; i < paramModifiers.length; ++i) {
            paramModifierStrs[i] = TypeUtils.modifiersToString(paramModifiers[i], false);
        }
        return paramModifierStrs;
    }

    public AnnotationInfo[][] getParameterAnnotationInfo() {
        if (this.parameterAnnotationInfo == null) {
            return null;
        }
        if (this.getNumParameters() != this.parameterAnnotationInfo.length) {
            return null;
        }
        return this.parameterAnnotationInfo;
    }

    public String[][] getParameterAnnotationNames() {
        AnnotationInfo[][] paramAnnotationInfo = this.getParameterAnnotationInfo();
        if (paramAnnotationInfo == null) {
            return null;
        }
        String[][] paramAnnotationNames = new String[paramAnnotationInfo.length][];
        for (int i = 0; i < paramAnnotationInfo.length; ++i) {
            paramAnnotationNames[i] = AnnotationInfo.getUniqueAnnotationNamesSorted(paramAnnotationInfo[i]);
        }
        return paramAnnotationNames;
    }

    public Class<?>[][] getParameterAnnotationTypes() {
        String[][] paramAnnotationNames = this.getParameterAnnotationNames();
        if (paramAnnotationNames == null) {
            return null;
        }
        Class[][] parameterAnnotationTypes = new Class[paramAnnotationNames.length][];
        for (int i = 0; i < this.parameterAnnotationInfo.length; ++i) {
            parameterAnnotationTypes[i] = new Class[paramAnnotationNames[i].length];
            for (int j = 0; j < paramAnnotationNames[i].length; ++j) {
                parameterAnnotationTypes[i][j] = this.scanResult.classNameToClassRef(paramAnnotationNames[i][j]);
            }
        }
        return parameterAnnotationTypes;
    }

    public List<String> getAnnotationNames() {
        return Arrays.asList(AnnotationInfo.getUniqueAnnotationNamesSorted(this.annotationInfo));
    }

    public List<Class<?>> getAnnotationTypes() throws IllegalArgumentException {
        if (this.annotationInfo == null || this.annotationInfo.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotationClassRefs = new ArrayList();
        for (String annotationName : this.getAnnotationNames()) {
            annotationClassRefs.add(this.scanResult.classNameToClassRef(annotationName));
        }
        return annotationClassRefs;
    }

    public List<AnnotationInfo> getAnnotationInfo() {
        return this.annotationInfo == null ? Collections.emptyList() : this.annotationInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.className.equals(other.className) && this.typeDescriptorStr.equals(other.typeDescriptorStr) && this.methodName.equals(other.methodName);
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.typeDescriptorStr.hashCode() * 11 + this.className.hashCode() * 57;
    }

    @Override
    public int compareTo(MethodInfo other) {
        int diff0 = this.className.compareTo(other.className);
        if (diff0 != 0) {
            return diff0;
        }
        int diff1 = this.methodName.compareTo(other.methodName);
        if (diff1 != 0) {
            return diff1;
        }
        return this.typeDescriptorStr.compareTo(other.typeDescriptorStr);
    }

    public String toString() {
        return this.getTypeSignature().toString(this.getAnnotationInfo(), this.getModifiers(), this.isConstructor(), this.methodName, this.isVarArgs(), this.getParameterNames(), this.getParameterModifiers(), this.getParameterAnnotationInfo());
    }
}

