/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner;

import java.util.ArrayList;
import java.util.HashSet;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class ClassLoaderFinder {
    private static CallerResolver CALLER_RESOLVER;

    /*
     * WARNING - void declaration
     */
    public static ClassLoader[] findEnvClassLoaders(ScanSpec scanSpec, LogNode log) {
        AdditionOrderedSet<Object> classLoadersUnique;
        LogNode classLoadersFoundLog = null;
        if (scanSpec.overrideClassLoaders == null) {
            Object threadClassLoader;
            classLoadersUnique = new AdditionOrderedSet();
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader != null) {
                classLoadersUnique.add(systemClassLoader);
            }
            if (CALLER_RESOLVER == null) {
                if (log != null) {
                    log.log(ClassLoaderFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
                }
            } else {
                Class<?>[] callStack = CALLER_RESOLVER.getClassContext();
                if (callStack == null) {
                    if (log != null) {
                        log.log(ClassLoaderFinder.class.getSimpleName() + ": " + CallerResolver.class.getSimpleName() + "#getClassContext() returned null");
                    }
                } else {
                    void var7_12;
                    String string = FastClasspathScanner.class.getPackage().getName() + ".";
                    int n = callStack.length - 1;
                    while (var7_12 >= 0 && !callStack[var7_12].getName().startsWith(string)) {
                        --var7_12;
                    }
                    if (var7_12 < 0 || var7_12 == callStack.length - 1) {
                        throw new RuntimeException("Could not find caller of " + string + "* in call stack");
                    }
                    ClassLoader callStackClassLoader = callStack[var7_12 + true].getClassLoader();
                    if (callStackClassLoader != null) {
                        classLoadersUnique.add(callStackClassLoader);
                    }
                }
            }
            if ((threadClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
                classLoadersUnique.add(threadClassLoader);
            }
            if (scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new AdditionOrderedSet<ClassLoader>(scanSpec.overrideClassLoaders);
            classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        HashSet<void> ancestralClassLoaders = new HashSet<void>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            void var7_14;
            ClassLoader classLoader2 = classLoader.getParent();
            while (var7_14 != null) {
                ancestralClassLoaders.add(var7_14);
                ClassLoader classLoader3 = var7_14.getParent();
            }
        }
        ArrayList<ClassLoader> classLoaderFinalOrder = new ArrayList<ClassLoader>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            if (ancestralClassLoaders.contains(classLoader)) continue;
            classLoaderFinalOrder.add(classLoader);
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader classLoader : classLoaderFinalOrder) {
                classLoadersFoundLog.log("" + classLoader);
            }
        }
        return classLoaderFinalOrder.toArray(new ClassLoader[classLoaderFinalOrder.size()]);
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @RelocatedClass
    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

