/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import java.net.URL;
import java.net.URLClassLoader;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ClasspathOrder;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class URLClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"java.net.URLClassLoader"};
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        if (urls != null) {
            for (URL url2 : urls) {
                if (url2 == null) continue;
                classpathOrderOut.addClasspathElement(url2.toString(), classLoader, log);
            }
        }
    }
}

