/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.ListExtensions;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import io.quarkus.registry.DefaultExtensionRegistry;
import io.quarkus.registry.ExtensionRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusListExtensions
extends QuarkusPlatformTask {
    private boolean all = true;
    private String format = "concise";
    private String searchPattern;
    private List<String> registries;

    @Input
    public boolean isAll() {
        return this.all;
    }

    @Option(description="List all extensions or just the installable.", option="all")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Optional
    @Input
    public String getFormat() {
        return this.format;
    }

    @Option(description="Select the output format among 'name' (display the name only), 'concise' (display name and description) and 'full' (concise format and version related columns).", option="format")
    public void setFormat(String format) {
        this.format = format;
    }

    @Optional
    @Input
    public String getSearchPattern() {
        return this.searchPattern;
    }

    @Option(description="Search filter on extension list. The format is based on Java Pattern.", option="searchPattern")
    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    @Optional
    @Input
    public List<String> getRegistries() {
        return this.registries;
    }

    @Option(description="The extension registry URLs to be used", option="registry")
    public void setRegistries(List<String> registry) {
        this.registries = registry;
    }

    public QuarkusListExtensions() {
        super("Lists the available quarkus extensions");
    }

    @TaskAction
    public void listExtensions() {
        try {
            ListExtensions listExtensions = new ListExtensions(this.getQuarkusProject()).all(this.isAll()).format(this.getFormat()).search(this.getSearchPattern());
            if (this.registries != null && !this.registries.isEmpty()) {
                List urls = this.registries.stream().map(QuarkusPlatformTask::toURL).collect(Collectors.toList());
                listExtensions.extensionRegistry((ExtensionRegistry)DefaultExtensionRegistry.fromURLs(urls));
            }
            listExtensions.execute();
        }
        catch (Exception e) {
            throw new GradleException("Unable to list extensions", (Throwable)e);
        }
    }
}

