/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.runner.bootstrap.GenerateConfigTask;
import java.io.File;
import java.util.Collections;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusGenerateConfig
extends QuarkusTask {
    private String file = "application.properties.example";

    public QuarkusGenerateConfig() {
        super("Generates an example config file");
    }

    @Optional
    @Input
    public String getFile() {
        return this.file;
    }

    @Option(description="The name of the file to generate", option="file")
    public void setFile(String file) {
        this.file = file;
    }

    @TaskAction
    public void buildQuarkus() {
        this.getLogger().lifecycle("generating example config");
        AppArtifact appArtifact = this.extension().getAppArtifact();
        appArtifact.setPaths(QuarkusGradleUtils.getOutputPaths(this.getProject()));
        AppModelResolver modelResolver = this.extension().getAppModelResolver();
        if (this.extension().resourcesDir().isEmpty()) {
            throw new GradleException("No resources directory, cannot create application.properties");
        }
        File target = this.extension().resourcesDir().iterator().next();
        String name = this.file;
        if (name == null || name.isEmpty()) {
            name = "application.properties.example";
        }
        try (CuratedApplication bootstrap = QuarkusBootstrap.builder().setBaseClassLoader(((Object)((Object)this)).getClass().getClassLoader()).setAppModelResolver(modelResolver).setTargetDirectory(this.getProject().getBuildDir().toPath()).setBaseName(this.extension().finalName()).setAppArtifact(appArtifact).setLocalProjectDiscovery(false).setIsolateDeployment(true).build().bootstrap();){
            bootstrap.runInAugmentClassLoader(GenerateConfigTask.class.getName(), Collections.singletonMap("config-file", new File(target, name).toPath()));
            this.getLogger().lifecycle("Generated config file " + name);
        }
        catch (BootstrapException e) {
            throw new RuntimeException(e);
        }
    }
}

