/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.ListPlatforms;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusListPlatforms
extends QuarkusPlatformTask {
    private boolean installed = false;

    public QuarkusListPlatforms() {
        super("Lists the available quarkus platforms");
    }

    @Input
    public boolean isInstalled() {
        return this.installed;
    }

    @Option(description="List only installed platforms.", option="installed")
    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    @TaskAction
    public void listExtensions() {
        this.getProject().getLogger().info("");
        if (this.installed) {
            this.getProject().getLogger().info("Imported Quarkus platforms:");
            this.importedPlatforms().forEach(coords -> {
                StringBuilder buf = new StringBuilder();
                buf.append(coords.getGroupId()).append(":").append(coords.getArtifactId().substring(0, coords.getArtifactId().length() - "-quarkus-platform-descriptor".length())).append("::pom:").append(coords.getVersion());
                this.messageWriter().info(buf.toString());
            });
        } else {
            this.getProject().getLogger().info("Available Quarkus platforms:");
            try {
                new ListPlatforms(this.getQuarkusProject(this.installed)).execute();
            }
            catch (Exception e) {
                throw new GradleException("Unable to list platforms", (Throwable)e);
            }
        }
        this.getProject().getLogger().info("");
    }
}

