/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.util.IoUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class QuarkusGradleUtils {
    private static final String ERROR_COLLECTING_PROJECT_CLASSES = "Failed to collect project's classes in a temporary dir";

    public static Path serializeAppModel(AppModel appModel, Task context) throws IOException {
        Path serializedModel = context.getTemporaryDir().toPath().resolve("quarkus-app-model.dat");
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedModel, new OpenOption[0]));){
            out.writeObject(appModel);
        }
        return serializedModel;
    }

    public static SourceSet getSourceSet(Project project, String sourceSetName) {
        Convention convention = project.getConvention();
        JavaPluginConvention javaConvention = (JavaPluginConvention)convention.findPlugin(JavaPluginConvention.class);
        if (javaConvention == null) {
            throw new IllegalArgumentException("The project does not include the Java plugin");
        }
        return (SourceSet)javaConvention.getSourceSets().getByName(sourceSetName);
    }

    public static PathsCollection getOutputPaths(Project project) {
        Path p;
        SourceSet mainSourceSet = QuarkusGradleUtils.getSourceSet(project, "main");
        PathsCollection.Builder builder = PathsCollection.builder();
        mainSourceSet.getOutput().getClassesDirs().filter(f -> f.exists()).forEach(f -> builder.add(f.toPath()));
        File resourcesDir = mainSourceSet.getOutput().getResourcesDir();
        if (resourcesDir != null && resourcesDir.exists() && !builder.contains(p = resourcesDir.toPath())) {
            builder.add(p);
        }
        return builder.build();
    }

    public static String getClassesDir(SourceSet sourceSet, File tmpDir) {
        return QuarkusGradleUtils.getClassesDir(sourceSet, tmpDir, true);
    }

    public static String getClassesDir(SourceSet sourceSet, File tmpDir, boolean populated) {
        FileCollection classesDirs = sourceSet.getOutput().getClassesDirs();
        Set classDirFiles = classesDirs.getFiles();
        if (classDirFiles.size() == 1) {
            return classesDirs.getAsPath();
        }
        Path classesDir = null;
        Iterator i = classDirFiles.iterator();
        int dirCount = 0;
        while (i.hasNext()) {
            File next = (File)i.next();
            if (!next.exists()) continue;
            try {
                switch (dirCount++) {
                    case 0: {
                        classesDir = next.toPath();
                        break;
                    }
                    case 1: {
                        Path tmpClassesDir = tmpDir.toPath().resolve("quarkus-app-classes");
                        if (!populated) {
                            return tmpClassesDir.toString();
                        }
                        if (Files.exists(tmpClassesDir, new LinkOption[0])) {
                            IoUtils.recursiveDelete((Path)tmpClassesDir);
                        }
                        IoUtils.copy((Path)classesDir, (Path)tmpClassesDir);
                        classesDir = tmpClassesDir;
                    }
                    default: {
                        IoUtils.copy((Path)next.toPath(), (Path)classesDir);
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(ERROR_COLLECTING_PROJECT_CLASSES, e);
            }
        }
        if (classesDir == null) {
            throw new IllegalStateException("Failed to locate classes directory in the project");
        }
        return classesDir.toString();
    }
}

