/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.gradle.builder.QuarkusModelBuilder;
import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.extension.SourceSetExtension;
import io.quarkus.gradle.tasks.QuarkusAddExtension;
import io.quarkus.gradle.tasks.QuarkusBuild;
import io.quarkus.gradle.tasks.QuarkusDev;
import io.quarkus.gradle.tasks.QuarkusGenerateCode;
import io.quarkus.gradle.tasks.QuarkusGenerateConfig;
import io.quarkus.gradle.tasks.QuarkusListExtensions;
import io.quarkus.gradle.tasks.QuarkusListPlatforms;
import io.quarkus.gradle.tasks.QuarkusRemoteDev;
import io.quarkus.gradle.tasks.QuarkusRemoveExtension;
import io.quarkus.gradle.tasks.QuarkusTestConfig;
import io.quarkus.gradle.tasks.QuarkusTestNative;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.util.GradleVersion;

public class QuarkusPlugin
implements Plugin<Project> {
    public static final String ID = "io.quarkus";
    public static final String QUARKUS_PACKAGE_TYPE = "quarkus.package.type";
    public static final String EXTENSION_NAME = "quarkus";
    public static final String LIST_EXTENSIONS_TASK_NAME = "listExtensions";
    public static final String LIST_PLATFORMS_TASK_NAME = "listPlatforms";
    public static final String ADD_EXTENSION_TASK_NAME = "addExtension";
    public static final String REMOVE_EXTENSION_TASK_NAME = "removeExtension";
    public static final String QUARKUS_GENERATE_CODE_TASK_NAME = "quarkusGenerateCode";
    public static final String QUARKUS_GENERATE_CODE_TESTS_TASK_NAME = "quarkusGenerateCodeTests";
    public static final String QUARKUS_BUILD_TASK_NAME = "quarkusBuild";
    public static final String GENERATE_CONFIG_TASK_NAME = "generateConfig";
    public static final String QUARKUS_DEV_TASK_NAME = "quarkusDev";
    public static final String QUARKUS_REMOTE_DEV_TASK_NAME = "quarkusRemoteDev";
    public static final String DEV_MODE_CONFIGURATION_NAME = "quarkusDev";
    public static final String ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "quarkusAnnotationProcessor";
    @Deprecated
    public static final String BUILD_NATIVE_TASK_NAME = "buildNative";
    public static final String TEST_NATIVE_TASK_NAME = "testNative";
    @Deprecated
    public static final String QUARKUS_TEST_CONFIG_TASK_NAME = "quarkusTestConfig";
    public static final String NATIVE_TEST_SOURCE_SET_NAME = "native-test";
    public static final String NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME = "nativeTestImplementation";
    public static final String NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "nativeTestRuntimeOnly";
    private final ToolingModelBuilderRegistry registry;

    @Inject
    public QuarkusPlugin(ToolingModelBuilderRegistry registry) {
        this.registry = registry;
    }

    public void apply(Project project) {
        this.verifyGradleVersion();
        this.registerModel();
        QuarkusPluginExtension quarkusExt = (QuarkusPluginExtension)project.getExtensions().create(EXTENSION_NAME, QuarkusPluginExtension.class, new Object[]{project});
        this.registerTasks(project, quarkusExt);
    }

    private void registerTasks(Project project, final QuarkusPluginExtension quarkusExt) {
        TaskContainer tasks = project.getTasks();
        tasks.create(LIST_EXTENSIONS_TASK_NAME, QuarkusListExtensions.class);
        tasks.create(LIST_PLATFORMS_TASK_NAME, QuarkusListPlatforms.class);
        tasks.create(ADD_EXTENSION_TASK_NAME, QuarkusAddExtension.class);
        tasks.create(REMOVE_EXTENSION_TASK_NAME, QuarkusRemoveExtension.class);
        tasks.create(GENERATE_CONFIG_TASK_NAME, QuarkusGenerateConfig.class);
        QuarkusGenerateCode quarkusGenerateCode = (QuarkusGenerateCode)tasks.create(QUARKUS_GENERATE_CODE_TASK_NAME, QuarkusGenerateCode.class);
        QuarkusGenerateCode quarkusGenerateCodeTests = (QuarkusGenerateCode)tasks.create(QUARKUS_GENERATE_CODE_TESTS_TASK_NAME, QuarkusGenerateCode.class);
        quarkusGenerateCodeTests.setTest(true);
        Task quarkusBuild = tasks.create(QUARKUS_BUILD_TASK_NAME, QuarkusBuild.class);
        quarkusBuild.dependsOn(new Object[]{quarkusGenerateCode});
        Task quarkusDev = tasks.create("quarkusDev", QuarkusDev.class);
        Task quarkusRemoteDev = tasks.create(QUARKUS_REMOTE_DEV_TASK_NAME, QuarkusRemoteDev.class);
        tasks.create(QUARKUS_TEST_CONFIG_TASK_NAME, QuarkusTestConfig.class);
        Task buildNative = tasks.create(BUILD_NATIVE_TASK_NAME, DefaultTask.class);
        buildNative.finalizedBy(new Object[]{quarkusBuild});
        buildNative.doFirst(t -> project.getLogger().warn("The 'buildNative' task has been deprecated in favor of 'build -Dquarkus.package.type=native'"));
        this.configureBuildNativeTask(project);
        Consumer<Test> configureTestTask = t -> {
            t.doFirst((Action)new Action<Task>(){

                public void execute(Task test) {
                    quarkusExt.beforeTest(t);
                }
            });
            t.useJUnitPlatform();
            quarkusBuild.shouldRunAfter(new Object[]{t});
        };
        project.getPlugins().withType(BasePlugin.class, basePlugin -> tasks.getByName("assemble").dependsOn(new Object[]{quarkusBuild}));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            project.afterEvaluate(this::afterEvaluate);
            ConfigurationContainer configurations = project.getConfigurations();
            JavaCompile compileJavaTask = (JavaCompile)tasks.getByName("compileJava");
            Configuration annotationProcessorConfig = ((Configuration)configurations.create(ANNOTATION_PROCESSOR_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{configurations.getByName("compileClasspath"), configurations.getByName("annotationProcessor")});
            compileJavaTask.getOptions().setAnnotationProcessorPath((FileCollection)annotationProcessorConfig);
            compileJavaTask.dependsOn(new Object[]{quarkusGenerateCode});
            quarkusGenerateCode.setSourceRegistrar(xva$0 -> compileJavaTask.source(new Object[]{xva$0}));
            JavaCompile compileTestJavaTask = (JavaCompile)tasks.getByName("compileTestJava");
            compileTestJavaTask.dependsOn(new Object[]{quarkusGenerateCodeTests});
            quarkusGenerateCodeTests.setSourceRegistrar(xva$0 -> compileTestJavaTask.source(new Object[]{xva$0}));
            Task classesTask = tasks.getByName("classes");
            Task resourcesTask = tasks.getByName("processResources");
            quarkusDev.dependsOn(new Object[]{classesTask, resourcesTask, quarkusGenerateCode});
            quarkusRemoteDev.dependsOn(new Object[]{classesTask, resourcesTask});
            quarkusBuild.dependsOn(new Object[]{classesTask, resourcesTask, tasks.getByName("jar")});
            SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
            SourceSet nativeTestSourceSet = (SourceSet)sourceSets.create(NATIVE_TEST_SOURCE_SET_NAME);
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
            quarkusGenerateCode.setSourcesDirectories(this.getSourcesParents(mainSourceSet));
            quarkusGenerateCodeTests.setSourcesDirectories(this.getSourcesParents(testSourceSet));
            nativeTestSourceSet.setCompileClasspath(nativeTestSourceSet.getCompileClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            nativeTestSourceSet.setRuntimeClasspath(nativeTestSourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            ((Configuration)configurations.create("quarkusDev")).extendsFrom(new Configuration[]{configurations.getByName("compileOnly"), configurations.getByName("runtimeClasspath")});
            ((Configuration)configurations.maybeCreate(NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configurations.findByName("testImplementation")});
            ((Configuration)configurations.maybeCreate(NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configurations.findByName("testRuntimeOnly")});
            Task testNative = tasks.create(TEST_NATIVE_TASK_NAME, QuarkusTestNative.class);
            testNative.dependsOn(new Object[]{quarkusBuild});
            testNative.setShouldRunAfter(Collections.singletonList(tasks.findByName("test")));
            tasks.withType(Test.class).forEach(configureTestTask);
            tasks.withType(Test.class).whenTaskAdded(configureTestTask::accept);
            ((SourceSet)sourceSets.create("quarkus-generated-sources")).getOutput().dir((Object)"quarkus-generated-sources");
            ((SourceSet)sourceSets.create("quarkus-test-generated-sources")).getOutput().dir((Object)"quarkus-test-generated-sources");
        });
        project.getPlugins().withId("org.jetbrains.kotlin.jvm", plugin -> {
            tasks.getByName("compileKotlin").dependsOn(new Object[]{quarkusGenerateCode});
            tasks.getByName("compileTestKotlin").dependsOn(new Object[]{quarkusGenerateCodeTests});
            SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
            SourceSet generatedSourceSet = (SourceSet)sourceSets.getByName("quarkus-generated-sources");
            SourceSet generatedTestSourceSet = (SourceSet)sourceSets.getByName("quarkus-test-generated-sources");
            for (String provider : QuarkusGenerateCode.CODE_GENERATION_PROVIDER) {
                mainSourceSet.getJava().srcDir((Object)new File(generatedSourceSet.getJava().getOutputDir(), provider));
                testSourceSet.getJava().srcDir((Object)new File(generatedTestSourceSet.getJava().getOutputDir(), provider));
            }
        });
    }

    private Set<Path> getSourcesParents(SourceSet mainSourceSet) {
        Set srcDirs = mainSourceSet.getJava().getSrcDirs();
        return srcDirs.stream().map(File::toPath).map(Path::getParent).collect(Collectors.toSet());
    }

    private void registerModel() {
        this.registry.register((ToolingModelBuilder)new QuarkusModelBuilder());
    }

    private void verifyGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.0")) < 0) {
            throw new GradleException("Quarkus plugin requires Gradle 5.0 or later. Current version is: " + GradleVersion.current());
        }
    }

    private void configureBuildNativeTask(Project project) {
        project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(project.getPath() + BUILD_NATIVE_TASK_NAME) || taskGraph.hasTask(project.getPath() + TEST_NATIVE_TASK_NAME)) {
                project.getExtensions().getExtraProperties().set(QUARKUS_PACKAGE_TYPE, (Object)"native");
            }
        });
    }

    private void afterEvaluate(Project project) {
        HashSet visited = new HashSet();
        ConfigurationContainer configurations = project.getConfigurations();
        configurations.getByName("compileClasspath").getIncoming().getDependencies().forEach(d -> {
            if (d instanceof ProjectDependency) {
                this.visitProjectDep(project, ((ProjectDependency)d).getDependencyProject(), visited);
            }
        });
        SourceSetExtension sourceSetExtension = ((QuarkusPluginExtension)project.getExtensions().getByType(QuarkusPluginExtension.class)).sourceSetExtension();
        if (sourceSetExtension.extraNativeTest() != null) {
            SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
            SourceSet nativeTestSourceSets = (SourceSet)sourceSets.getByName(NATIVE_TEST_SOURCE_SET_NAME);
            nativeTestSourceSets.setCompileClasspath(nativeTestSourceSets.getCompileClasspath().plus((FileCollection)sourceSetExtension.extraNativeTest().getOutput()));
            nativeTestSourceSets.setRuntimeClasspath(nativeTestSourceSets.getRuntimeClasspath().plus((FileCollection)sourceSetExtension.extraNativeTest().getOutput()));
            ((Configuration)configurations.findByName(NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configurations.findByName(sourceSetExtension.extraNativeTest().getImplementationConfigurationName())});
            ((Configuration)configurations.findByName(NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configurations.findByName(sourceSetExtension.extraNativeTest().getRuntimeOnlyConfigurationName())});
            QuarkusTestNative nativeTest = (QuarkusTestNative)project.getTasks().getByName(TEST_NATIVE_TASK_NAME);
            nativeTest.setTestClassesDirs(nativeTestSourceSets.getOutput().getClassesDirs());
            nativeTest.setClasspath(nativeTestSourceSets.getRuntimeClasspath());
        }
    }

    private void visitProjectDep(Project project, Project dep, Set<String> visited) {
        if (dep.getState().getExecuted()) {
            this.setupQuarkusBuildTaskDeps(project, dep, visited);
        } else {
            dep.afterEvaluate(p -> this.setupQuarkusBuildTaskDeps(project, (Project)p, visited));
        }
    }

    private void setupQuarkusBuildTaskDeps(Project project, Project dep, Set<String> visited) {
        Configuration compileConfig;
        Task quarkusDev;
        Task jarTask;
        if (!visited.add(dep.getPath())) {
            return;
        }
        project.getLogger().debug("Configuring {} task dependencies on {} tasks", (Object)project, (Object)dep);
        Task quarkusBuild = (Task)project.getTasks().findByName(QUARKUS_BUILD_TASK_NAME);
        if (quarkusBuild != null && (jarTask = (Task)dep.getTasks().findByName("jar")) != null) {
            Task quarkusPrepare = (Task)project.getTasks().findByName(QUARKUS_GENERATE_CODE_TASK_NAME);
            Task quarkusPrepareTests = (Task)project.getTasks().findByName(QUARKUS_GENERATE_CODE_TESTS_TASK_NAME);
            quarkusBuild.dependsOn(new Object[]{jarTask});
            if (quarkusPrepare != null) {
                quarkusPrepare.dependsOn(new Object[]{jarTask});
            }
            if (quarkusPrepareTests != null) {
                quarkusPrepareTests.dependsOn(new Object[]{jarTask});
            }
        }
        if ((quarkusDev = (Task)project.getTasks().findByName("quarkusDev")) != null) {
            Task resourcesTaskJandex;
            Task resourcesTask = (Task)dep.getTasks().findByName("processResources");
            if (resourcesTask != null) {
                quarkusDev.dependsOn(new Object[]{resourcesTask});
            }
            if ((resourcesTaskJandex = (Task)dep.getTasks().findByName("jandex")) != null) {
                quarkusDev.dependsOn(new Object[]{resourcesTaskJandex});
            }
        }
        if ((compileConfig = (Configuration)dep.getConfigurations().findByName("compileClasspath")) != null) {
            compileConfig.getIncoming().getDependencies().forEach(d -> {
                if (d instanceof ProjectDependency) {
                    this.visitProjectDep(project, ((ProjectDependency)d).getDependencyProject(), visited);
                }
            });
        }
    }
}

