/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.devtools.project.buildfile.AbstractGradleBuildFile;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Category;

public abstract class GradleProjectBuildFile
extends AbstractGradleBuildFile {
    private final Project project;

    public GradleProjectBuildFile(Project project, ExtensionCatalog catalog) {
        super(project.getProjectDir().toPath(), catalog, project.getParent() != null ? project.getRootProject().getProjectDir().toPath() : project.getProjectDir().toPath());
        this.project = project;
    }

    protected List<AppArtifactCoords> getDependencies() throws IOException {
        List<Dependency> boms = this.boms();
        Set resolvedArtifacts = this.project.getConfigurations().getByName("runtimeClasspath").getResolvedConfiguration().getResolvedArtifacts();
        ArrayList<AppArtifactCoords> coords = new ArrayList<AppArtifactCoords>(boms.size() + resolvedArtifacts.size());
        boms.forEach(d -> coords.add(new AppArtifactCoords(d.getGroup(), d.getName(), null, "pom", d.getVersion())));
        resolvedArtifacts.forEach(a -> coords.add(new AppArtifactCoords(a.getModuleVersion().getId().getGroup(), a.getName(), a.getClassifier(), a.getExtension(), a.getModuleVersion().getId().getVersion())));
        return coords;
    }

    private List<Dependency> boms() {
        ArrayList<Dependency> boms = new ArrayList<Dependency>();
        Configuration impl = this.project.getConfigurations().getByName("implementation");
        for (Dependency d : impl.getAllDependencies()) {
            ModuleDependency module;
            Category category;
            if (!(d instanceof ModuleDependency) || (category = (Category)(module = (ModuleDependency)d).getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE)) == null || !"enforced-platform".equals(category.getName()) && !"platform".equals(category.getName())) continue;
            boms.add(d);
        }
        return boms;
    }

    public List<AppArtifactCoords> getInstalledPlatforms() throws IOException {
        List<Dependency> bomDeps = this.boms();
        if (bomDeps.isEmpty()) {
            return Collections.emptyList();
        }
        Configuration boms = this.project.getConfigurations().detachedConfiguration(bomDeps.toArray(new Dependency[0]));
        ArrayList<AppArtifactCoords> platforms = new ArrayList<AppArtifactCoords>();
        boms.getResolutionStrategy().eachDependency(d -> {
            if (!d.getTarget().getName().endsWith("-quarkus-platform-descriptor")) {
                return;
            }
            AppArtifactCoords platform = new AppArtifactCoords(d.getTarget().getGroup(), PlatformArtifacts.ensureBomArtifactId((String)d.getTarget().getName()), null, "pom", d.getTarget().getVersion());
            platforms.add(platform);
        });
        boms.getResolvedConfiguration();
        return platforms;
    }
}

