/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.devtools.project.buildfile.AbstractGradleBuildFile;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Category;

public abstract class GradleProjectBuildFile
extends AbstractGradleBuildFile {
    private final Project project;

    public GradleProjectBuildFile(Project project, QuarkusPlatformDescriptor platformDescriptor) {
        super(project.getProjectDir().toPath(), platformDescriptor, project.getParent() != null ? project.getRootProject().getProjectDir().toPath() : project.getProjectDir().toPath());
        this.project = project;
    }

    protected List<AppArtifactCoords> getDependencies() throws IOException {
        HashSet<Dependency> boms = new HashSet<Dependency>();
        Configuration impl = this.project.getConfigurations().getByName("implementation");
        for (Dependency d2 : impl.getAllDependencies()) {
            ModuleDependency module;
            Category category;
            if (!(d2 instanceof ModuleDependency) || (category = (Category)(module = (ModuleDependency)d2).getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE)) == null || !"enforced-platform".equals(category.getName()) && !"platform".equals(category.getName())) continue;
            boms.add(d2);
        }
        Set resolvedArtifacts = this.project.getConfigurations().getByName("runtimeClasspath").getResolvedConfiguration().getResolvedArtifacts();
        ArrayList<AppArtifactCoords> coords = new ArrayList<AppArtifactCoords>(boms.size() + resolvedArtifacts.size());
        boms.forEach(d -> coords.add(new AppArtifactCoords(d.getGroup(), d.getName(), null, "pom", d.getVersion())));
        resolvedArtifacts.forEach(a -> coords.add(new AppArtifactCoords(a.getModuleVersion().getId().getGroup(), a.getName(), a.getClassifier(), a.getExtension(), a.getModuleVersion().getId().getVersion())));
        return coords;
    }
}

