/*
 * Decompiled with CFR 0.152.
 */
package io.github.daggerok.utils;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionUtils
implements GroovyObject {
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private ExecutionUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static final String usage(String taskName) {
        return StringGroovyMethods.stripMargin((CharSequence)new GStringImpl(new Object[]{taskName, taskName}, new String[]{"       |Please, make sure you properly configured ", " task.\n       |Minimal required configuration is existed SoapUI test project file.\n       |Default path is: \"${projectDir}/soapui-test-project.xml\"\n       |\n       |", " {\n       |  projectFile = 'soapui-test-project.xml'\n       |}"}));
    }

    public static void validate(File file, String taskName, boolean failOnError) {
        if (file.exists() && file.canRead()) {
            return;
        }
        GStringImpl message = new GStringImpl(new Object[]{file, ExecutionUtils.usage(taskName)}, new String[]{"file ", " doesn't exists or not accessible.\n", ""});
        log.error(ShortTypeHandling.castToString((Object)message));
        if (failOnError) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)message));
        }
    }

    public static String today() {
        return DateFormat.getDateTimeInstance().format(new Date());
    }

    public static void tryWithLog(Closure closure) {
        block5: {
            try {
                closure.call();
            }
            catch (Exception e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    Exception exception = e;
                    log.error("continue execution with error: {}", (Object)(exception != null ? exception.getLocalizedMessage() : null), (Object)e);
                    v0 = null;
                    break block5;
                }
                v0 = null;
            }
        }
    }

    public static void tryWithLogMessage(String message, Closure closure) {
        block5: {
            try {
                closure.call();
            }
            catch (Exception e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    Exception exception = e;
                    log.error("continue execution, but: {}\n{}", new Object[]{message, exception != null ? exception.getLocalizedMessage() : null, e});
                    v0 = null;
                    break block5;
                }
                v0 = null;
            }
        }
    }

    public static void tryWithMessage(String message, Closure closure) {
        try {
            closure.call();
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            Exception exception = e;
            objectArray[0] = exception != null ? exception.getLocalizedMessage() : null;
            objectArray[1] = message;
            GStringImpl msg = new GStringImpl(objectArray, new String[]{"", "\n", ""});
            log.error("execution fails: {}", (Object)msg, (Object)e);
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)msg));
        }
    }

    public static void tryOrThrowIf(boolean failOnError, Closure closure) {
        try {
            closure.call();
        }
        catch (Exception e) {
            Exception exception = e;
            String message = exception != null ? exception.getLocalizedMessage() : null;
            log.error("execution error: {}", (Object)message, (Object)e);
            if (failOnError) {
                throw (Throwable)new GradleException(message);
            }
        }
    }

    public static void createExtFolder(Project project) {
        Reference project2 = new Reference((Object)project);
        Reference extDirName = new Reference((Object)"ext");
        File extDir = ((Project)project2.get()).file((Object)((String)extDirName.get()));
        if (extDir.exists()) {
            Object v0;
            if (extDir.isDirectory()) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)extDirName.get()}, new String[]{"", " is reserved name for SoapUI libraries folder."})));
                v0 = null;
            } else {
                v0 = null;
            }
            return;
        }
        public class _createExtFolder_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference extDirName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createExtFolder_closure1(Object _outerInstance, Object _thisObject, Reference project, Reference extDirName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.project = reference2 = project;
                this.extDirName = reference = extDirName;
            }

            public Object doCall(Object it) {
                return ((Project)this.project.get()).mkdir(this.extDirName.get());
            }

            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public String getExtDirName() {
                return ShortTypeHandling.castToString((Object)this.extDirName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createExtFolder_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ExecutionUtils.tryWithLog(new _createExtFolder_closure1(ExecutionUtils.class, ExecutionUtils.class, project2, extDirName));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExecutionUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"io.github.daggerok.utils.ExecutionUtils");
    }
}

