/*
 * Decompiled with CFR 0.152.
 */
package core.usecase;

import core.entity.BuildConfig;
import core.entity.Log;
import core.entity.Message;
import core.entity.MessageKt;
import core.usecase.GetSummaryUseCase;
import core.usecase.GetSummaryUseCaseKt;
import core.usecase.HtmlReportKt;
import core.usecase.PostStatsUseCase;
import core.usecase.PostStatusUseCase;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcore/usecase/HandleBuildFinishedUseCase;", "", "postStatusUseCase", "Lcore/usecase/PostStatusUseCase;", "postStatsUseCase", "Lcore/usecase/PostStatsUseCase;", "summaries", "", "Lcore/usecase/GetSummaryUseCase;", "config", "Lcore/entity/BuildConfig;", "messageQueue", "", "Lcore/entity/Message;", "(Lcore/usecase/PostStatusUseCase;Lcore/usecase/PostStatsUseCase;Ljava/util/List;Lcore/entity/BuildConfig;Ljava/util/List;)V", "invoke", "", "BuildChecks"})
public final class HandleBuildFinishedUseCase {
    @NotNull
    private final PostStatusUseCase postStatusUseCase;
    @NotNull
    private final PostStatsUseCase postStatsUseCase;
    @NotNull
    private final List<GetSummaryUseCase> summaries;
    @NotNull
    private final BuildConfig config;
    @NotNull
    private final List<Message> messageQueue;

    public HandleBuildFinishedUseCase(@NotNull PostStatusUseCase postStatusUseCase, @NotNull PostStatsUseCase postStatsUseCase, @NotNull List<? extends GetSummaryUseCase> summaries, @NotNull BuildConfig config, @NotNull List<Message> messageQueue) {
        Intrinsics.checkNotNullParameter((Object)postStatusUseCase, (String)"postStatusUseCase");
        Intrinsics.checkNotNullParameter((Object)postStatsUseCase, (String)"postStatsUseCase");
        Intrinsics.checkNotNullParameter(summaries, (String)"summaries");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(messageQueue, (String)"messageQueue");
        this.postStatusUseCase = postStatusUseCase;
        this.postStatsUseCase = postStatsUseCase;
        this.summaries = summaries;
        this.config = config;
        this.messageQueue = messageQueue;
    }

    public final void invoke() {
        Log log = this.config.getLog();
        if (log != null) {
            log.info(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " invoked");
        }
        if (this.config.isChecksActivated()) {
            GetSummaryUseCaseKt.postStatuses(this.summaries, this.postStatusUseCase);
            GetSummaryUseCaseKt.postStats(this.summaries, this.config, this.postStatsUseCase);
            HtmlReportKt.writeBuildReports$default(this.config, this.messageQueue, null, 2, null);
            MessageKt.printAll(this.messageQueue);
            GetSummaryUseCaseKt.throwIfUnsuccessful(this.summaries, this.config);
            GitsKt.pushArtifacts(this.config, this.messageQueue);
        }
    }
}

