/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.xsd.builder;

import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.bundling.Zip;

@CacheableTask
public class BuildXSDTask
extends Zip {
    private Callable<File> _destinationDir;
    private Object _inputDir;

    public BuildXSDTask() {
        Property archiveAppendixProperty = this.getArchiveAppendix();
        Property archiveExtensionProperty = this.getArchiveExtension();
        Property archiveVersionProperty = this.getArchiveVersion();
        archiveAppendixProperty.set((Object)"xbean");
        archiveExtensionProperty.set((Object)"jar");
        archiveVersionProperty.set((Object)"");
    }

    public DirectoryProperty getDestinationDirectory() {
        DirectoryProperty destinationDirectory = super.getDestinationDirectory();
        if (this._destinationDir != null) {
            destinationDirectory.set(GradleUtil.toFile((Project)this.getProject(), this._destinationDir));
        }
        return destinationDirectory;
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getInputDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._inputDir);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileCollection getInputFiles() {
        Project project = this.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", this.getInputDir());
        args.put("include", "**/*.*");
        return project.fileTree(args);
    }

    public void setInputDir(Object inputDir) {
        this._inputDir = inputDir;
    }

    protected void setDestinationDir(Callable<File> callable) {
        this._destinationDir = callable;
    }
}

