/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.service.builder;

import com.liferay.gradle.plugins.service.builder.BuildServiceTask;
import com.liferay.gradle.plugins.service.builder.internal.util.GradleUtil;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.OSGiUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.service.ServiceRegistry;

public class ServiceBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_SERVICE_TASK_NAME = "buildService";
    public static final String CONFIGURATION_NAME = "serviceBuilder";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaLibraryPlugin.class);
        Configuration serviceBuilderConfiguration = this.addConfigurationServiceBuilder(project);
        final BuildServiceTask buildServiceTask = this.addTaskBuildService(project);
        this.configureTasksBuildService(project, serviceBuilderConfiguration);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                ServiceBuilderPlugin.this.configureTaskBuildService(buildServiceTask);
            }
        });
    }

    protected Configuration addConfigurationServiceBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay Service Builder for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                ServiceBuilderPlugin.this.addDependenciesServiceBuilder(project);
            }
        });
        return configuration;
    }

    protected void addDependenciesServiceBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.service.builder", (String)"latest.release");
    }

    protected BuildServiceTask addTaskBuildService(final Project project) {
        final BuildServiceTask buildServiceTask = (BuildServiceTask)GradleUtil.addTask((Project)project, (String)BUILD_SERVICE_TASK_NAME, BuildServiceTask.class);
        buildServiceTask.setDescription("Runs Liferay Service Builder.");
        buildServiceTask.setGroup("build");
        buildServiceTask.setHbmFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = ServiceBuilderPlugin.this.getResourcesDir(project);
                String fileName = "META-INF/portlet-hbm.xml";
                if (buildServiceTask.isOsgiModule()) {
                    fileName = "META-INF/module-hbm.xml";
                }
                return new File(resourcesDir, fileName);
            }
        });
        buildServiceTask.setImplDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return ServiceBuilderPlugin.this.getJavaDir(project);
            }
        });
        buildServiceTask.setInputFile("service.xml");
        buildServiceTask.setModelHintsFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(ServiceBuilderPlugin.this.getResourcesDir(project), "META-INF/portlet-model-hints.xml");
            }
        });
        buildServiceTask.setPluginName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (buildServiceTask.isOsgiModule()) {
                    return "";
                }
                return project.getName();
            }
        });
        buildServiceTask.setPropsUtil(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (buildServiceTask.isOsgiModule()) {
                    String bundleSymbolicName = OSGiUtil.getBundleSymbolicName((Project)project);
                    return bundleSymbolicName + ".util.ServiceProps";
                }
                return "com.liferay.util.service.ServiceProps";
            }
        });
        buildServiceTask.setResourcesDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return ServiceBuilderPlugin.this.getResourcesDir(project);
            }
        });
        buildServiceTask.setSpringFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = ServiceBuilderPlugin.this.getResourcesDir(project);
                String fileName = "META-INF/portlet-spring.xml";
                if (buildServiceTask.isOsgiModule()) {
                    fileName = "META-INF/spring/module-spring.xml";
                }
                return new File(resourcesDir, fileName);
            }
        });
        buildServiceTask.setSqlDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(ServiceBuilderPlugin.this.getResourcesDir(project), "META-INF/sql");
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                ServiceBuilderPlugin.this.configureTaskBuildServiceForWarPlugin(buildServiceTask);
            }
        });
        return buildServiceTask;
    }

    protected void configureTaskBuildService(final BuildServiceTask buildServiceTask) {
        Project project = buildServiceTask.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withId("com.liferay.defaults.plugin", (Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                ServiceBuilderPlugin.this.configureTaskBuildServiceForLiferayDefaultsPlugin(buildServiceTask);
            }
        });
    }

    protected void configureTaskBuildServiceClasspath(BuildServiceTask buildServiceTask, Configuration serviceBuilderConfiguration) {
        buildServiceTask.setClasspath((FileCollection)serviceBuilderConfiguration);
    }

    protected void configureTaskBuildServiceForLiferayDefaultsPlugin(BuildServiceTask buildServiceTask) {
        File apiDir = buildServiceTask.getApiDir();
        if (apiDir == null) {
            return;
        }
        Project project = buildServiceTask.getProject();
        File apiProjectDir = GradleUtil.getRootDir((File)project.file((Object)apiDir), (String)"bnd.bnd");
        if (apiProjectDir == null) {
            return;
        }
        Project rootProject = project.getRootProject();
        String relativePath = FileUtil.relativize((File)apiProjectDir, (File)rootProject.getProjectDir());
        relativePath = relativePath.replace(File.separatorChar, '/');
        String apiProjectPath = ':' + relativePath.replace('/', ':');
        Project apiProject = rootProject.findProject(apiProjectPath);
        if (apiProject == null) {
            String apiProjectName = apiProjectDir.getName();
            apiProject = GradleUtil.findProject(rootProject, apiProjectName);
        }
        if (apiProject == null) {
            return;
        }
        GradleInternal gradleInternal = (GradleInternal)project.getGradle();
        ServiceRegistry serviceRegistry = gradleInternal.getServices();
        ProjectConfigurer projectConfigurer = (ProjectConfigurer)serviceRegistry.get(ProjectConfigurer.class);
        projectConfigurer.configure((ProjectInternal)apiProject);
        TaskContainer taskContainer = apiProject.getTasks();
        Task task = (Task)taskContainer.findByName("baseline");
        if (task != null) {
            task.setProperty("ignoreFailures", (Object)Boolean.TRUE);
            buildServiceTask.finalizedBy(new Object[]{task});
        }
    }

    protected void configureTaskBuildServiceForWarPlugin(final BuildServiceTask buildServiceTask) {
        buildServiceTask.setApiDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(ServiceBuilderPlugin.this.getWebAppDir(buildServiceTask.getProject()), "WEB-INF/service");
            }
        });
        buildServiceTask.setInputFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(ServiceBuilderPlugin.this.getWebAppDir(buildServiceTask.getProject()), "WEB-INF/service.xml");
            }
        });
        buildServiceTask.setSqlDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(ServiceBuilderPlugin.this.getWebAppDir(buildServiceTask.getProject()), "WEB-INF/sql");
            }
        });
    }

    protected void configureTasksBuildService(Project project, final Configuration serviceBuilderConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildServiceTask.class, (Action)new Action<BuildServiceTask>(){

            public void execute(BuildServiceTask buildServiceTask) {
                ServiceBuilderPlugin.this.configureTaskBuildServiceClasspath(buildServiceTask, serviceBuilderConfiguration);
            }
        });
    }

    protected File getJavaDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getJava());
    }

    protected File getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getResources());
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    protected File getWebAppDir(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        return warPluginConvention.getWebAppDir();
    }
}

