/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.task;

import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.task.ExecutePackageManagerTask;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;

@CacheableTask
public class DownloadNodeModuleTask
extends ExecutePackageManagerTask {
    private Object _moduleName;
    private Object _moduleVersion;

    public DownloadNodeModuleTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                try {
                    File packageJSONFile = new File(DownloadNodeModuleTask.this.getModuleDir(), "package.json");
                    if (!packageJSONFile.exists()) {
                        return true;
                    }
                    String packageJSON = new String(Files.readAllBytes(packageJSONFile.toPath()));
                    String version = DownloadNodeModuleTask.this.getModuleVersion();
                    return !packageJSON.contains("\"version\": \"" + version + "\"");
                }
                catch (Exception exception) {
                    throw new GradleException(exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    @OutputDirectory
    public File getModuleDir() {
        return new File(this.getNodeModulesDir(), this.getModuleName());
    }

    @Input
    public String getModuleName() {
        return GradleUtil.toString((Object)this._moduleName);
    }

    @Input
    public String getModuleVersion() {
        return GradleUtil.toString((Object)this._moduleVersion);
    }

    public void setModuleName(Object moduleName) {
        this._moduleName = moduleName;
    }

    public void setModuleVersion(Object moduleVersion) {
        this._moduleVersion = moduleVersion;
    }

    @Override
    @Internal
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        if (this.isUseNpm()) {
            completeArgs.add("install");
        } else {
            completeArgs.add("add");
        }
        completeArgs.add(this.getModuleName() + "@" + this.getModuleVersion());
        return completeArgs;
    }
}

