/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node;

import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.internal.util.StringUtil;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecutePackageManagerTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.NpmShrinkwrapTask;
import com.liferay.gradle.plugins.node.tasks.PackageRunBuildTask;
import com.liferay.gradle.plugins.node.tasks.PackageRunTask;
import com.liferay.gradle.plugins.node.tasks.PackageRunTestTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.util.OSGiUtil;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.util.VersionNumber;

public class NodePlugin
implements Plugin<Project> {
    public static final String CLEAN_NPM_TASK_NAME = "cleanNPM";
    public static final String DOWNLOAD_NODE_TASK_NAME = "downloadNode";
    public static final String EXTENSION_NAME = "node";
    public static final String NPM_INSTALL_TASK_NAME = "npmInstall";
    public static final String NPM_PACKAGE_LOCK_TASK_NAME = "npmPackageLock";
    public static final String NPM_SHRINKWRAP_TASK_NAME = "npmShrinkwrap";
    public static final String PACKAGE_RUN_BUILD_TASK_NAME = "packageRunBuild";
    public static final String PACKAGE_RUN_TEST_TASK_NAME = "packageRunTest";
    private static final String _PACKAGE_RUN_TASK_NAME_PREFIX = "packageRun";
    private static final VersionNumber _liferayNpmScripts12VersionNumber = VersionNumber.version((int)12);
    private static final VersionNumber _node8VersionNumber = VersionNumber.version((int)8);
    private static final VersionNumber _npm5VersionNumber = VersionNumber.version((int)5);

    public void apply(Project project) {
        final NodeExtension nodeExtension = (NodeExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, NodeExtension.class);
        this._configureExtensionNode(project, nodeExtension);
        Delete cleanNpmTask = this._addTaskCleanNpm(project, nodeExtension);
        final DownloadNodeTask downloadNodeTask = this._addTaskDownloadNode(project, nodeExtension);
        NpmInstallTask npmInstallTask = this._addTaskNpmInstall(project, cleanNpmTask);
        Map packageJsonMap = null;
        File packageJsonFile = npmInstallTask.getPackageJsonFile();
        if (packageJsonFile.exists()) {
            JsonSlurper jsonSlurper = new JsonSlurper();
            packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
        }
        this._addTaskNpmPackageLock(project, cleanNpmTask, npmInstallTask);
        this._addTaskNpmShrinkwrap(project, cleanNpmTask, npmInstallTask);
        this._addTasksPackageRun(npmInstallTask, packageJsonMap, nodeExtension);
        this._configureTasksDownloadNodeModule(project, npmInstallTask, packageJsonMap);
        this._configureTasksExecuteNode(project, nodeExtension, GradleUtil.isRunningInsideDaemon());
        this._configureTasksExecutePackageManager(project, nodeExtension);
        this._configureTasksPublishNodeModule(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                NodePlugin.this._configureTaskDownloadNodeGlobal(downloadNodeTask, nodeExtension);
                NodePlugin.this._configureTasksExecutePackageManagerArgs(project, nodeExtension);
                NodePlugin.this._configureTasksNpmInstall(project, nodeExtension);
            }
        });
    }

    private Delete _addTaskCleanNpm(final Project project, final NodeExtension nodeExtension) {
        Delete delete = (Delete)GradleUtil.addTask((Project)project, (String)CLEAN_NPM_TASK_NAME, Delete.class);
        delete.delete(new Object[]{"node_modules", "npm-shrinkwrap.json"});
        delete.setDescription("Deletes NPM files from this project.");
        delete.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                File file = project.file((Object)"package-lock.json");
                if (!file.exists()) {
                    return;
                }
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException ioException) {
                    throw new UncheckedIOException((Throwable)ioException);
                }
                nodeExtension.setUseNpm(true);
            }
        });
        return delete;
    }

    private DownloadNodeTask _addTaskDownloadNode(Project project, NodeExtension nodeExtension) {
        return this._addTaskDownloadNode(project, DOWNLOAD_NODE_TASK_NAME, nodeExtension);
    }

    private DownloadNodeTask _addTaskDownloadNode(Project project, String taskName, final NodeExtension nodeExtension) {
        DownloadNodeTask downloadNodeTask = (DownloadNodeTask)GradleUtil.addTask((Project)project, (String)taskName, DownloadNodeTask.class);
        downloadNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return nodeExtension.getNodeDir();
            }
        });
        downloadNodeTask.setNodeUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNodeUrl();
            }
        });
        downloadNodeTask.setNpmUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getNpmUrl();
            }
        });
        downloadNodeTask.setYarnUrl(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return nodeExtension.getYarnUrl();
            }
        });
        downloadNodeTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return nodeExtension.isDownload();
            }
        });
        downloadNodeTask.setDescription("Downloads Node.js in the project build directory.");
        return downloadNodeTask;
    }

    private NpmInstallTask _addTaskNpmInstall(Project project, Delete cleanNpmTask) {
        NpmInstallTask npmInstallTask = (NpmInstallTask)GradleUtil.addTask((Project)project, (String)NPM_INSTALL_TASK_NAME, NpmInstallTask.class);
        npmInstallTask.mustRunAfter(new Object[]{cleanNpmTask});
        npmInstallTask.setDescription("Installs Node packages from package.json.");
        npmInstallTask.setNpmInstallRetries(2);
        return npmInstallTask;
    }

    private Task _addTaskNpmPackageLock(Project project, Delete cleanNpmTask, NpmInstallTask npmInstallTask) {
        Task task = project.task(NPM_PACKAGE_LOCK_TASK_NAME);
        task.dependsOn(new Object[]{cleanNpmTask, npmInstallTask});
        task.setDescription("Deletes NPM files and installs Node packages from package.json.");
        return task;
    }

    private NpmShrinkwrapTask _addTaskNpmShrinkwrap(Project project, Delete cleanNpmTask, NpmInstallTask npmInstallTask) {
        NpmShrinkwrapTask npmShrinkwrapTask = (NpmShrinkwrapTask)GradleUtil.addTask((Project)project, (String)NPM_SHRINKWRAP_TASK_NAME, NpmShrinkwrapTask.class);
        npmShrinkwrapTask.dependsOn(new Object[]{cleanNpmTask, npmInstallTask});
        npmShrinkwrapTask.setDescription("Locks down the versions of a package's dependencies in order to control which versions of each dependency will be used.");
        return npmShrinkwrapTask;
    }

    private PackageRunTask _addTaskPackageRun(String scriptName, NpmInstallTask npmInstallTask) {
        Project project = npmInstallTask.getProject();
        String suffix = StringUtil.camelCase(scriptName, true);
        String taskName = _PACKAGE_RUN_TASK_NAME_PREFIX + suffix;
        PackageRunTask packageRunTask = (PackageRunTask)GradleUtil.addTask((Project)project, (String)taskName, PackageRunTask.class);
        packageRunTask.dependsOn(new Object[]{npmInstallTask});
        packageRunTask.setDescription("Runs the \"" + scriptName + "\" package.json script.");
        packageRunTask.setGroup("build");
        packageRunTask.setScriptName(scriptName);
        return packageRunTask;
    }

    private PackageRunBuildTask _addTaskPackageRunBuild(NpmInstallTask npmInstallTask, NodeExtension nodeExtension) {
        final Project project = npmInstallTask.getProject();
        final PackageRunBuildTask packageRunBuildTask = (PackageRunBuildTask)GradleUtil.addTask((Project)project, (String)PACKAGE_RUN_BUILD_TASK_NAME, PackageRunBuildTask.class);
        packageRunBuildTask.dependsOn(new Object[]{npmInstallTask});
        packageRunBuildTask.setDescription("Runs the \"build\" package.json script.");
        packageRunBuildTask.setGroup("build");
        packageRunBuildTask.setYarnWorkingDir(this._getYarnWorkingDir(project, nodeExtension));
        packageRunBuildTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                PackageRunBuildTask packageRunBuildTask = (PackageRunBuildTask)task;
                String result = packageRunBuildTask.getResult();
                if (result.contains("errors during Soy compilation")) {
                    project.delete(new Object[]{packageRunBuildTask.getDestinationDir()});
                    throw new GradleException("Soy compile error");
                }
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                NodePlugin.this._configureTaskPackageRunBuildForJavaPlugin(packageRunBuildTask);
            }
        });
        return packageRunBuildTask;
    }

    private PackageRunTestTask _addTaskPackageRunTest(NpmInstallTask npmInstallTask) {
        Project project = npmInstallTask.getProject();
        final PackageRunTestTask packageRunTestTask = (PackageRunTestTask)GradleUtil.addTask((Project)project, (String)PACKAGE_RUN_TEST_TASK_NAME, PackageRunTestTask.class);
        packageRunTestTask.dependsOn(new Object[]{npmInstallTask});
        packageRunTestTask.setDescription("Runs the \"build\" package.json script.");
        packageRunTestTask.setGroup("build");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(LifecycleBasePlugin.class, (Action)new Action<LifecycleBasePlugin>(){

            public void execute(LifecycleBasePlugin lifecycleBasePlugin) {
                NodePlugin.this._configureTaskPackageRunTestForLifecycleBasePlugin(packageRunTestTask);
            }
        });
        return packageRunTestTask;
    }

    private void _addTasksPackageRun(NpmInstallTask npmInstallTask, Map<String, Object> packageJsonMap, NodeExtension nodeExtension) {
        if (packageJsonMap == null) {
            return;
        }
        Map scriptsJsonMap = (Map)packageJsonMap.get("scripts");
        if (scriptsJsonMap != null) {
            for (String scriptName : scriptsJsonMap.keySet()) {
                if (Objects.equals(scriptName, "build")) {
                    this._addTaskPackageRunBuild(npmInstallTask, nodeExtension);
                    continue;
                }
                if (Objects.equals(scriptName, "test")) {
                    this._addTaskPackageRunTest(npmInstallTask);
                    continue;
                }
                this._addTaskPackageRun(scriptName, npmInstallTask);
            }
        }
    }

    private void _configureExtensionNode(Project project, final NodeExtension nodeExtension) {
        if (FileUtil.exists((Project)project, (String)"package-lock.json")) {
            return;
        }
        Project rootProject = project.getRootProject();
        PluginContainer rootPluginContainer = rootProject.getPlugins();
        rootPluginContainer.withId("com.liferay.yarn", (Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                nodeExtension.setUseNpm(false);
            }
        });
    }

    private void _configureTaskDownloadNodeGlobal(DownloadNodeTask downloadNodeTask, NodeExtension nodeExtension) {
        Project project = downloadNodeTask.getProject();
        if (!nodeExtension.isDownload() || !nodeExtension.isGlobal() || project.getParent() == null) {
            return;
        }
        Project rootProject = project.getRootProject();
        DownloadNodeTask rootDownloadNodeTask = null;
        TaskContainer taskContainer = rootProject.getTasks();
        TaskCollection rootDownloadNodeTasks = taskContainer.withType(DownloadNodeTask.class);
        File nodeDir = downloadNodeTask.getNodeDir();
        String nodeUrl = downloadNodeTask.getNodeUrl();
        for (DownloadNodeTask curRootDownloadNodeTask : rootDownloadNodeTasks) {
            if (!nodeDir.equals(curRootDownloadNodeTask.getNodeDir()) || !nodeUrl.equals(curRootDownloadNodeTask.getNodeUrl())) continue;
            rootDownloadNodeTask = curRootDownloadNodeTask;
            break;
        }
        if (rootDownloadNodeTask == null) {
            String taskName = DOWNLOAD_NODE_TASK_NAME;
            if (!rootDownloadNodeTasks.isEmpty()) {
                taskName = taskName + rootDownloadNodeTasks.size();
            }
            rootDownloadNodeTask = this._addTaskDownloadNode(rootProject, taskName, nodeExtension);
        }
        downloadNodeTask.setActions(Collections.emptyList());
        downloadNodeTask.dependsOn(new Object[]{rootDownloadNodeTask});
    }

    private void _configureTaskDownloadNodeModule(DownloadNodeModuleTask downloadNodeModuleTask, final NpmInstallTask npmInstallTask, final Map<String, Object> packageJsonMap) {
        downloadNodeModuleTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                DownloadNodeModuleTask downloadNodeModuleTask = (DownloadNodeModuleTask)task;
                File moduleDir = downloadNodeModuleTask.getModuleDir();
                File moduleParentDir = moduleDir.getParentFile();
                if (!moduleParentDir.equals(npmInstallTask.getNodeModulesDir())) {
                    return true;
                }
                if (packageJsonMap == null) {
                    return true;
                }
                String moduleName = downloadNodeModuleTask.getModuleName();
                Map dependenciesJsonMap = (Map)packageJsonMap.get("dependencies");
                if (dependenciesJsonMap != null && dependenciesJsonMap.containsKey(moduleName)) {
                    return false;
                }
                dependenciesJsonMap = (Map)packageJsonMap.get("devDependencies");
                return dependenciesJsonMap == null || !dependenciesJsonMap.containsKey(moduleName);
            }
        });
    }

    private void _configureTaskExecuteNode(ExecuteNodeTask executeNodeTask, final NodeExtension nodeExtension, boolean useGradleExec) {
        executeNodeTask.setNodeDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (nodeExtension.isDownload()) {
                    return nodeExtension.getNodeDir();
                }
                return null;
            }
        });
        executeNodeTask.setUseGradleExec(useGradleExec);
    }

    private void _configureTaskExecutePackageManager(final ExecutePackageManagerTask executePackageManagerTask, final NodeExtension nodeExtension) {
        final Callable<Boolean> useGlobalConcurrentCacheCallable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                int value1 = _node8VersionNumber.compareTo(VersionNumber.parse((String)nodeExtension.getNodeVersion()));
                int value2 = _npm5VersionNumber.compareTo(VersionNumber.parse((String)nodeExtension.getNpmVersion()));
                if (value1 <= 0 || value2 <= 0) {
                    return true;
                }
                return false;
            }
        };
        executePackageManagerTask.setCacheConcurrent(useGlobalConcurrentCacheCallable);
        executePackageManagerTask.setCacheDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (((Boolean)useGlobalConcurrentCacheCallable.call()).booleanValue()) {
                    return null;
                }
                File nodeDir = executePackageManagerTask.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                return new File(nodeDir, ".cache");
            }
        });
        final Project project = executePackageManagerTask.getProject();
        executePackageManagerTask.setNodeModulesDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (nodeExtension.isUseNpm()) {
                    return project.file((Object)"node_modules");
                }
                Project rootProject = project.getRootProject();
                return rootProject.file((Object)"node_modules");
            }
        });
        executePackageManagerTask.setScriptFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return nodeExtension.getScriptFile();
            }
        });
        executePackageManagerTask.setUseNpm(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return nodeExtension.isUseNpm();
            }
        });
    }

    private void _configureTaskExecutePackageManagerArgs(ExecutePackageManagerTask executePackageManagerTask, NodeExtension nodeExtension) {
        if (nodeExtension.isUseNpm()) {
            executePackageManagerTask.args(nodeExtension.getNpmArgs());
        }
    }

    private void _configureTaskNpmInstall(NpmInstallTask npmInstallTask, NodeExtension nodeExtension) {
        npmInstallTask.setNodeVersion(nodeExtension.getNodeVersion());
        npmInstallTask.setNpmVersion(nodeExtension.getNpmVersion());
        if (!npmInstallTask.isUseNpm()) {
            Project curProject = npmInstallTask.getProject();
            do {
                TaskProvider yarnInstallTaskProvider;
                if ((yarnInstallTaskProvider = GradleUtil.fetchTaskProvider((Project)curProject, (String)"yarnInstall")) == null) continue;
                npmInstallTask.finalizedBy(new Object[]{yarnInstallTaskProvider});
            } while ((curProject = curProject.getParent()) != null);
        }
    }

    private void _configureTaskPackageRunBuildForJavaPlugin(final PackageRunBuildTask packageRunBuildTask) {
        final Project project = packageRunBuildTask.getProject();
        packageRunBuildTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
                project.delete(new Object[]{jar.getArchivePath()});
            }
        });
        Copy processResourcesCopy = (Copy)GradleUtil.getTask((Project)project, (String)"processResources");
        File yarnWorkingDir = packageRunBuildTask.getYarnWorkingDir();
        if (yarnWorkingDir != null && this._hasLiferayNpmScripts12Dependency(project, yarnWorkingDir)) {
            final File destinationDir = new File(project.getBuildDir(), "node/packageRunBuild/resources");
            packageRunBuildTask.setDestinationDir(new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return destinationDir;
                }
            });
            final File sourceDir = project.file((Object)"src/main/resources/META-INF/resources");
            packageRunBuildTask.setSourceDir(new Callable<File>(){

                @Override
                public File call() throws Exception {
                    if (!sourceDir.exists()) {
                        return null;
                    }
                    return sourceDir;
                }
            });
            packageRunBuildTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    Action<CopySpec> action = new Action<CopySpec>(){

                        public void execute(CopySpec copySpec) {
                            copySpec.from(new Object[]{sourceDir});
                            copySpec.into((Object)destinationDir);
                        }
                    };
                    project.copy((Action)action);
                }
            });
            String incrementalCacheEnabled = GradleUtil.getTaskPrefixedProperty((Task)packageRunBuildTask, (String)"incremental.cache.enabled");
            if (Validator.isNull((String)incrementalCacheEnabled) || Boolean.parseBoolean(incrementalCacheEnabled)) {
                TaskOutputsInternal taskOutputs = packageRunBuildTask.getOutputs();
                taskOutputs.dir((Object)packageRunBuildTask.getDestinationDir());
            }
            processResourcesCopy.dependsOn(new Object[]{packageRunBuildTask});
            processResourcesCopy.from((Object)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return packageRunBuildTask.getDestinationDir();
                }
            }, (Closure)new Closure<Void>((Object)project){

                public void doCall(CopySpec copySpec) {
                    copySpec.into((Object)"META-INF/resources");
                }
            });
        } else {
            packageRunBuildTask.mustRunAfter(new Object[]{processResourcesCopy});
            Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
            classesTask.dependsOn(new Object[]{packageRunBuildTask});
        }
    }

    private void _configureTaskPackageRunTestForLifecycleBasePlugin(PackageRunTestTask packageRunTestTask) {
        Task checkTask = GradleUtil.getTask((Project)packageRunTestTask.getProject(), (String)"check");
        checkTask.dependsOn(new Object[]{packageRunTestTask});
    }

    private void _configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.setModuleDescription(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getDescription();
            }
        });
        publishNodeModuleTask.setModuleName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String moduleName = OSGiUtil.getBundleSymbolicName((Project)project);
                int pos = moduleName.indexOf(46);
                if (pos != -1) {
                    moduleName = moduleName.substring(pos + 1);
                    moduleName = moduleName.replace('.', '-');
                }
                return moduleName;
            }
        });
        publishNodeModuleTask.setModuleVersion(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
    }

    private void _configureTasksDownloadNodeModule(Project project, final NpmInstallTask npmInstallTask, final Map<String, Object> packageJsonMap) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DownloadNodeModuleTask.class, (Action)new Action<DownloadNodeModuleTask>(){

            public void execute(DownloadNodeModuleTask downloadNodeModuleTask) {
                NodePlugin.this._configureTaskDownloadNodeModule(downloadNodeModuleTask, npmInstallTask, packageJsonMap);
            }
        });
    }

    private void _configureTasksExecuteNode(Project project, final NodeExtension nodeExtension, final boolean useGradleExec) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNodeTask.class, (Action)new Action<ExecuteNodeTask>(){

            public void execute(ExecuteNodeTask executeNodeTask) {
                NodePlugin.this._configureTaskExecuteNode(executeNodeTask, nodeExtension, useGradleExec);
            }
        });
    }

    private void _configureTasksExecutePackageManager(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecutePackageManagerTask.class, (Action)new Action<ExecutePackageManagerTask>(){

            public void execute(ExecutePackageManagerTask executePackageManagerTask) {
                NodePlugin.this._configureTaskExecutePackageManager(executePackageManagerTask, nodeExtension);
            }
        });
    }

    private void _configureTasksExecutePackageManagerArgs(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecutePackageManagerTask.class, (Action)new Action<ExecutePackageManagerTask>(){

            public void execute(ExecutePackageManagerTask executePackageManagerTask) {
                NodePlugin.this._configureTaskExecutePackageManagerArgs(executePackageManagerTask, nodeExtension);
            }
        });
    }

    private void _configureTasksNpmInstall(Project project, final NodeExtension nodeExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                NodePlugin.this._configureTaskNpmInstall(npmInstallTask, nodeExtension);
            }
        });
    }

    private void _configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodePlugin.this._configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }

    private File _getYarnWorkingDir(Project project, NodeExtension nodeExtension) {
        if (nodeExtension.isUseNpm()) {
            return null;
        }
        File projectDir = project.getProjectDir();
        File dir = projectDir.getParentFile();
        do {
            File packageJsonFile;
            if (!this._hasYarnPackage(projectDir, packageJsonFile = new File(dir, "package.json"))) continue;
            return dir;
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }

    private boolean _hasLiferayNpmScripts12Dependency(File packageJSONFile) {
        if (packageJSONFile == null || !packageJSONFile.exists()) {
            return false;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map packageJSONMap = (Map)jsonSlurper.parse(packageJSONFile);
        Map devDependencies = (Map)packageJSONMap.get("devDependencies");
        if (devDependencies == null) {
            return false;
        }
        String dependencyName = null;
        if (devDependencies.containsKey("@liferay/npm-scripts")) {
            dependencyName = "@liferay/npm-scripts";
        } else if (devDependencies.containsKey("liferay-npm-scripts")) {
            dependencyName = "liferay-npm-scripts";
        } else {
            return false;
        }
        VersionNumber versionNumber = VersionNumber.parse((String)((String)devDependencies.get(dependencyName)));
        int majorVersion = versionNumber.getMajor();
        return majorVersion >= _liferayNpmScripts12VersionNumber.getMajor();
    }

    private boolean _hasLiferayNpmScripts12Dependency(Project project, File yarnWorkingDir) {
        File packageJSONFile = project.file((Object)"package.json");
        if (this._hasLiferayNpmScripts12Dependency(packageJSONFile)) {
            return true;
        }
        packageJSONFile = new File(yarnWorkingDir, "package.json");
        return this._hasLiferayNpmScripts12Dependency(packageJSONFile);
    }

    private boolean _hasYarnPackage(File projectDir, File packageJsonFile) {
        if (!packageJsonFile.exists()) {
            return false;
        }
        File dir = packageJsonFile.getParentFile();
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map map = (Map)jsonSlurper.parse(packageJsonFile);
        if ((map = (Map)map.get("workspaces")) == null) {
            return false;
        }
        List packages = (List)map.get("packages");
        if (packages == null) {
            return false;
        }
        String absolutePath = dir.getAbsolutePath();
        if (File.separatorChar == '\\') {
            absolutePath = absolutePath.replace('\\', '/');
        }
        Path dirPath = dir.toPath();
        FileSystem fileSystem = dirPath.getFileSystem();
        for (String pattern : packages) {
            String s = "glob:" + absolutePath + '/' + pattern;
            PathMatcher pathMatcher = fileSystem.getPathMatcher(s);
            if (!pathMatcher.matches(projectDir.toPath())) continue;
            return true;
        }
        return false;
    }
}

