/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;

public class NpmInstallTask
extends ExecuteNpmTask {
    private static final String _NODE_MODULES_BIN_DIR_NAME = ".bin";
    private static final DirectoryStream.Filter<Path> _directoryStreamFilter = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path path) throws IOException {
            return Files.isDirectory(path, new LinkOption[0]);
        }
    };
    private Object _nodeModulesCacheDir;
    private boolean _nodeModulesCacheNativeSync = true;
    private Object _nodeModulesDigestFile;
    private Object _removeShrinkwrappedUrls = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            if (Validator.isNotNull((String)NpmInstallTask.this.getRegistry())) {
                return true;
            }
            return false;
        }
    };
    private Object _useNpmCI;

    public NpmInstallTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                NpmInstallTask npmInstallTask = (NpmInstallTask)task;
                File packageJsonFile = npmInstallTask.getPackageJsonFile();
                if (!packageJsonFile.exists()) {
                    return false;
                }
                JsonSlurper jsonSlurper = new JsonSlurper();
                Map packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
                return packageJsonMap.containsKey("dependencies") || packageJsonMap.containsKey("devDependencies");
            }
        });
    }

    @Override
    public void executeNode() throws Exception {
        this.executeNpmInstall(false);
    }

    public File getNodeModulesCacheDir() {
        return GradleUtil.toFile(this.getProject(), this._nodeModulesCacheDir);
    }

    public File getNodeModulesDigestFile() {
        return GradleUtil.toFile(this.getProject(), this._nodeModulesDigestFile);
    }

    public File getNodeModulesDir() {
        Project project = this.getProject();
        return project.file((Object)"node_modules");
    }

    public File getPackageJsonFile() {
        Project project = this.getProject();
        return project.file((Object)"package.json");
    }

    public File getPackageLockJsonFile() {
        return this._getExistentFile("package-lock.json");
    }

    public File getShrinkwrapJsonFile() {
        return this._getExistentFile("npm-shrinkwrap.json");
    }

    public boolean isNodeModulesCacheNativeSync() {
        return this._nodeModulesCacheNativeSync;
    }

    public boolean isRemoveShrinkwrappedUrls() {
        return GradleUtil.toBoolean(this._removeShrinkwrappedUrls);
    }

    public boolean isUseNpmCI() {
        return GradleUtil.toBoolean(this._useNpmCI);
    }

    public void setNodeModulesCacheDir(Object nodeModulesCacheDir) {
        this._nodeModulesCacheDir = nodeModulesCacheDir;
    }

    public void setNodeModulesCacheNativeSync(boolean nodeModulesCacheNativeSync) {
        this._nodeModulesCacheNativeSync = nodeModulesCacheNativeSync;
    }

    public void setNodeModulesDigestFile(Object nodeModulesDigestFile) {
        this._nodeModulesDigestFile = nodeModulesDigestFile;
    }

    public void setRemoveShrinkwrappedUrls(Object removeShrinkwrappedUrls) {
        this._removeShrinkwrappedUrls = removeShrinkwrappedUrls;
    }

    public void setUseNpmCI(Object useNpmCI) {
        this._useNpmCI = useNpmCI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeNpmInstall(boolean reset) throws Exception {
        Logger logger = this.getLogger();
        Path shrinkwrapJsonBackupPath = null;
        Path shrinkwrapJsonPath = null;
        File shrinkwrapJsonFile = this.getShrinkwrapJsonFile();
        if (this.isRemoveShrinkwrappedUrls() && shrinkwrapJsonFile != null) {
            shrinkwrapJsonPath = shrinkwrapJsonFile.toPath();
            shrinkwrapJsonBackupPath = Paths.get(shrinkwrapJsonPath.toString() + ".backup", new String[0]);
            Files.copy(shrinkwrapJsonPath, shrinkwrapJsonBackupPath, StandardCopyOption.REPLACE_EXISTING);
            this._removeShrinkwrappedUrls();
        }
        try {
            if (this._isCacheEnabled()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Cache for {} is enabled", (Object)this);
                }
                NpmInstallTask._npmInstallCached(this, reset);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("Cache for {} is disabled", (Object)this);
                }
                if (this._isCheckDigest() && !this.isUseNpmCI()) {
                    this._npmInstallCheckDigest(reset);
                } else {
                    this._npmInstall(reset);
                }
            }
            if (shrinkwrapJsonBackupPath == null) return;
        }
        catch (Throwable throwable) {
            if (shrinkwrapJsonBackupPath == null) throw throwable;
            Files.move(shrinkwrapJsonBackupPath, shrinkwrapJsonPath, StandardCopyOption.REPLACE_EXISTING);
            throw throwable;
        }
        Files.move(shrinkwrapJsonBackupPath, shrinkwrapJsonPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        if (this.isUseNpmCI()) {
            completeArgs.add("ci");
        } else {
            completeArgs.add("install");
        }
        return completeArgs;
    }

    private static void _createBinDirLinks(Logger logger, File nodeModulesDir) throws IOException {
        JsonSlurper jsonSlurper = new JsonSlurper();
        Path nodeModulesDirPath = nodeModulesDir.toPath();
        Path nodeModulesBinDirPath = nodeModulesDirPath.resolve(_NODE_MODULES_BIN_DIR_NAME);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(nodeModulesDirPath, _directoryStreamFilter);){
            for (Path dirPath : directoryStream) {
                Map binJsonMap;
                Map packageJsonMap;
                Object binObject;
                Path packageJsonPath = dirPath.resolve("package.json");
                if (Files.notExists(packageJsonPath, new LinkOption[0]) || !((binObject = (packageJsonMap = (Map)jsonSlurper.parse(packageJsonPath.toFile())).get("bin")) instanceof Map) || (binJsonMap = (Map)binObject).isEmpty()) continue;
                Files.createDirectories(nodeModulesBinDirPath, new FileAttribute[0]);
                for (Map.Entry entry : binJsonMap.entrySet()) {
                    String linkFileName = (String)entry.getKey();
                    String linkTargetFileName = (String)entry.getValue();
                    Path linkPath = nodeModulesBinDirPath.resolve(linkFileName);
                    Path linkTargetPath = dirPath.resolve(linkTargetFileName);
                    Files.deleteIfExists(linkPath);
                    Files.createSymbolicLink(linkPath, linkTargetPath, new FileAttribute[0]);
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("Created binary symbolic link {} which targets {}", (Object)linkPath, (Object)linkTargetPath);
                }
            }
        }
    }

    private static String _getNodeModulesCacheDigest(NpmInstallTask npmInstallTask) {
        Logger logger = npmInstallTask.getLogger();
        JsonSlurper jsonSlurper = new JsonSlurper();
        File jsonFile = npmInstallTask.getPackageLockJsonFile();
        if (jsonFile == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Unable to find package-lock.json for {}, using npm-shrinkwrap.json instead", (Object)npmInstallTask.getProject());
            }
            jsonFile = npmInstallTask.getShrinkwrapJsonFile();
        }
        if (jsonFile == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to find npm-shrinkwrap.json for {}, using package.json instead", (Object)npmInstallTask.getProject());
            }
            jsonFile = npmInstallTask.getPackageJsonFile();
        }
        Map map = (Map)jsonSlurper.parse(jsonFile);
        map.remove("name");
        map.remove("version");
        return String.valueOf(map.hashCode());
    }

    private static synchronized void _npmInstallCached(NpmInstallTask npmInstallTask, boolean reset) throws Exception {
        Logger logger = npmInstallTask.getLogger();
        Project project = npmInstallTask.getProject();
        String digest = NpmInstallTask._getNodeModulesCacheDigest(npmInstallTask);
        File nodeModulesCacheDir = new File(npmInstallTask.getNodeModulesCacheDir(), digest);
        File nodeModulesDir = npmInstallTask.getNodeModulesDir();
        boolean nativeSync = npmInstallTask.isNodeModulesCacheNativeSync();
        if (reset) {
            project.delete(new Object[]{nodeModulesCacheDir});
        }
        if (nodeModulesCacheDir.exists()) {
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("Restoring node_modules of {} from {}", new Object[]{project, nodeModulesCacheDir});
            }
            FileUtil.syncDir(project, nodeModulesCacheDir, nodeModulesDir, nativeSync);
            NpmInstallTask._removeBinDirLinks(logger, nodeModulesDir);
        } else {
            npmInstallTask._npmInstall(reset);
            NpmInstallTask._removeBinDirLinks(logger, nodeModulesDir);
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("Caching node_modules of {} in {}", new Object[]{project, nodeModulesCacheDir});
            }
            FileUtil.syncDir(project, nodeModulesDir, nodeModulesCacheDir, nativeSync);
        }
        if (!OSDetector.isWindows()) {
            NpmInstallTask._createBinDirLinks(logger, nodeModulesDir);
        }
    }

    private static void _removeBinDirLinks(final Logger logger, File nodeModulesDir) throws IOException {
        Files.walkFileTree(nodeModulesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                String dirName = String.valueOf(dirPath.getFileName());
                if (dirName.equals(NpmInstallTask._NODE_MODULES_BIN_DIR_NAME)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Removing binary symbolic links from {}", (Object)dirPath);
                    }
                    FileUtil.deleteSymbolicLinks(dirPath);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private File _getExistentFile(String fileName) {
        Project project = this.getProject();
        File file = project.file((Object)fileName);
        if (!file.exists()) {
            file = null;
        }
        return file;
    }

    private boolean _isCacheEnabled() {
        Project project = this.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        return !pluginContainer.hasPlugin("com.liferay.cache") && this.getNodeModulesCacheDir() != null;
    }

    private boolean _isCheckDigest() {
        Project project = this.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        return !pluginContainer.hasPlugin("com.liferay.cache") && this.getNodeModulesCacheDir() == null && this.getNodeModulesDigestFile() != null;
    }

    private void _npmInstall(boolean reset) throws Exception {
        Logger logger = this.getLogger();
        int npmInstallRetries = this.getNpmInstallRetries();
        Project project = this.getProject();
        for (int i = 0; i < npmInstallRetries + 1; ++i) {
            if (reset || i > 0) {
                project.delete(new Object[]{this.getNodeModulesDir()});
            }
            try {
                super.executeNode();
                break;
            }
            catch (IOException ioe) {
                if (i == npmInstallRetries) {
                    throw ioe;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn(ioe.getMessage() + ". Running \"npm install\" again");
                continue;
            }
        }
    }

    private void _npmInstallCheckDigest(boolean reset) throws Exception {
        String digest = NpmInstallTask._getNodeModulesCacheDigest(this);
        byte[] digestBytes = digest.getBytes(StandardCharsets.UTF_8);
        File nodeModulesDigestFile = this.getNodeModulesDigestFile();
        Path nodeModulesDigestPath = nodeModulesDigestFile.toPath();
        if (!reset && Files.exists(nodeModulesDigestPath, new LinkOption[0])) {
            byte[] bytes = Files.readAllBytes(nodeModulesDigestPath);
            if (!Arrays.equals(bytes, digestBytes)) {
                reset = true;
            }
        } else {
            reset = true;
        }
        this._npmInstall(reset);
        Files.write(nodeModulesDigestPath, digestBytes, new OpenOption[0]);
    }

    private void _removeShrinkwrappedUrls() throws IOException {
        File shrinkwrapJsonFile = this.getShrinkwrapJsonFile();
        Path shrinkwrapJsonPath = shrinkwrapJsonFile.toPath();
        String json = new String(Files.readAllBytes(shrinkwrapJsonPath), StandardCharsets.UTF_8);
        json = json.replaceAll("\\s+\"(?:from|resolved)\": \"http.+\",*\\r*\\n", "");
        Files.write(shrinkwrapJsonPath, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

