/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jsdoc;

import com.liferay.gradle.plugins.jsdoc.JSDocTask;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.task.DownloadNodeModuleTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;

public abstract class BaseJSDocPlugin
implements Plugin<Project> {
    public static final String DOWNLOAD_JSDOC_TASK_NAME = "downloadJSDoc";
    private static final String _VERSION = "3.6.3";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        DownloadNodeModuleTask downloadJSDocTask = this._addTaskDownloadJSDoc(project);
        this._configureTasksJSDoc(downloadJSDocTask);
    }

    private DownloadNodeModuleTask _addTaskDownloadJSDoc(Project project) {
        DownloadNodeModuleTask downloadNodeModuleTask = (DownloadNodeModuleTask)GradleUtil.addTask((Project)project, (String)DOWNLOAD_JSDOC_TASK_NAME, DownloadNodeModuleTask.class);
        downloadNodeModuleTask.args(new Object[]{"--no-save"});
        downloadNodeModuleTask.setDescription("Downloads JSDoc.");
        downloadNodeModuleTask.setModuleName((Object)"jsdoc");
        downloadNodeModuleTask.setModuleVersion((Object)_VERSION);
        return downloadNodeModuleTask;
    }

    private void _configureTaskJSDoc(JSDocTask jsDocTask, final DownloadNodeModuleTask downloadJSDocTask) {
        jsDocTask.dependsOn(new Object[]{downloadJSDocTask});
        jsDocTask.setScriptFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(downloadJSDocTask.getModuleDir(), "jsdoc.js");
            }
        });
    }

    private void _configureTasksJSDoc(final DownloadNodeModuleTask downloadJSDocTask) {
        Project project = downloadJSDocTask.getProject();
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(JSDocTask.class, (Action)new Action<JSDocTask>(){

            public void execute(JSDocTask jsDocTask) {
                BaseJSDocPlugin.this._configureTaskJSDoc(jsDocTask, downloadJSDocTask);
            }
        });
    }
}

