/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jsdoc;

import com.liferay.gradle.plugins.node.tasks.ExecuteNodeScriptTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.resources.TextResource;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class JSDocTask
extends ExecuteNodeScriptTask {
    private TextResource _configurationTextResource;
    private Object _destinationDir;
    private Object _packageJsonFile;
    private Object _readmeFile;
    private final Set<Object> _sourceDirs = new LinkedHashSet<Object>();
    private Object _tutorialsDir;

    public JSDocTask() {
        Project project = this.getProject();
        File packageJsonFile = project.file((Object)"package.json");
        if (packageJsonFile.exists()) {
            this.setPackageJsonFile(packageJsonFile);
        }
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                for (File sourceDir : JSDocTask.this.getSourceDirs()) {
                    if (!sourceDir.exists()) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Nested
    @Optional
    public TextResource getConfiguration() {
        return this._configurationTextResource;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._destinationDir);
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPackageJsonFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._packageJsonFile);
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getReadmeFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._readmeFile);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSourceDirs() {
        Project project = this.getProject();
        return project.files(new Object[]{this._sourceDirs});
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getTutorialsDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._tutorialsDir);
    }

    public void setConfiguration(TextResource configurationTextResource) {
        this._configurationTextResource = configurationTextResource;
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setPackageJsonFile(Object packageJsonFile) {
        this._packageJsonFile = packageJsonFile;
    }

    public void setReadmeFile(Object readmeFile) {
        this._readmeFile = readmeFile;
    }

    public void setSourceDirs(Iterable<Object> sourceDirs) {
        this._sourceDirs.clear();
        this.sourceDirs(sourceDirs);
    }

    public void setSourceDirs(Object ... sourceDirs) {
        this.setSourceDirs(Arrays.asList(sourceDirs));
    }

    public void setTutorialsDir(Object tutorialsDir) {
        this._tutorialsDir = tutorialsDir;
    }

    public JSDocTask sourceDirs(Iterable<Object> sourceDirs) {
        GUtil.addToCollection(this._sourceDirs, sourceDirs);
        return this;
    }

    public JSDocTask sourceDirs(Object ... sourceDirs) {
        return this.sourceDirs(Arrays.asList(sourceDirs));
    }

    protected List<String> getCompleteArgs() {
        List completeArgs = super.getCompleteArgs();
        Logger logger = this.getLogger();
        for (File sourceDir : this.getSourceDirs()) {
            completeArgs.add(this._relativize(sourceDir));
        }
        TextResource configurationTextResource = this.getConfiguration();
        if (configurationTextResource != null) {
            completeArgs.add("--configure");
            completeArgs.add(this._relativize(configurationTextResource.asFile(StandardCharsets.UTF_8.name())));
        }
        if (logger.isDebugEnabled()) {
            completeArgs.add("--debug");
        }
        this._addArg(completeArgs, "--destination", this.getDestinationDir());
        this._addArg(completeArgs, "--package", this.getPackageJsonFile());
        completeArgs.add("--recurse");
        this._addArg(completeArgs, "--readme", this.getReadmeFile());
        this._addArg(completeArgs, "--tutorials", this.getTutorialsDir());
        if (logger.isInfoEnabled()) {
            completeArgs.add("--verbose");
        }
        return completeArgs;
    }

    private void _addArg(List<String> args, String name, File file) {
        if (file == null) {
            return;
        }
        args.add(name);
        args.add(this._relativize(file));
    }

    private String _relativize(File file) {
        String relativePath = FileUtil.relativize((File)file, (File)this.getWorkingDir());
        if (File.separatorChar != '/') {
            relativePath = relativePath.replace(File.separatorChar, '/');
        }
        return relativePath;
    }
}

