/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jasper.jspc;

import jakarta.servlet.ServletContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jasper.JspC;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.TldScanner;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.gradle.api.GradleException;
import org.xml.sax.SAXException;

public class CompileJSPUtil {
    private static final Map<String, byte[]> _bytesMap = new ConcurrentHashMap<String, byte[]>();

    public static void compileJSP(final String compilerClassName, String[] completeArgs, String jspCClasspathPath) {
        JspC jspC = new JspC(){

            public String getCompilerClassName() {
                return compilerClassName;
            }

            protected TldScanner newTldScanner(JspCServletContext jspCServletContext, boolean namespaceAware, boolean validate, boolean blockExternal) {
                return CompileJSPUtil._newTldScanner(jspCServletContext, namespaceAware, validate, blockExternal);
            }
        };
        Logger logger = Logger.getLogger("org.apache.tomcat");
        logger.setLevel(Level.INFO);
        try {
            jspC.setArgs(completeArgs);
            jspC.setClassPath(jspCClasspathPath);
            jspC.execute();
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    private static TldResourcePath _newTldResourcePath(TldResourcePath tldResourcePath) {
        return new TldResourcePath(tldResourcePath.getUrl(), tldResourcePath.getWebappPath(), tldResourcePath.getEntryName()){

            public InputStream openStream() throws IOException {
                URL url = this.getUrl();
                String entryName = this.getEntryName();
                String key = url.getPath() + "#" + String.valueOf(entryName);
                byte[] bytes = (byte[])_bytesMap.get(key);
                if (bytes != null) {
                    return new ByteArrayInputStream(bytes);
                }
                if (entryName == null) {
                    try (InputStream inputStream = url.openStream();){
                        InputStream inputStream2 = CompileJSPUtil._toCachedInputStream(inputStream, key);
                        return inputStream2;
                    }
                }
                try (ZipFile zipFile = new ZipFile(url.getPath());){
                    InputStream inputStream;
                    block19: {
                        ZipEntry zipEntry = zipFile.getEntry(entryName);
                        InputStream inputStream3 = zipFile.getInputStream(zipEntry);
                        try {
                            inputStream = CompileJSPUtil._toCachedInputStream(inputStream3, key);
                            if (inputStream3 == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (inputStream3 != null) {
                                try {
                                    inputStream3.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        inputStream3.close();
                    }
                    return inputStream;
                }
            }
        };
    }

    private static TldScanner _newTldScanner(final JspCServletContext jspCServletContext, boolean namespaceAware, boolean validate, boolean blockExternal) {
        return new TldScanner((ServletContext)jspCServletContext, namespaceAware, validate, blockExternal){

            public void scanJars() {
                jspCServletContext.setAttribute(JarScanner.class.getName(), (Object)new StandardJarScanner(){

                    protected void processURLs(JarScanType jarScanType, JarScannerCallback jarScannerCallback, Set<URL> processedURLs, boolean webApp, Deque<URL> classPathUrlsToProcess) {
                        if (!webApp) {
                            classPathUrlsToProcess.clear();
                            return;
                        }
                        super.processURLs(jarScanType, jarScannerCallback, processedURLs, webApp, classPathUrlsToProcess);
                    }
                });
                super.scanJars();
            }

            protected void parseTld(TldResourcePath tldResourcePath) throws IOException, SAXException {
                super.parseTld(CompileJSPUtil._newTldResourcePath(tldResourcePath));
            }
        };
    }

    private static InputStream _toCachedInputStream(InputStream inputStream, String key) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        inputStream.transferTo(byteArrayOutputStream);
        byte[] bytes = byteArrayOutputStream.toByteArray();
        _bytesMap.put(key, bytes);
        return new ByteArrayInputStream(bytes);
    }
}

