/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jasper.jspc;

import com.liferay.gradle.plugins.jasper.jspc.JakartaTransformerJDTCompiler;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.jasper.JspC;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.TldScanner;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class CompileJSPTask
extends DefaultTask {
    private Object _destinationDir;
    private FileCollection _jspCClasspath;
    private Object _webAppDir;

    @TaskAction
    public void compileJSP() {
        FileCollection jspCClasspath = this.getJspCClasspath();
        JspC jspC = new JspC(){

            public String getCompilerClassName() {
                return CompileJSPTask.this._getCompilerClassName();
            }

            protected TldScanner newTldScanner(final JspCServletContext jspCServletContext, boolean namespaceAware, boolean validate, boolean blockExternal) {
                return new TldScanner((ServletContext)jspCServletContext, namespaceAware, validate, blockExternal){

                    public void scanJars() {
                        jspCServletContext.setAttribute(JarScanner.class.getName(), (Object)new StandardJarScanner(){

                            protected void processURLs(JarScanType scanType, JarScannerCallback callback, Set<URL> processedURLs, boolean webApp, Deque<URL> classPathUrlsToProcess) {
                                if (!webApp) {
                                    classPathUrlsToProcess.clear();
                                    return;
                                }
                                super.processURLs(scanType, callback, processedURLs, webApp, classPathUrlsToProcess);
                            }
                        });
                        super.scanJars();
                    }
                };
            }
        };
        Logger logger = Logger.getLogger("org.apache.tomcat");
        logger.setLevel(Level.INFO);
        try {
            jspC.setArgs(this._getCompleteArgs());
            jspC.setClassPath(jspCClasspath.getAsPath());
            jspC.execute();
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    @OutputDirectory
    public File getDestinationDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._destinationDir);
    }

    @Classpath
    public FileCollection getJspCClasspath() {
        return this._jspCClasspath;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileCollection getJSPFiles() {
        Project project = this.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", this.getWebAppDir());
        ArrayList<String> excludes = new ArrayList<String>(2);
        excludes.add("**/custom_jsps/**/*");
        excludes.add("**/dependencies/**/*");
        args.put("excludes", excludes);
        args.put("include", "**/*.jsp");
        return project.fileTree(args);
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getWebAppDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._webAppDir);
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setJspCClasspath(FileCollection jspCClasspath) {
        this._jspCClasspath = jspCClasspath;
    }

    public void setWebAppDir(Object webAppDir) {
        this._webAppDir = webAppDir;
    }

    private String _getCompilerClassName() {
        JavaVersion javaVersion = JavaVersion.current();
        if (!Boolean.getBoolean("build.jakarta.transformer.enabled") || javaVersion.compareTo((Enum)JavaVersion.VERSION_17) < 0) {
            return null;
        }
        String dirNames = System.getProperty("build.jakarta.transformer.include.dirs");
        if (Validator.isNull((String)dirNames)) {
            return null;
        }
        Project project = this.getProject();
        File portalModulesDir = project.getRootDir();
        Path portalModulesPath = portalModulesDir.toPath();
        File projectDir = project.getProjectDir();
        Path projectPath = projectDir.toPath();
        for (String dirName : dirNames.split(",")) {
            if (!projectPath.startsWith(portalModulesPath.resolve(dirName))) continue;
            return JakartaTransformerJDTCompiler.class.getName();
        }
        return null;
    }

    private String[] _getCompleteArgs() {
        return new String[]{"-d", FileUtil.getAbsolutePath((File)this.getDestinationDir()), "-no-strictQuoteEscaping", "-webapp", FileUtil.getAbsolutePath((File)this.getWebAppDir())};
    }
}

