/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jasper.jspc;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.jasper.JspC;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class CompileJSPTask
extends DefaultTask {
    private Object _destinationDir;
    private FileCollection _jspCClasspath;
    private Object _webAppDir;

    @TaskAction
    public void compileJSP() {
        FileCollection jspCClasspath = this.getJspCClasspath();
        JspC jspC = new JspC();
        try {
            jspC.setArgs(this._getCompleteArgs());
            jspC.setClassPath(jspCClasspath.getAsPath());
            jspC.execute();
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    @OutputDirectory
    public File getDestinationDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._destinationDir);
    }

    @Classpath
    public FileCollection getJspCClasspath() {
        return this._jspCClasspath;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileCollection getJSPFiles() {
        Project project = this.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", this.getWebAppDir());
        ArrayList<String> excludes = new ArrayList<String>(2);
        excludes.add("**/custom_jsps/**/*");
        excludes.add("**/dependencies/**/*");
        args.put("excludes", excludes);
        args.put("include", "**/*.jsp");
        return project.fileTree(args);
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getWebAppDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._webAppDir);
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setJspCClasspath(FileCollection jspCClasspath) {
        this._jspCClasspath = jspCClasspath;
    }

    public void setWebAppDir(Object webAppDir) {
        this._webAppDir = webAppDir;
    }

    private String[] _getCompleteArgs() {
        return new String[]{"-d", FileUtil.getAbsolutePath((File)this.getDestinationDir()), "-disablePooling", "-webapp", FileUtil.getAbsolutePath((File)this.getWebAppDir())};
    }
}

