/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.deployment.helper;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.util.GUtil;

@CacheableTask
public class BuildDeploymentHelperTask
extends JavaExec {
    private final List<Object> _deploymentFiles = new ArrayList<Object>();
    private Object _deploymentPath;
    private Object _outputFile;

    public BuildDeploymentHelperTask() {
        this.setMain("com.liferay.deployment.helper.DeploymentHelper");
    }

    public BuildDeploymentHelperTask deploymentFiles(Iterable<?> deploymentFiles) {
        GUtil.addToCollection(this._deploymentFiles, (Iterable[])new Iterable[]{deploymentFiles});
        return this;
    }

    public BuildDeploymentHelperTask deploymentFiles(Object ... deploymentFiles) {
        return this.deploymentFiles(Arrays.asList(deploymentFiles));
    }

    public void exec() {
        this.setArgs(this.getCompleteArgs());
        super.exec();
    }

    public FileCollection getDeploymentFiles() {
        Project project = this.getProject();
        return project.files(new Object[]{this._deploymentFiles});
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileCollection getDeploymentInputFiles() {
        Project project = this.getProject();
        ArrayList<Object> inputFiles = new ArrayList<Object>();
        for (File deploymentFile : this.getDeploymentFiles()) {
            if (deploymentFile.isDirectory()) {
                FileTree fileTree = this.getJarsFileTree(deploymentFile);
                inputFiles.add(fileTree);
                continue;
            }
            inputFiles.add(deploymentFile);
        }
        return project.files(new Object[]{inputFiles});
    }

    @Input
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getDeploymentPath() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._deploymentPath);
    }

    @OutputFile
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    public void setDeploymentFiles(Iterable<?> deploymentFiles) {
        this._deploymentFiles.clear();
        this.deploymentFiles(deploymentFiles);
    }

    public void setDeploymentFiles(Object ... deploymentFiles) {
        this.setDeploymentFiles(Arrays.asList(deploymentFiles));
    }

    public void setDeploymentPath(Object deploymentPath) {
        this._deploymentPath = deploymentPath;
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    protected List<String> getCompleteArgs() {
        ArrayList<String> completeArgs = new ArrayList<String>();
        GUtil.addToCollection(completeArgs, (Iterable[])new Iterable[]{this.getArgs()});
        completeArgs.add("--fileNames=" + this.getDeploymentFileNames());
        completeArgs.add("--outputFile=" + FileUtil.getAbsolutePath((File)this.getOutputFile()));
        File deploymentPath = this.getDeploymentPath();
        if (deploymentPath != null) {
            completeArgs.add("--path=" + FileUtil.getAbsolutePath((File)deploymentPath));
        }
        return completeArgs;
    }

    protected String getDeploymentFileNames() {
        StringBuilder sb = new StringBuilder();
        for (File file : this.getDeploymentFiles()) {
            sb.append(FileUtil.getAbsolutePath((File)file));
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    protected FileTree getJarsFileTree(File dir) {
        Project project = this.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", dir);
        args.put("include", "**/*.jar");
        return project.fileTree(args);
    }
}

