/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.dependency.checker;

import com.liferay.gradle.plugins.dependency.checker.DependencyCheckerExtension;
import com.liferay.gradle.util.GradleUtil;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.plugins.ExtensionAware;

public class DependencyCheckerPlugin
implements Plugin<Project> {
    public static final String PLUGIN_NAME = "dependencyChecker";

    public void apply(Project project) {
        final DependencyCheckerExtension dependencyCheckerExtension = (DependencyCheckerExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, DependencyCheckerExtension.class);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        configurationContainer.all((Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                DependencyCheckerPlugin.this._configureConfiguration(configuration, dependencyCheckerExtension);
            }
        });
    }

    private void _checkConfiguration(Configuration configuration, ResolutionResult resolutionResult, DependencyCheckerExtension dependencyCheckerExtension) {
        for (ResolvedComponentResult resolvedComponentResult : resolutionResult.getAllComponents()) {
            ComponentIdentifier componentIdentifier = resolvedComponentResult.getId();
            if (!(componentIdentifier instanceof ModuleComponentIdentifier)) continue;
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)componentIdentifier;
            dependencyCheckerExtension.check(configuration.getName(), moduleComponentIdentifier.getGroup(), moduleComponentIdentifier.getModule(), moduleComponentIdentifier.getVersion());
        }
    }

    private void _configureConfiguration(final Configuration configuration, final DependencyCheckerExtension dependencyCheckerExtension) {
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        resolvableDependencies.afterResolve((Action)new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                DependencyCheckerPlugin.this._checkConfiguration(configuration, resolvableDependencies.getResolutionResult(), dependencyCheckerExtension);
            }
        });
    }
}

