/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.css.builder;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.css.builder.internal.converters.PathParameterSplitter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Parameters(separators=" =")
public class CSSBuilderArgs {
    public static final boolean APPEND_CSS_IMPORT_TIMESTAMPS = true;
    public static final String BASE_DIR_NAME = "src/META-INF/resources";
    public static final String DIR_NAME = "/";
    public static final String[] EXCLUDES = new String[]{"**/_diffs/**", "**/.sass-cache*/**", "**/.sass_cache_*/**", "**/_sass_cache_*/**", "**/_styled/**", "**/_unstyled/**", "**/css/aui/**", "**/css/clay/**", "**/tmp/**"};
    public static final String OUTPUT_DIR_NAME = ".sass-cache/";
    public static final int PRECISION = 9;
    @Parameter(arity=1, description="Whether to append the current timestamp to the URLs in the @import CSS at-rules.", names={"--append-css-import-timestamps"})
    private boolean _appendCssImportTimestamps = true;
    @Parameter(description="The base directory that contains the SCSS files to compile.", names={"--base-dir"})
    private File _baseDir = new File("src/META-INF/resources");
    @Parameter(description="The name of the directories, relative to base directory, which contain the SCSS files to compile. All sub-directories are searched for SCSS files as well.", names={"--dir-names"})
    private List<String> _dirNames = Arrays.asList("/");
    @Parameter(description="The SCSS file patterns to exclude from compiling.", names={"--excludes"})
    private List<String> _excludes = Arrays.asList(EXCLUDES);
    @Parameter(arity=1, description="Whether to generate source maps for easier debugging.", names={"--generate-source-map"})
    private boolean _generateSourceMap;
    @Parameter(description="Print this message.", help=true, names={"-h", "--help"})
    private boolean _help;
    @Parameter(description="The import directories of Sass libraries.", names={"--import-paths"}, splitter=PathParameterSplitter.class)
    private List<File> _importPaths;
    @Parameter(description="The name of the sub-directories where the SCSS files are compiled to. For each directory that contains SCSS files, a sub-directory with this name is created.", names={"--output-dir"})
    private String _outputDirName = ".sass-cache/";
    @Parameter(description="The numeric precision of numbers in Sass.", names={"--precision"})
    private int _precision = 9;
    @Parameter(description="The SCSS file patterns to exclude when converting for right-to-left (RTL) support.", names={"--rtl-excluded-path-regexps"})
    private List<String> _rtlExcludedPathRegexps = new ArrayList<String>();
    @Parameter(description="The type of Sass compiler to use. Supported values are \"jni\" and \"ruby\". The Ruby Sass compiler requires \"com.liferay.sass.compiler.ruby.jar\", \"com.liferay.ruby.gems.jar\", and \"jruby-complete.jar\" to be added to the classpath.", names={"--compiler"})
    private String _sassCompilerClassName = "jni";

    public File getBaseDir() {
        return this._baseDir;
    }

    public List<String> getDirNames() {
        return this._dirNames;
    }

    public List<String> getExcludes() {
        return this._excludes;
    }

    public List<File> getImportPaths() {
        return this._importPaths;
    }

    public String getOutputDirName() {
        return this._outputDirName;
    }

    public int getPrecision() {
        return this._precision;
    }

    public List<String> getRtlExcludedPathRegexps() {
        return this._rtlExcludedPathRegexps;
    }

    public String getSassCompilerClassName() {
        return this._sassCompilerClassName;
    }

    public boolean isAppendCssImportTimestamps() {
        return this._appendCssImportTimestamps;
    }

    public boolean isGenerateSourceMap() {
        return this._generateSourceMap;
    }

    public void setAppendCssImportTimestamps(boolean appendCssImportTimestamps) {
        this._appendCssImportTimestamps = appendCssImportTimestamps;
    }

    public void setBaseDir(File baseDir) {
        this._baseDir = baseDir;
    }

    public void setDirNames(String dirNames) {
        this.setDirNames(this._split(dirNames));
    }

    public void setDirNames(String[] dirNames) {
        this._dirNames = Arrays.asList(dirNames);
    }

    public void setExcludes(String excludes) {
        this.setExcludes(this._split(excludes));
    }

    public void setExcludes(String[] excludes) {
        this._excludes = Arrays.asList(excludes);
    }

    public void setGenerateSourceMap(boolean generateSourceMap) {
        this._generateSourceMap = generateSourceMap;
    }

    public void setImportPaths(List<File> importPaths) {
        this._importPaths = importPaths;
    }

    public void setOutputDirName(String outputDirName) {
        this._outputDirName = outputDirName;
    }

    public void setPrecision(int precision) {
        this._precision = precision;
    }

    public void setRtlExcludedPathRegexps(List<String> rtlExcludedPathRegexps) {
        this._rtlExcludedPathRegexps = rtlExcludedPathRegexps;
    }

    public void setRtlExcludedPathRegexps(String rtlExcludedPathRegexps) {
        this.setRtlExcludedPathRegexps(Arrays.asList(this._split(rtlExcludedPathRegexps)));
    }

    public void setSassCompilerClassName(String sassCompilerClassName) {
        this._sassCompilerClassName = sassCompilerClassName;
    }

    protected boolean isHelp() {
        return this._help;
    }

    private String[] _split(String s) {
        return s.split(",");
    }
}

