/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.app.javadoc.builder;

import com.liferay.gradle.plugins.app.javadoc.builder.AppJavadocBuilderExtension;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;

public class AppJavadocBuilderPlugin
implements Plugin<Project> {
    public static final String APP_JAVADOC_TASK_NAME = "appJavadoc";
    public static final String JAR_APP_JAVADOC_TASK_NAME = "jarAppJavadoc";
    public static final String PLUGIN_NAME = "appJavadocBuilder";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        GradleUtil.applyPlugin((Project)project, ReportingBasePlugin.class);
        final AppJavadocBuilderExtension appJavadocBuilderExtension = (AppJavadocBuilderExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, AppJavadocBuilderExtension.class);
        ReportingExtension reportingExtension = (ReportingExtension)GradleUtil.getExtension((ExtensionAware)project, ReportingExtension.class);
        final Javadoc appJavadocTask = this._addTaskAppJavadoc(project, reportingExtension);
        this._addTaskJarAppJavadoc(appJavadocTask);
        Gradle gradle = project.getGradle();
        gradle.afterProject((Closure)new Closure<Void>((Object)project){

            public void doCall(Project subproject) {
                Set<Project> subprojects = appJavadocBuilderExtension.getSubprojects();
                if (subprojects.contains(subproject)) {
                    AppJavadocBuilderPlugin.this._configureTaskAppJavadoc(appJavadocTask, appJavadocBuilderExtension, subproject);
                }
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                AppJavadocBuilderPlugin.this._configureTaskAppJavadoc(appJavadocTask, appJavadocBuilderExtension);
            }
        });
    }

    private Javadoc _addTaskAppJavadoc(Project project, final ReportingExtension reportingExtension) {
        final Javadoc javadoc = (Javadoc)GradleUtil.addTask((Project)project, (String)APP_JAVADOC_TASK_NAME, Javadoc.class);
        javadoc.setDescription("Generates Javadoc API documentation for the app.");
        javadoc.setGroup("documentation");
        ConventionMapping conventionMapping = javadoc.getConventionMapping();
        conventionMapping.map("destinationDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                Project project = javadoc.getProject();
                return new File(project.getBuildDir(), "docs/javadoc");
            }
        });
        conventionMapping.map("title", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return reportingExtension.getApiDocTitle();
            }
        });
        StandardJavadocDocletOptions standardJavadocDocletOptions = (StandardJavadocDocletOptions)javadoc.getOptions();
        standardJavadocDocletOptions.setEncoding(StandardCharsets.UTF_8.name());
        standardJavadocDocletOptions.setGroups(new TreeMap());
        return javadoc;
    }

    private Jar _addTaskJarAppJavadoc(Javadoc javadoc) {
        Jar jar = (Jar)GradleUtil.addTask((Project)javadoc.getProject(), (String)JAR_APP_JAVADOC_TASK_NAME, Jar.class);
        jar.from(new Object[]{javadoc});
        jar.setClassifier("javadoc");
        jar.setDescription("Assembles a jar archive containing the Javadoc files for this app.");
        jar.setGroup("build");
        return jar;
    }

    private void _configureTaskAppJavadoc(Javadoc javadoc, AppJavadocBuilderExtension appJavadocBuilderExtension) {
        if (appJavadocBuilderExtension.isDoclintDisabled()) {
            CoreJavadocOptions coreJavadocOptions = (CoreJavadocOptions)javadoc.getOptions();
            coreJavadocOptions.addStringOption("Xdoclint:none", "-quiet");
        }
    }

    private void _configureTaskAppJavadoc(Javadoc javadoc, AppJavadocBuilderExtension appJavadocBuilderExtension, Project subproject) {
        Logger logger = javadoc.getLogger();
        TaskContainer taskContainer = subproject.getTasks();
        Task task = (Task)taskContainer.findByName("javadoc");
        if (!(task instanceof Javadoc)) {
            if (logger.isInfoEnabled()) {
                logger.info("Excluding {} from {} because it is not a valid Java project", new Object[]{subproject, javadoc, "javadoc"});
            }
            return;
        }
        Spec<Project> spec = appJavadocBuilderExtension.getOnlyIf();
        if (!spec.isSatisfiedBy((Object)subproject)) {
            if (logger.isInfoEnabled()) {
                logger.info("Explicitly excluding {} from {}", (Object)subproject, (Object)javadoc);
            }
            return;
        }
        Javadoc subprojectJavadoc = (Javadoc)task;
        javadoc.dependsOn(new Object[]{subprojectJavadoc});
        FileCollection classpath = javadoc.getClasspath();
        javadoc.setClasspath(classpath.plus(subprojectJavadoc.getClasspath()));
        FileTree subprojectSource = subprojectJavadoc.getSource();
        javadoc.source(new Object[]{subprojectSource});
        StandardJavadocDocletOptions standardJavadocDocletOptions = (StandardJavadocDocletOptions)javadoc.getOptions();
        if (appJavadocBuilderExtension.isCopyTags()) {
            StandardJavadocDocletOptions subprojectStandardJavadocDocletOptions = (StandardJavadocDocletOptions)subprojectJavadoc.getOptions();
            standardJavadocDocletOptions.tags(subprojectStandardJavadocDocletOptions.getTags());
        }
        if (appJavadocBuilderExtension.isGroupPackages()) {
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)subproject, (String)"main");
            SourceDirectorySet sourceDirectorySet = sourceSet.getAllJava();
            Closure<String> closure = appJavadocBuilderExtension.getGroupNameClosure();
            String groupName = (String)closure.call((Object)subproject);
            Set<String> packageNames = this._getPackageNames((Iterable<File>)subprojectSource, sourceDirectorySet.getSrcDirs());
            if (Validator.isNotNull((String)groupName) && !packageNames.isEmpty()) {
                standardJavadocDocletOptions.group(groupName, packageNames.toArray(new String[0]));
            }
        }
    }

    private String _getPackageName(File file, Set<File> srcDirs) {
        File dir = null;
        for (File srcDir : srcDirs) {
            if (!FileUtil.isChild((File)file, (File)srcDir)) continue;
            dir = srcDir;
            break;
        }
        if (dir == null) {
            return null;
        }
        String relativePath = FileUtil.relativize((File)file, dir);
        relativePath = relativePath.substring(0, relativePath.lastIndexOf(File.separatorChar));
        return relativePath.replace(File.separatorChar, '.');
    }

    private Set<String> _getPackageNames(Iterable<File> files, Set<File> srcDirs) {
        HashSet<String> packageNames = new HashSet<String>();
        for (File file : files) {
            String packageName = this._getPackageName(file, srcDirs);
            if (!Validator.isNotNull((String)packageName)) continue;
            packageNames.add(packageName);
        }
        return packageNames;
    }
}

