/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.Ports;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.LayerObject;
import com.google.cloud.tools.jib.api.buildplan.ModificationTimeProvider;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.ContainerizingMode;
import com.google.cloud.tools.jib.plugins.common.DefaultCredentialRetrievers;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InferredAuthException;
import com.google.cloud.tools.jib.plugins.common.InferredAuthProvider;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.InvalidCreationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidFilesModificationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidPlatformException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.JavaContainerBuilderHelper;
import com.google.cloud.tools.jib.plugins.common.JibBuildRunner;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.MainClassResolver;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import com.google.cloud.tools.jib.plugins.common.SkaffoldSyncMapTemplate;
import com.google.cloud.tools.jib.plugins.common.globalconfig.GlobalConfig;
import com.google.cloud.tools.jib.plugins.extension.JibPluginExtensionException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimaps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class PluginConfigurationProcessor {
    private static final ImmutableList<String> GENERATED_LAYERS = ImmutableList.of((Object)JavaContainerBuilder.LayerType.PROJECT_DEPENDENCIES.getName(), (Object)JavaContainerBuilder.LayerType.RESOURCES.getName(), (Object)JavaContainerBuilder.LayerType.CLASSES.getName());
    private static final ImmutableList<String> CONST_LAYERS = ImmutableList.of((Object)JavaContainerBuilder.LayerType.DEPENDENCIES.getName());
    private static final String DEFAULT_JETTY_APP_ROOT = "/var/lib/jetty/webapps/ROOT";

    public static JibBuildRunner createJibBuildRunnerForDockerDaemonImage(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties, GlobalConfig globalConfig, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException, MainClassInferenceException, InvalidAppRootException, IOException, InvalidWorkingDirectoryException, InvalidPlatformException, InvalidContainerVolumeException, IncompatibleBaseImageJavaVersionException, NumberFormatException, InvalidContainerizingModeException, InvalidFilesModificationTimeException, InvalidCreationTimeException, JibPluginExtensionException {
        ImageReference targetImageReference = PluginConfigurationProcessor.getGeneratedTargetDockerTag(rawConfiguration, projectProperties, helpfulSuggestions);
        DockerDaemonImage targetImage = DockerDaemonImage.named(targetImageReference);
        if (rawConfiguration.getDockerExecutable().isPresent()) {
            targetImage.setDockerExecutable(rawConfiguration.getDockerExecutable().get());
        }
        targetImage.setDockerEnvironment(rawConfiguration.getDockerEnvironment());
        Containerizer containerizer = Containerizer.to(targetImage);
        Multimaps.asMap(globalConfig.getRegistryMirrors()).forEach(containerizer::addRegistryMirrors);
        JibContainerBuilder jibContainerBuilder = PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, inferredAuthProvider, projectProperties, containerizer);
        JibContainerBuilder updatedContainerBuilder = projectProperties.runPluginExtensions(rawConfiguration.getPluginExtensions(), jibContainerBuilder).setFormat(ImageFormat.Docker);
        return JibBuildRunner.forBuildToDockerDaemon(updatedContainerBuilder, containerizer, projectProperties::log, helpfulSuggestions, targetImageReference, rawConfiguration.getToTags()).writeImageDigest(rawConfiguration.getDigestOutputPath()).writeImageId(rawConfiguration.getImageIdOutputPath()).writeImageJson(rawConfiguration.getImageJsonOutputPath());
    }

    public static JibBuildRunner createJibBuildRunnerForTarImage(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties, GlobalConfig globalConfig, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException, MainClassInferenceException, InvalidAppRootException, IOException, InvalidWorkingDirectoryException, InvalidPlatformException, InvalidContainerVolumeException, IncompatibleBaseImageJavaVersionException, NumberFormatException, InvalidContainerizingModeException, InvalidFilesModificationTimeException, InvalidCreationTimeException, JibPluginExtensionException {
        ImageReference targetImageReference = PluginConfigurationProcessor.getGeneratedTargetDockerTag(rawConfiguration, projectProperties, helpfulSuggestions);
        TarImage targetImage = TarImage.at(rawConfiguration.getTarOutputPath()).named(targetImageReference);
        Containerizer containerizer = Containerizer.to(targetImage);
        Multimaps.asMap(globalConfig.getRegistryMirrors()).forEach(containerizer::addRegistryMirrors);
        JibContainerBuilder jibContainerBuilder = PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, inferredAuthProvider, projectProperties, containerizer);
        JibContainerBuilder updatedContainerBuilder = projectProperties.runPluginExtensions(rawConfiguration.getPluginExtensions(), jibContainerBuilder);
        return JibBuildRunner.forBuildTar(updatedContainerBuilder, containerizer, projectProperties::log, helpfulSuggestions, rawConfiguration.getTarOutputPath()).writeImageDigest(rawConfiguration.getDigestOutputPath()).writeImageId(rawConfiguration.getImageIdOutputPath()).writeImageJson(rawConfiguration.getImageJsonOutputPath());
    }

    public static JibBuildRunner createJibBuildRunnerForRegistryImage(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties, GlobalConfig globalConfig, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException, MainClassInferenceException, InvalidAppRootException, IOException, InvalidWorkingDirectoryException, InvalidPlatformException, InvalidContainerVolumeException, IncompatibleBaseImageJavaVersionException, NumberFormatException, InvalidContainerizingModeException, InvalidFilesModificationTimeException, InvalidCreationTimeException, JibPluginExtensionException {
        Preconditions.checkArgument((boolean)rawConfiguration.getToImage().isPresent());
        ImageReference targetImageReference = ImageReference.parse(rawConfiguration.getToImage().get());
        RegistryImage targetImage = RegistryImage.named(targetImageReference);
        PluginConfigurationProcessor.configureCredentialRetrievers(rawConfiguration, projectProperties, targetImage, targetImageReference, "jib.to.auth.username", "jib.to.auth.password", rawConfiguration.getToAuth(), inferredAuthProvider, rawConfiguration.getToCredHelper().orElse(null));
        boolean alwaysCacheBaseImage = Boolean.parseBoolean(rawConfiguration.getProperty("jib.alwaysCacheBaseImage").orElse("false"));
        Containerizer containerizer = Containerizer.to(targetImage).setAlwaysCacheBaseImage(alwaysCacheBaseImage);
        Multimaps.asMap(globalConfig.getRegistryMirrors()).forEach(containerizer::addRegistryMirrors);
        JibContainerBuilder jibContainerBuilder = PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, inferredAuthProvider, projectProperties, containerizer);
        JibContainerBuilder updatedContainerBuilder = projectProperties.runPluginExtensions(rawConfiguration.getPluginExtensions(), jibContainerBuilder);
        return JibBuildRunner.forBuildImage(updatedContainerBuilder, containerizer, projectProperties::log, helpfulSuggestions, targetImageReference, rawConfiguration.getToTags()).writeImageDigest(rawConfiguration.getDigestOutputPath()).writeImageId(rawConfiguration.getImageIdOutputPath()).writeImageJson(rawConfiguration.getImageJsonOutputPath());
    }

    public static String getSkaffoldSyncMap(RawConfiguration rawConfiguration, ProjectProperties projectProperties, Set<Path> excludes) throws IOException, InvalidCreationTimeException, InvalidImageReferenceException, IncompatibleBaseImageJavaVersionException, InvalidPlatformException, InvalidContainerVolumeException, MainClassInferenceException, InvalidAppRootException, InvalidWorkingDirectoryException, InvalidFilesModificationTimeException, InvalidContainerizingModeException {
        JibContainerBuilder jibContainerBuilder = PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, ignored -> Optional.empty(), projectProperties);
        SkaffoldSyncMapTemplate syncMap = new SkaffoldSyncMapTemplate();
        Set<Path> excludesExpanded = PluginConfigurationProcessor.getAllFiles(excludes);
        for (LayerObject layerObject : jibContainerBuilder.toContainerBuildPlan().getLayers()) {
            Verify.verify((boolean)(layerObject instanceof FileEntriesLayer), (String)"layer types other than FileEntriesLayer not yet supported in build plan layers", (Object[])new Object[0]);
            FileEntriesLayer layer = (FileEntriesLayer)layerObject;
            if (CONST_LAYERS.contains((Object)layer.getName())) continue;
            if (GENERATED_LAYERS.contains((Object)layer.getName())) {
                layer.getEntries().stream().filter(layerEntry -> Files.isRegularFile(layerEntry.getSourceFile(), new LinkOption[0])).filter(layerEntry -> !excludesExpanded.contains(layerEntry.getSourceFile().toAbsolutePath())).forEach(syncMap::addGenerated);
                continue;
            }
            layer.getEntries().stream().filter(layerEntry -> Files.isRegularFile(layerEntry.getSourceFile(), new LinkOption[0])).filter(layerEntry -> !excludesExpanded.contains(layerEntry.getSourceFile().toAbsolutePath())).forEach(syncMap::addDirect);
        }
        return syncMap.getJsonString();
    }

    static Set<Path> getAllFiles(Set<Path> paths) throws IOException {
        HashSet<Path> expanded = new HashSet<Path>();
        for (Path path : paths) {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                expanded.add(path);
                continue;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            Stream<Path> dirWalk = Files.walk(path, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                dirWalk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(expanded::add);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dirWalk == null) continue;
                if (throwable != null) {
                    try {
                        dirWalk.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dirWalk.close();
            }
        }
        return expanded;
    }

    @VisibleForTesting
    static JibContainerBuilder processCommonConfiguration(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties) throws InvalidFilesModificationTimeException, InvalidAppRootException, IncompatibleBaseImageJavaVersionException, IOException, InvalidImageReferenceException, InvalidContainerizingModeException, MainClassInferenceException, InvalidPlatformException, InvalidContainerVolumeException, InvalidWorkingDirectoryException, InvalidCreationTimeException {
        ModificationTimeProvider modificationTimeProvider = PluginConfigurationProcessor.createModificationTimeProvider(rawConfiguration.getFilesModificationTime());
        JavaContainerBuilder javaContainerBuilder = PluginConfigurationProcessor.getJavaContainerBuilderWithBaseImage(rawConfiguration, projectProperties, inferredAuthProvider).setAppRoot(PluginConfigurationProcessor.getAppRootChecked(rawConfiguration, projectProperties)).setModificationTimeProvider(modificationTimeProvider);
        JibContainerBuilder jibContainerBuilder = projectProperties.createJibContainerBuilder(javaContainerBuilder, PluginConfigurationProcessor.getContainerizingModeChecked(rawConfiguration, projectProperties)).setFormat(rawConfiguration.getImageFormat()).setPlatforms(PluginConfigurationProcessor.getPlatformsSet(rawConfiguration)).setEntrypoint(PluginConfigurationProcessor.computeEntrypoint(rawConfiguration, projectProperties)).setProgramArguments((List<String>)rawConfiguration.getProgramArguments().orElse(null)).setEnvironment(rawConfiguration.getEnvironment()).setExposedPorts(Ports.parse(rawConfiguration.getPorts())).setVolumes(PluginConfigurationProcessor.getVolumesSet(rawConfiguration)).setLabels(rawConfiguration.getLabels()).setUser(rawConfiguration.getUser().orElse(null));
        PluginConfigurationProcessor.getWorkingDirectoryChecked(rawConfiguration).ifPresent(jibContainerBuilder::setWorkingDirectory);
        jibContainerBuilder.setCreationTime(PluginConfigurationProcessor.getCreationTime(rawConfiguration.getCreationTime(), projectProperties));
        for (RawConfiguration.ExtraDirectoriesConfiguration extraDirectoriesConfiguration : rawConfiguration.getExtraDirectories()) {
            Path from = extraDirectoriesConfiguration.getFrom();
            if (!Files.exists(from, new LinkOption[0])) continue;
            jibContainerBuilder.addFileEntriesLayer(JavaContainerBuilderHelper.extraDirectoryLayerConfiguration(from, AbsoluteUnixPath.get((String)extraDirectoriesConfiguration.getInto()), extraDirectoriesConfiguration.getIncludesList(), extraDirectoriesConfiguration.getExcludesList(), rawConfiguration.getExtraDirectoryPermissions(), modificationTimeProvider));
        }
        return jibContainerBuilder;
    }

    @VisibleForTesting
    static JibContainerBuilder processCommonConfiguration(RawConfiguration rawConfiguration, InferredAuthProvider inferredAuthProvider, ProjectProperties projectProperties, Containerizer containerizer) throws InvalidImageReferenceException, MainClassInferenceException, InvalidAppRootException, IOException, InvalidWorkingDirectoryException, InvalidPlatformException, InvalidContainerVolumeException, IncompatibleBaseImageJavaVersionException, NumberFormatException, InvalidContainerizingModeException, InvalidFilesModificationTimeException, InvalidCreationTimeException {
        JibSystemProperties.checkHttpTimeoutProperty();
        JibSystemProperties.checkProxyPortProperty();
        if (JibSystemProperties.sendCredentialsOverHttp()) {
            projectProperties.log(LogEvent.warn("Authentication over HTTP is enabled. It is strongly recommended that you do not enable this on a public network!"));
        }
        PluginConfigurationProcessor.configureContainerizer(containerizer, rawConfiguration, projectProperties);
        return PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, inferredAuthProvider, projectProperties);
    }

    @VisibleForTesting
    static JavaContainerBuilder getJavaContainerBuilderWithBaseImage(RawConfiguration rawConfiguration, ProjectProperties projectProperties, InferredAuthProvider inferredAuthProvider) throws IncompatibleBaseImageJavaVersionException, InvalidImageReferenceException, FileNotFoundException {
        String baseImageConfig;
        String string = baseImageConfig = rawConfiguration.getFromImage().isPresent() ? rawConfiguration.getFromImage().get() : PluginConfigurationProcessor.getDefaultBaseImage(projectProperties);
        if (baseImageConfig.startsWith("tar://")) {
            return JavaContainerBuilder.from(baseImageConfig);
        }
        String prefixRemoved = baseImageConfig.replaceFirst(".*://", "");
        int javaVersion = projectProperties.getMajorJavaVersion();
        if (PluginConfigurationProcessor.isKnownJava8Image(prefixRemoved) && javaVersion > 8) {
            throw new IncompatibleBaseImageJavaVersionException(8, javaVersion);
        }
        if (PluginConfigurationProcessor.isKnownJava11Image(prefixRemoved) && javaVersion > 11) {
            throw new IncompatibleBaseImageJavaVersionException(11, javaVersion);
        }
        ImageReference baseImageReference = ImageReference.parse(prefixRemoved);
        if (baseImageConfig.startsWith("docker://")) {
            DockerDaemonImage dockerDaemonImage = DockerDaemonImage.named(baseImageReference).setDockerEnvironment(rawConfiguration.getDockerEnvironment());
            if (rawConfiguration.getDockerExecutable().isPresent()) {
                dockerDaemonImage.setDockerExecutable(rawConfiguration.getDockerExecutable().get());
            }
            return JavaContainerBuilder.from(dockerDaemonImage);
        }
        RegistryImage baseImage = RegistryImage.named(baseImageReference);
        PluginConfigurationProcessor.configureCredentialRetrievers(rawConfiguration, projectProperties, baseImage, baseImageReference, "jib.from.auth.username", "jib.from.auth.password", rawConfiguration.getFromAuth(), inferredAuthProvider, rawConfiguration.getFromCredHelper().orElse(null));
        return JavaContainerBuilder.from(baseImage);
    }

    @Nullable
    @VisibleForTesting
    static List<String> computeEntrypoint(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws MainClassInferenceException, InvalidAppRootException, IOException, InvalidContainerizingModeException {
        Optional<List<String>> rawEntrypoint = rawConfiguration.getEntrypoint();
        List<String> rawExtraClasspath = rawConfiguration.getExtraClasspath();
        if (rawEntrypoint.isPresent() && !rawEntrypoint.get().isEmpty()) {
            if (rawConfiguration.getMainClass().isPresent() || !rawConfiguration.getJvmFlags().isEmpty() || !rawExtraClasspath.isEmpty() || rawConfiguration.getExpandClasspathDependencies()) {
                projectProperties.log(LogEvent.warn("mainClass, extraClasspath, jvmFlags, and expandClasspathDependencies are ignored when entrypoint is specified"));
            }
            if (rawEntrypoint.get().size() == 1 && "INHERIT".equals(rawEntrypoint.get().get(0))) {
                return null;
            }
            return rawEntrypoint.get();
        }
        if (projectProperties.isWarProject()) {
            if (rawConfiguration.getMainClass().isPresent() || !rawConfiguration.getJvmFlags().isEmpty() || !rawExtraClasspath.isEmpty() || rawConfiguration.getExpandClasspathDependencies()) {
                projectProperties.log(LogEvent.warn("mainClass, extraClasspath, jvmFlags, and expandClasspathDependencies are ignored for WAR projects"));
            }
            return rawConfiguration.getFromImage().isPresent() ? null : Arrays.asList("java", "-jar", "/usr/local/jetty/start.jar");
        }
        ArrayList<String> classpath = new ArrayList<String>(rawExtraClasspath);
        AbsoluteUnixPath appRoot = PluginConfigurationProcessor.getAppRootChecked(rawConfiguration, projectProperties);
        ContainerizingMode mode = PluginConfigurationProcessor.getContainerizingModeChecked(rawConfiguration, projectProperties);
        switch (mode) {
            case EXPLODED: {
                classpath.add(appRoot.resolve("resources").toString());
                classpath.add(appRoot.resolve("classes").toString());
                break;
            }
            case PACKAGED: {
                classpath.add(appRoot.resolve("classpath/*").toString());
                break;
            }
            default: {
                throw new IllegalStateException("unknown containerizing mode: " + (Object)((Object)mode));
            }
        }
        if (rawConfiguration.getExpandClasspathDependencies()) {
            List dependencies = projectProperties.getDependencies().stream().map(path -> appRoot.resolve("libs").resolve(path.getFileName()).toString()).collect(Collectors.toList());
            classpath.addAll(dependencies);
        } else {
            classpath.add(appRoot.resolve("libs/*").toString());
        }
        String classpathString = String.join((CharSequence)":", classpath);
        String mainClass = MainClassResolver.resolveMainClass(rawConfiguration.getMainClass().orElse(null), projectProperties);
        ArrayList<String> entrypoint = new ArrayList<String>(4 + rawConfiguration.getJvmFlags().size());
        entrypoint.add("java");
        entrypoint.addAll(rawConfiguration.getJvmFlags());
        entrypoint.add("-cp");
        entrypoint.add(classpathString);
        entrypoint.add(mainClass);
        return entrypoint;
    }

    @VisibleForTesting
    static String getDefaultBaseImage(ProjectProperties projectProperties) throws IncompatibleBaseImageJavaVersionException {
        if (projectProperties.isWarProject()) {
            return "jetty";
        }
        int javaVersion = projectProperties.getMajorJavaVersion();
        if (javaVersion <= 8) {
            return "adoptopenjdk:8-jre";
        }
        if (javaVersion <= 11) {
            return "adoptopenjdk:11-jre";
        }
        throw new IncompatibleBaseImageJavaVersionException(11, javaVersion);
    }

    @VisibleForTesting
    static Set<Platform> getPlatformsSet(RawConfiguration rawConfiguration) throws InvalidPlatformException {
        LinkedHashSet<Platform> platforms = new LinkedHashSet<Platform>();
        for (RawConfiguration.PlatformConfiguration platformConfiguration : rawConfiguration.getPlatforms()) {
            String platformToString = "architecture=" + platformConfiguration.getArchitectureName().orElse("<missing>") + ", os=" + platformConfiguration.getOsName().orElse("<missing>");
            if (!platformConfiguration.getArchitectureName().isPresent()) {
                throw new InvalidPlatformException("platform configuration is missing an architecture value", platformToString);
            }
            if (!platformConfiguration.getOsName().isPresent()) {
                throw new InvalidPlatformException("platform configuration is missing an OS value", platformToString);
            }
            platforms.add(new Platform(platformConfiguration.getArchitectureName().get(), platformConfiguration.getOsName().get()));
        }
        return platforms;
    }

    @VisibleForTesting
    static Set<AbsoluteUnixPath> getVolumesSet(RawConfiguration rawConfiguration) throws InvalidContainerVolumeException {
        HashSet<AbsoluteUnixPath> volumes = new HashSet<AbsoluteUnixPath>();
        for (String path : rawConfiguration.getVolumes()) {
            try {
                AbsoluteUnixPath absoluteUnixPath = AbsoluteUnixPath.get((String)path);
                volumes.add(absoluteUnixPath);
            }
            catch (IllegalArgumentException exception) {
                throw new InvalidContainerVolumeException(path, path, exception);
            }
        }
        return volumes;
    }

    @VisibleForTesting
    static AbsoluteUnixPath getAppRootChecked(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws InvalidAppRootException {
        String appRoot = rawConfiguration.getAppRoot();
        if (appRoot.isEmpty()) {
            appRoot = projectProperties.isWarProject() ? DEFAULT_JETTY_APP_ROOT : "/app";
        }
        try {
            return AbsoluteUnixPath.get((String)appRoot);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidAppRootException(appRoot, appRoot, ex);
        }
    }

    static ContainerizingMode getContainerizingModeChecked(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws InvalidContainerizingModeException {
        ContainerizingMode mode = ContainerizingMode.from(rawConfiguration.getContainerizingMode());
        if (mode == ContainerizingMode.PACKAGED && projectProperties.isWarProject()) {
            throw new UnsupportedOperationException("packaged containerizing mode for WAR is not yet supported");
        }
        return mode;
    }

    @VisibleForTesting
    static Optional<AbsoluteUnixPath> getWorkingDirectoryChecked(RawConfiguration rawConfiguration) throws InvalidWorkingDirectoryException {
        if (!rawConfiguration.getWorkingDirectory().isPresent()) {
            return Optional.empty();
        }
        String path = rawConfiguration.getWorkingDirectory().get();
        try {
            return Optional.of(AbsoluteUnixPath.get((String)path));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidWorkingDirectoryException(path, path, ex);
        }
    }

    @VisibleForTesting
    static ModificationTimeProvider createModificationTimeProvider(String modificationTime) throws InvalidFilesModificationTimeException {
        try {
            switch (modificationTime) {
                case "EPOCH_PLUS_SECOND": {
                    Instant epochPlusSecond = Instant.ofEpochSecond(1L);
                    return (ignored1, ignored2) -> epochPlusSecond;
                }
            }
            Instant timestamp = DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)modificationTime, Instant::from);
            return (ignored1, ignored2) -> timestamp;
        }
        catch (DateTimeParseException ex) {
            throw new InvalidFilesModificationTimeException(modificationTime, modificationTime, ex);
        }
    }

    @VisibleForTesting
    static Instant getCreationTime(String configuredCreationTime, ProjectProperties projectProperties) throws DateTimeParseException, InvalidCreationTimeException {
        try {
            switch (configuredCreationTime) {
                case "EPOCH": {
                    return Instant.EPOCH;
                }
                case "USE_CURRENT_TIMESTAMP": {
                    projectProperties.log(LogEvent.warn("Setting image creation time to current time; your image may not be reproducible."));
                    return Instant.now();
                }
            }
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_DATE_TIME).optionalStart().appendOffset("+HHmm", "+0000").optionalEnd().toFormatter();
            return formatter.parse((CharSequence)configuredCreationTime, Instant::from);
        }
        catch (DateTimeParseException ex) {
            throw new InvalidCreationTimeException(configuredCreationTime, configuredCreationTime, ex);
        }
    }

    private static void configureCredentialRetrievers(RawConfiguration rawConfiguration, ProjectProperties projectProperties, RegistryImage registryImage, ImageReference imageReference, String usernamePropertyName, String passwordPropertyName, AuthProperty rawAuthConfiguration, InferredAuthProvider inferredAuthProvider, @Nullable String credHelper) throws FileNotFoundException {
        DefaultCredentialRetrievers defaultCredentialRetrievers = DefaultCredentialRetrievers.init(CredentialRetrieverFactory.forImage(imageReference, projectProperties::log));
        Optional<Credential> optionalCredential = ConfigurationPropertyValidator.getImageCredential(projectProperties::log, usernamePropertyName, passwordPropertyName, rawAuthConfiguration, rawConfiguration);
        if (optionalCredential.isPresent()) {
            defaultCredentialRetrievers.setKnownCredential(optionalCredential.get(), rawAuthConfiguration.getAuthDescriptor());
        } else {
            try {
                Optional<AuthProperty> optionalInferredAuth = inferredAuthProvider.inferAuth(imageReference.getRegistry());
                if (optionalInferredAuth.isPresent()) {
                    AuthProperty auth = optionalInferredAuth.get();
                    String username = (String)Verify.verifyNotNull((Object)auth.getUsername());
                    String password = (String)Verify.verifyNotNull((Object)auth.getPassword());
                    Credential credential = Credential.from(username, password);
                    defaultCredentialRetrievers.setInferredCredential(credential, auth.getAuthDescriptor());
                }
            }
            catch (InferredAuthException ex) {
                projectProperties.log(LogEvent.warn("InferredAuthException: " + ex.getMessage()));
            }
        }
        defaultCredentialRetrievers.setCredentialHelper(credHelper);
        defaultCredentialRetrievers.asList().forEach(registryImage::addCredentialRetriever);
    }

    private static ImageReference getGeneratedTargetDockerTag(RawConfiguration rawConfiguration, ProjectProperties projectProperties, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException {
        return ConfigurationPropertyValidator.getGeneratedTargetDockerTag(rawConfiguration.getToImage().orElse(null), projectProperties, helpfulSuggestions);
    }

    private static void configureContainerizer(Containerizer containerizer, RawConfiguration rawConfiguration, ProjectProperties projectProperties) {
        projectProperties.configureEventHandlers(containerizer);
        containerizer.setOfflineMode(projectProperties.isOffline()).setToolName(projectProperties.getToolName()).setToolVersion(projectProperties.getToolVersion()).setAllowInsecureRegistries(rawConfiguration.getAllowInsecureRegistries()).setBaseImageLayersCache(PluginConfigurationProcessor.getCheckedCacheDirectory("jib.baseImageCache", Boolean.getBoolean("jib.useOnlyProjectCache") ? projectProperties.getDefaultCacheDirectory() : Containerizer.DEFAULT_BASE_CACHE_DIRECTORY)).setApplicationLayersCache(PluginConfigurationProcessor.getCheckedCacheDirectory("jib.applicationCache", projectProperties.getDefaultCacheDirectory()));
        rawConfiguration.getToTags().forEach(containerizer::withAdditionalTag);
    }

    private static Path getCheckedCacheDirectory(String property, Path defaultPath) {
        if (System.getProperty(property) != null) {
            return Paths.get(System.getProperty(property), new String[0]);
        }
        return defaultPath;
    }

    private static boolean isKnownJava8Image(String imageReference) {
        return imageReference.startsWith("adoptopenjdk:8");
    }

    private static boolean isKnownJava11Image(String imageReference) {
        return imageReference.startsWith("adoptopenjdk:11");
    }
}

