/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle.skaffold;

import com.google.cloud.tools.jib.gradle.skaffold.SkaffoldSyncParameters;
import com.google.cloud.tools.jib.gradle.skaffold.SkaffoldWatchParameters;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Nested;

public class SkaffoldParameters {
    private final SkaffoldWatchParameters watch;
    private final SkaffoldSyncParameters sync;

    @Inject
    public SkaffoldParameters(Project project) {
        ObjectFactory objectFactory = project.getObjects();
        this.watch = (SkaffoldWatchParameters)objectFactory.newInstance(SkaffoldWatchParameters.class, new Object[]{project});
        this.sync = (SkaffoldSyncParameters)objectFactory.newInstance(SkaffoldSyncParameters.class, new Object[]{project});
        Preconditions.checkNotNull((Object)this.watch);
    }

    public void watch(Action<? super SkaffoldWatchParameters> action) {
        action.execute((Object)this.watch);
    }

    public void sync(Action<? super SkaffoldSyncParameters> action) {
        action.execute((Object)this.sync);
    }

    @Nested
    public SkaffoldWatchParameters getWatch() {
        return this.watch;
    }

    @Nested
    public SkaffoldSyncParameters getSync() {
        return this.sync;
    }
}

