/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.api.client.http.HttpTransport;
import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.FilePermissions;
import com.google.cloud.tools.jib.gradle.JibExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.slf4j.OutputEventListenerBackedLoggerContext;
import org.slf4j.LoggerFactory;

class TaskCommon {
    @Nullable
    static TaskProvider<Task> getWarTaskProvider(Project project) {
        if (project.getPlugins().hasPlugin(WarPlugin.class)) {
            return project.getTasks().named("war");
        }
        return null;
    }

    @Nullable
    static TaskProvider<Task> getBootWarTaskProvider(Project project) {
        if (project.getPlugins().hasPlugin("org.springframework.boot")) {
            try {
                return project.getTasks().named("bootWar");
            }
            catch (UnknownTaskException unknownTaskException) {
                // empty catch block
            }
        }
        return null;
    }

    static void disableHttpLogging() {
        OutputEventListenerBackedLoggerContext context = (OutputEventListenerBackedLoggerContext)LoggerFactory.getILoggerFactory();
        OutputEventListener defaultOutputEventListener = context.getOutputEventListener();
        context.setOutputEventListener(event -> {
            LogEvent logEvent = (LogEvent)event;
            if (!logEvent.getCategory().contains("org.apache")) {
                defaultOutputEventListener.onOutput(event);
            }
        });
        Logger.getLogger(HttpTransport.class.getName()).setLevel(Level.OFF);
    }

    @Deprecated
    static void checkDeprecatedUsage(JibExtension jibExtension, org.gradle.api.logging.Logger logger) {
        if (jibExtension.extraDirectoryConfigured || System.getProperty("jib.extraDirectory.path") != null || System.getProperty("jib.extraDirectory.permissions") != null) {
            logger.warn("'jib.extraDirectory', 'jib.extraDirectory.path', and 'jib.extraDirectory.permissions' are deprecated; use 'jib.extraDirectories.paths' and 'jib.extraDirectories.permissions'");
            if (jibExtension.extraDirectoriesConfigured || System.getProperty("jib.extraDirectories.paths") != null || System.getProperty("jib.extraDirectories.permissions") != null) {
                throw new IllegalArgumentException("You cannot configure both 'jib.extraDirectory.path' and 'jib.extraDirectories.paths'");
            }
        }
        if (jibExtension.getContainer().getUseCurrentTimestamp()) {
            if (!jibExtension.getContainer().getCreationTime().equals("EPOCH")) {
                throw new IllegalArgumentException("You cannot configure both 'jib.container.useCurrentTimestamp' and 'jib.container.creationTime'");
            }
            logger.warn("'jib.container.useCurrentTimestamp' is deprecated; use 'jib.container.creationTime' with the value 'USE_CURRENT_TIMESTAMP' instead");
        }
    }

    static Map<AbsoluteUnixPath, FilePermissions> convertPermissionsMap(Map<String, String> stringMap) {
        HashMap<AbsoluteUnixPath, FilePermissions> permissionsMap = new HashMap<AbsoluteUnixPath, FilePermissions>();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            AbsoluteUnixPath key = AbsoluteUnixPath.get(entry.getKey());
            FilePermissions value = FilePermissions.fromOctalString(entry.getValue());
            permissionsMap.put(key, value);
        }
        return permissionsMap;
    }

    private TaskCommon() {
    }
}

