/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.docker.json.DockerLoadManifestEntryTemplate;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;

public class ImageTarball {
    private static final String CONTAINER_CONFIGURATION_JSON_FILE_NAME = "config.json";
    private static final String MANIFEST_JSON_FILE_NAME = "manifest.json";
    private static final String LAYER_FILE_EXTENSION = ".tar.gz";
    private final Image image;
    private final ImageReference imageReference;

    public ImageTarball(Image image, ImageReference imageReference) {
        this.image = image;
        this.imageReference = imageReference;
    }

    public void writeTo(OutputStream out) throws IOException {
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        DockerLoadManifestEntryTemplate manifestTemplate = new DockerLoadManifestEntryTemplate();
        for (Layer layer : this.image.getLayers()) {
            String layerName = layer.getBlobDescriptor().getDigest().getHash() + LAYER_FILE_EXTENSION;
            tarStreamBuilder.addBlobEntry(layer.getBlob(), layer.getBlobDescriptor().getSize(), layerName);
            manifestTemplate.addLayerFile(layerName);
        }
        JsonTemplate containerConfiguration = new ImageToJsonTranslator(this.image).getContainerConfiguration();
        tarStreamBuilder.addByteEntry(JsonTemplateMapper.toByteArray(containerConfiguration), CONTAINER_CONFIGURATION_JSON_FILE_NAME);
        manifestTemplate.setRepoTags(this.imageReference.toStringWithTag());
        tarStreamBuilder.addByteEntry(JsonTemplateMapper.toByteArray(Collections.singletonList(manifestTemplate)), MANIFEST_JSON_FILE_NAME);
        tarStreamBuilder.writeAsTarArchiveTo(out);
    }
}

