/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.CachedLayerAndName;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.image.ReproducibleLayerBuilder;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Callable;

class BuildAndCacheApplicationLayerStep
implements Callable<CachedLayerAndName> {
    private static final String DESCRIPTION = "Building %s layer";
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final String layerName;
    private final LayerConfiguration layerConfiguration;

    static ImmutableList<BuildAndCacheApplicationLayerStep> makeList(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        ImmutableList<LayerConfiguration> layerConfigurations = buildConfiguration.getLayerConfigurations();
        Throwable throwable = null;
        try (ProgressEventDispatcher progressEventDispatcher = progressEventDispatcherFactory.create("preparing application layer builders", layerConfigurations.size());){
            ImmutableList immutableList;
            TimerEventDispatcher ignored = new TimerEventDispatcher(buildConfiguration.getEventHandlers(), "Preparing application layer builders");
            Throwable throwable2 = null;
            try {
                immutableList = (ImmutableList)layerConfigurations.stream().filter(layerConfiguration -> !layerConfiguration.getLayerEntries().isEmpty()).map(layerConfiguration -> new BuildAndCacheApplicationLayerStep(buildConfiguration, progressEventDispatcher.newChildProducer(), layerConfiguration.getName(), (LayerConfiguration)layerConfiguration)).collect(ImmutableList.toImmutableList());
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored);
            return immutableList;
        }
    }

    private BuildAndCacheApplicationLayerStep(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, String layerName, LayerConfiguration layerConfiguration) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.layerName = layerName;
        this.layerConfiguration = layerConfiguration;
    }

    @Override
    public CachedLayerAndName call() throws IOException, CacheCorruptedException {
        String description = String.format(DESCRIPTION, this.layerName);
        EventHandlers eventHandlers = this.buildConfiguration.getEventHandlers();
        eventHandlers.dispatch(LogEvent.progress(description + "..."));
        Throwable throwable = null;
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("building " + this.layerName + " layer", 1L);){
            CachedLayerAndName cachedLayerAndName;
            Cache cache;
            Throwable throwable2;
            TimerEventDispatcher ignored2;
            block13: {
                ignored2 = new TimerEventDispatcher(eventHandlers, description);
                throwable2 = null;
                cache = this.buildConfiguration.getApplicationLayersCache();
                Optional<CachedLayer> optionalCachedLayer = cache.retrieve(this.layerConfiguration.getLayerEntries());
                if (!optionalCachedLayer.isPresent()) break block13;
                CachedLayerAndName cachedLayerAndName2 = new CachedLayerAndName(optionalCachedLayer.get(), this.layerName);
                BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored2);
                return cachedLayerAndName2;
            }
            try {
                Blob layerBlob = new ReproducibleLayerBuilder(this.layerConfiguration.getLayerEntries()).build();
                CachedLayer cachedLayer = cache.writeUncompressedLayer(layerBlob, this.layerConfiguration.getLayerEntries());
                eventHandlers.dispatch(LogEvent.debug(description + " built " + cachedLayer.getDigest()));
                cachedLayerAndName = new CachedLayerAndName(cachedLayer, this.layerName);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            BuildAndCacheApplicationLayerStep.$closeResource(throwable2, ignored2);
            return cachedLayerAndName;
        }
    }
}

