/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.BuildStepsRunner;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.gradle.GradleBuildLogger;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.HelpfulSuggestionsProvider;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class BuildImageTask
extends DefaultTask {
    private static final String USER_AGENT_SUFFIX = "jib-gradle-plugin";
    private static final HelpfulSuggestions HELPFUL_SUGGESTIONS = HelpfulSuggestionsProvider.get("Build image failed");
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @Option(option="image", description="The image reference for the target image")
    public void setTargetImage(String targetImage) {
        ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().setImage(targetImage);
    }

    @TaskAction
    public void buildImage() throws InvalidImageReferenceException, IOException {
        Authorization toAuthorization;
        Preconditions.checkNotNull((Object)this.jibExtension);
        GradleBuildLogger gradleBuildLogger = new GradleBuildLogger(this.getLogger());
        this.jibExtension.handleDeprecatedParameters(gradleBuildLogger);
        if (Strings.isNullOrEmpty((String)this.jibExtension.getTargetImage())) {
            throw new GradleException(HelpfulSuggestionsProvider.get("Missing target image parameter").forToNotConfigured("'jib.to.image'", "build.gradle", "gradle jib --image <your image name>"));
        }
        RegistryCredentials knownBaseRegistryCredentials = null;
        RegistryCredentials knownTargetRegistryCredentials = null;
        Authorization fromAuthorization = this.jibExtension.getFrom().getImageAuthorization();
        if (fromAuthorization != null) {
            knownBaseRegistryCredentials = new RegistryCredentials("jib.from.auth", fromAuthorization);
        }
        if ((toAuthorization = this.jibExtension.getTo().getImageAuthorization()) != null) {
            knownTargetRegistryCredentials = new RegistryCredentials("jib.to.auth", toAuthorization);
        }
        GradleProjectProperties gradleProjectProperties = GradleProjectProperties.getForProject(this.getProject(), gradleBuildLogger);
        String mainClass = gradleProjectProperties.getMainClass(this.jibExtension);
        BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.builder(gradleBuildLogger).setBaseImage(ImageReference.parse(this.jibExtension.getBaseImage())).setTargetImage(ImageReference.parse(this.jibExtension.getTargetImage())).setBaseImageCredentialHelperName(this.jibExtension.getFrom().getCredHelper()).setKnownBaseRegistryCredentials(knownBaseRegistryCredentials).setTargetImageCredentialHelperName(this.jibExtension.getTo().getCredHelper()).setKnownTargetRegistryCredentials(knownTargetRegistryCredentials).setMainClass(mainClass).setJavaArguments(this.jibExtension.getArgs()).setJvmFlags(this.jibExtension.getJvmFlags()).setExposedPorts((List<Port>)ExposedPortsParser.parse(this.jibExtension.getExposedPorts())).setTargetFormat(this.jibExtension.getFormat()).setAllowHttp(this.jibExtension.getAllowInsecureRegistries());
        if (Files.exists(this.jibExtension.getExtraDirectory().toPath(), new LinkOption[0])) {
            try (Stream<Path> extraFilesLayerDirectoryFiles = Files.list(this.jibExtension.getExtraDirectory().toPath());){
                buildConfigurationBuilder.setExtraFilesLayerConfiguration(LayerConfiguration.builder().addEntry(extraFilesLayerDirectoryFiles.collect(Collectors.toList()), "/").build());
            }
        }
        CacheConfiguration applicationLayersCacheConfiguration = CacheConfiguration.forPath(gradleProjectProperties.getCacheDirectory());
        buildConfigurationBuilder.setApplicationLayersCacheConfiguration(applicationLayersCacheConfiguration);
        if (this.jibExtension.getUseOnlyProjectCache()) {
            buildConfigurationBuilder.setBaseImageLayersCacheConfiguration(applicationLayersCacheConfiguration);
        }
        BuildConfiguration buildConfiguration = buildConfigurationBuilder.build();
        GradleBuildLogger.disableHttpLogging();
        RegistryClient.setUserAgentSuffix(USER_AGENT_SUFFIX);
        try {
            BuildStepsRunner.forBuildImage(buildConfiguration, gradleProjectProperties.getSourceFilesConfiguration()).build(HELPFUL_SUGGESTIONS);
        }
        catch (CacheDirectoryCreationException | BuildStepsExecutionException ex) {
            throw new GradleException(ex.getMessage(), ex.getCause());
        }
    }

    BuildImageTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

